/*
 * Decompiled with CFR 0.152.
 */
package carmetal.eric.GUI.palette;

import carmetal.eric.GUI.palette.JIcon;
import carmetal.eric.GUI.palette.PaletteManager;
import carmetal.eric.GUI.palette.PaletteZone;
import carmetal.eric.GUI.palette.PaletteZoneLabel;
import carmetal.eric.GUI.themes;
import carmetal.eric.JColorPicker;
import carmetal.eric.JZirkelCanvas;
import carmetal.rene.gui.Global;
import carmetal.rene.zirkel.ZirkelCanvas;
import java.awt.Color;
import java.awt.Font;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;

public class PaletteZone_Aspect
extends PaletteZone {
    private static int content_height;
    private static String[] types;
    private static String[] colors;
    private static String[] thickness;
    private static int label_lineheight;
    private static PaletteZoneLabel pointshape_label;
    private static PaletteZoneLabel aspect_label;
    private static JPanel point_name_panel;
    private static JColorPicker color_picker;

    public PaletteZone_Aspect() {
        super(Global.Loc("palette.aspect"));
        pointshape_label = this.addLabel(Global.Loc("palette.aspect.label.pointshape"));
        point_name_panel = new JPanel();
        point_name_panel.setLayout(new BoxLayout(point_name_panel, 0));
        point_name_panel.setOpaque(false);
        this.add7iconsString(types, PaletteManager.POINT_GROUP);
        this.addComponent(point_name_panel);
        aspect_label = this.addLabel("");
        Vector V = this.add7iconsString(colors, PaletteManager.ASPECT1_GROUP);
        color_picker = new JColorPicker(((JIcon)V.get(0)).getIconWidth(), 6, 3, V){

            @Override
            public void doChange() {
                JIcon.setObjectColor(this.getCurrentColor());
            }

            @Override
            public void afterSelect() {
                JIcon.setObjectColor(this.getCurrentColor());
            }

            @Override
            public void setPalettes() {
                ZirkelCanvas zc = JZirkelCanvas.getCurrentZC();
                if (zc != null) {
                    this.setUsedColors(zc.getConstruction().getSpecialColors());
                }
            }
        };
        this.addComponent(color_picker);
        this.createIcons(thickness, PaletteManager.ASPECT2_GROUP);
        this.createToggleIcon("partial");
        this.createToggleIcon("plines");
        this.createToggleIcon("showvalue");
        this.createToggleIcon("showname");
        this.createToggleIcon("bold");
        this.createToggleIcon("large");
        this.createToggleIcon("filled");
        this.createToggleIcon("obtuse");
        this.createToggleIcon("solid");
    }

    public static JColorPicker getColorPicker() {
        return color_picker;
    }

    @Override
    public void init() {
        PaletteManager.fixsize(pointshape_label, themes.getRightPanelWidth(), label_lineheight);
        PaletteManager.fixsize(aspect_label, themes.getRightPanelWidth(), label_lineheight);
        this.initPointNameBtn();
        super.init();
    }

    public void initPointNameBtn() {
        point_name_panel.removeAll();
        JZirkelCanvas JZF = JZirkelCanvas.getCurrentJZF();
        if (JZF != null) {
            point_name_panel.add(JZF.getPointLabel().getPaletteButton());
            JButton jb = JZF.getPointLabel().getPaletteButton();
            int w = themes.getPaletteIconPerRow() * themes.getPaletteIconWidth() / 7;
            PaletteManager.fixsize(jb, w, w);
            point_name_panel.add(jb);
            point_name_panel.validate();
            point_name_panel.repaint();
        }
    }

    public void setLabel(String s) {
        aspect_label.setText(s);
        this.repaint();
    }

    private PaletteZoneLabel addLabel(String mytxt) {
        PaletteZoneLabel mylabel = new PaletteZoneLabel(mytxt);
        mylabel.setOpaque(false);
        mylabel.setFont(new Font(Global.GlobalFont, 1, 11));
        mylabel.setForeground(new Color(100, 100, 100));
        mylabel.setHorizontalAlignment(0);
        this.addComponent(mylabel);
        return mylabel;
    }

    private Vector add7iconsString(String[] icns, String group) {
        Vector<JIcon> V = new Vector<JIcon>();
        for (String element : icns) {
            JIcon ji = new JIcon(element, group, 7);
            this.addIcon(ji);
            V.add(ji);
        }
        return V;
    }

    public void addColorIcons(String[] myname, String group) {
        this.add7iconsString(myname, group);
        this.addComponent(JColorPicker.margin(5));
    }

    static {
        types = new String[]{"type0", "type1", "type2", "type3", "type4", "type5"};
        colors = new String[]{"color0", "color1", "color2", "color3", "color4", "color5"};
        thickness = new String[]{"thickness0", "thickness1", "thickness2"};
        label_lineheight = 20;
    }
}

