/*
 * Decompiled with CFR 0.152.
 */
package carmetal.eric;

import carmetal.construction.Count;
import carmetal.eric.GUI.palette.PaletteManager;
import carmetal.eric.GUI.pipe_tools;
import carmetal.eric.GUI.themes;
import carmetal.eric.GUI.window.ImageFilter;
import carmetal.eric.GUI.window.LeftPanel;
import carmetal.eric.GUI.window.MainWindow;
import carmetal.eric.GUI.window.Open_left_panel_btn;
import carmetal.eric.GUI.window.Open_middle_panel_btn;
import carmetal.eric.GUI.window.Open_right_panel_btn;
import carmetal.eric.GUI.window.RightPanel;
import carmetal.eric.GUI.window.tab_btn;
import carmetal.eric.GUI.window.tab_main_panel;
import carmetal.eric.JBrowserLauncher;
import carmetal.eric.JFileFilter;
import carmetal.eric.JGeneralMenuBar;
import carmetal.eric.JZirkelCanvas;
import carmetal.eric.Media;
import carmetal.eric.OS;
import carmetal.eric.Progress_Bar;
import carmetal.eric.bar.JPropertiesBar;
import carmetal.rene.dialogs.ExportPictureDlg;
import carmetal.rene.dialogs.Warning;
import carmetal.rene.gui.Global;
import carmetal.rene.util.FileName;
import carmetal.rene.util.ImageSelection;
import carmetal.rene.util.PngEncoder;
import carmetal.rene.zirkel.ZirkelCanvas;
import carmetal.rene.zirkel.ZirkelFrame;
import carmetal.rene.zirkel.graphics.MyGraphics13;
import carmetal.rene.zirkel.graphics.MyGraphicsEPS;
import carmetal.rene.zirkel.graphics.MyGraphicsSvg;
import java.awt.Color;
import java.awt.FileDialog;
import java.awt.Image;
import java.awt.datatransfer.Clipboard;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileSystemView;

public class FileTools {
    private static int dlogW = 500;
    private static int dlogH = 400;
    private static ArrayList<String> StartupFiles = new ArrayList();
    private static boolean isStartup = true;

    public static void addStartupFile(String filename) {
        StartupFiles.add(filename);
    }

    public static boolean isStartup() {
        return isStartup;
    }

    public static String getCurrentFileSource() throws Exception {
        ZirkelCanvas zc = JZirkelCanvas.getCurrentZC();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        zc.save(out, true, true, false, true, zc.getMacros(), "");
        return out.toString("utf-8");
    }

    public static void setCurrentFileSource(String s) throws Exception {
        final ZirkelCanvas zc = JZirkelCanvas.getCurrentZC();
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)bout, "utf-8"));
        out.print(s);
        out.close();
        byte[] b2 = bout.toByteArray();
        ByteArrayInputStream in = new ByteArrayInputStream(b2);
        zc.clear();
        zc.removeAllScripts();
        Count.resetAll();
        zc.clearDrawings();
        zc.load(in, true, true);
        zc.validate();
        zc.repaint();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                zc.JCM.readXmlTags();
            }
        });
    }

    public static void HTMLWorkBookExport() {
        String content = "";
        if (!JZirkelCanvas.isWorkBook()) {
            FileTools.saveWorkBookAs();
        }
        if (JZirkelCanvas.isWorkBook()) {
            FileTools.saveWorkBook(JZirkelCanvas.getWorkBookFileName());
            String targetpath = FileName.path(JZirkelCanvas.getWorkBookFileName());
            String sep = System.getProperty("file.separator");
            try {
                String str;
                InputStream input = FileTools.class.getResourceAsStream("/carmetal.eric/docs/applet.html");
                BufferedReader in = new BufferedReader(new InputStreamReader(input));
                while ((str = in.readLine()) != null) {
                    content = content + str + "\n";
                }
                in.close();
            }
            catch (Exception e2) {
                return;
            }
            content = content.replace("@width@", "" + (pipe_tools.getWindowSize().width - 2 * themes.getVerticalBorderWidth()));
            content = content.replace("@height@", "" + (pipe_tools.getWindowSize().height - themes.getMenuBarHeight() - themes.getTitleBarHeight()));
            content = content.replace("@file@", FileName.filename(JZirkelCanvas.getWorkBookFileName()));
            content = content.replace("@workbook@", FileName.filename(JZirkelCanvas.getWorkBookFileName()));
            try {
                File aFile = new File(targetpath + sep + "index.html");
                BufferedWriter output = new BufferedWriter(new FileWriter(aFile));
                output.write(content);
                ((Writer)output).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void SaveJarAndLaunchBrowser() {
        JZirkelCanvas jzc = JZirkelCanvas.getCurrentJZF();
        if (jzc == null) {
            return;
        }
        if (JZirkelCanvas.getFileName() == null) {
            return;
        }
        String targetpath = FileName.path(JZirkelCanvas.getFileName());
        String targetfile = "index.html";
        String sep = System.getProperty("file.separator");
        String mypath = Global.AppPath();
        if (new File(mypath + "CaRMetal.jar").exists()) {
            try {
                int len;
                FileInputStream in = new FileInputStream(mypath + "CaRMetal.jar");
                FileOutputStream out = new FileOutputStream(targetpath + sep + "CaRMetal.jar");
                byte[] buf = new byte[1024];
                while ((len = ((InputStream)in).read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                    out.flush();
                }
                ((OutputStream)out).close();
                ((InputStream)in).close();
                JBrowserLauncher.openURL(targetpath + sep + targetfile);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static String getSwingOpenFile() {
        String name = null;
        JFileChooser jfc = new JFileChooser(Global.getOpenSaveDirectory());
        jfc.setDialogType(0);
        jfc.setAcceptAllFileFilterUsed(false);
        JFileFilter filter = new JFileFilter(Global.Loc("filedialog.allfiles"), ".zirs,.zir,.zirz,.mcr,.job,.js");
        jfc.addChoosableFileFilter(filter);
        jfc.setFileFilter(filter);
        filter = new JFileFilter(Global.Loc("filedialog.filefilter"), ".zir");
        jfc.addChoosableFileFilter(filter);
        filter = new JFileFilter(Global.Loc("filedialog.workbook"), ".zirs");
        jfc.addChoosableFileFilter(filter);
        filter = new JFileFilter(Global.Loc("filedialog.compressedfilefilter"), ".zirz");
        jfc.addChoosableFileFilter(filter);
        filter = new JFileFilter(Global.Loc("filedialog.macrofilefilter"), ".mcr");
        jfc.addChoosableFileFilter(filter);
        filter = new JFileFilter(Global.Loc("filedialog.job"), ".job");
        jfc.addChoosableFileFilter(filter);
        filter = new JFileFilter(Global.Loc("filedialog.js"), ".js");
        jfc.addChoosableFileFilter(filter);
        int rep = jfc.showOpenDialog(pipe_tools.getFrame());
        if (rep == 0) {
            name = jfc.getSelectedFile().getAbsolutePath();
            Global.setOpenSaveDirectory(FileName.path(name));
        }
        return name;
    }

    public static String getAWTOpenFile() {
        String name = "";
        FileDialog fd = new FileDialog(pipe_tools.getFrame(), Global.Loc("filedialog.open"), 0);
        fd.setFilenameFilter(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".js") || name.endsWith(".mcr") || name.endsWith(".zir") || name.endsWith(".zirs") || name.endsWith(".zirz") || name.endsWith(".job") || name.endsWith(".jobz");
            }
        });
        fd.setDirectory(Global.getOpenSaveDirectory());
        fd.setSize(dlogW, dlogH);
        fd.pack();
        fd.setVisible(true);
        if (fd.getFile() != null) {
            Global.setOpenSaveDirectory(fd.getDirectory());
        }
        return FileTools.canonicFileName(fd);
    }

    public static String getOpenFile() {
        if (OS.isUnix()) {
            return FileTools.getSwingOpenFile();
        }
        return FileTools.getAWTOpenFile();
    }

    public static String getSwingSaveFile() {
        String name = null;
        JFileChooser jfc = new JFileChooser(Global.getOpenSaveDirectory());
        jfc.setDialogType(1);
        jfc.setAcceptAllFileFilterUsed(false);
        JFileFilter filter = new JFileFilter(Global.Loc("filedialog.allfiles"), ".zirs,.zir,.zirz,.mcr,.job");
        jfc.addChoosableFileFilter(filter);
        jfc.setFileFilter(filter);
        int rep = jfc.showSaveDialog(pipe_tools.getFrame());
        if (rep == 0) {
            name = jfc.getSelectedFile().getAbsolutePath();
            Global.setOpenSaveDirectory(FileName.path(name));
        }
        return name;
    }

    public static String getAWTSaveFile() {
        String name = "";
        FileDialog fd = new FileDialog(pipe_tools.getFrame(), Global.Loc("filedialog.save"), 1);
        fd.setFilenameFilter(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".js") || name.endsWith(".mcr") || name.endsWith(".zir") || name.endsWith(".zirs") || name.endsWith(".zirz") || name.endsWith(".job") || name.endsWith(".jobz");
            }
        });
        fd.setDirectory(Global.getOpenSaveDirectory());
        fd.setSize(dlogW, dlogH);
        fd.pack();
        fd.setVisible(true);
        if (fd.getFile() != null) {
            Global.setOpenSaveDirectory(fd.getDirectory());
        }
        return FileTools.canonicFileName(fd);
    }

    public static String getSaveFile() {
        if (OS.isUnix()) {
            return FileTools.getSwingSaveFile();
        }
        return FileTools.getAWTSaveFile();
    }

    public static String canonicFileName(FileDialog fd) {
        if (fd.getFile() == null) {
            return null;
        }
        String path = fd.getDirectory().endsWith(System.getProperty("file.separator")) ? fd.getDirectory() : fd.getDirectory() + System.getProperty("file.separator");
        path = path + fd.getFile();
        return path;
    }

    public static boolean validPreferencesFileName(String name) {
        return name.endsWith("preferences.txt");
    }

    public static boolean validZirkelFileName(String name) {
        String nme = name.toLowerCase();
        return nme.endsWith(".zir") || nme.endsWith(".zirz") || nme.endsWith(".job") || nme.endsWith(".jobz");
    }

    public static boolean validImageFileName(String name) {
        String nme = name.toLowerCase();
        return nme.endsWith(".tif") || nme.endsWith(".tiff") || nme.endsWith(".gif") || nme.endsWith(".png") || nme.endsWith(".jpg") || nme.endsWith(".jpeg");
    }

    public static void openFile() {
        String filename = FileTools.getOpenFile();
        if (filename != null) {
            if (filename.endsWith(".zirs")) {
                FileTools.openWorkBook(filename);
            } else if (filename.endsWith(".mcr")) {
                FileTools.openMacro(filename);
            } else {
                FileTools.openFile(filename, null, false);
            }
        }
    }

    public static void doLoad(String filename, InputStream in, boolean with3D) {
        JZirkelCanvas JZF = JZirkelCanvas.getCurrentJZF();
        ZirkelFrame ZF = JZirkelCanvas.getCurrentZF();
        final ZirkelCanvas ZC = JZirkelCanvas.getCurrentZC();
        if (ZC != null) {
            ZC.set3D(with3D);
            ZF.setinfo("save");
            ZC.getConstruction().BackgroundFile = null;
            ZF.Background = "";
            ZC.grab(false);
            Count.resetAll();
            ZF.doload(filename, in);
            PaletteManager.fix3Dpalette();
            ZC.getLocalPreferences();
            Count.resetAll();
            pipe_tools.setWindowComponents();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ZC.JCM.readXmlTags();
                    PaletteManager.refresh();
                    PaletteManager.setSelected_with_clic("move", true);
                }
            });
        }
    }

    public static void openMacro(String filename) {
        try {
            FileInputStream o = new FileInputStream(filename);
            JZirkelCanvas.getCurrentZC().load(o, false, true);
            o.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        JZirkelCanvas.ActualiseMacroPanel();
    }

    public static void openFile(String filename, InputStream in, boolean with3D) {
        if (JZirkelCanvas.getCurrentZC() == null) {
            return;
        }
        if (filename == null) {
            return;
        }
        if (filename.endsWith(".zir") || filename.endsWith(".zirz")) {
            if (JZirkelCanvas.getCurrentZC().isEmpty()) {
                tab_main_panel.setCurrentTabName(FileName.filename(filename), filename);
            } else {
                tab_main_panel.createTabAndCanvas(FileName.filename(filename), filename);
            }
        }
        FileTools.doLoad(filename, in, with3D);
        JZirkelCanvas.getCurrentJZF().setComments();
        JZirkelCanvas.ActualiseMacroPanel();
    }

    public static void New3DWindow() {
        InputStream o = FileTools.class.getResourceAsStream("carmetal/base3D.zir");
        String Filename = "base3D.zir";
        if (!JZirkelCanvas.getCurrentZC().isEmpty()) {
            tab_main_panel.newTabBtn();
        }
        FileTools.doLoad("base3D.zir", o, true);
        ZirkelFrame zf = JZirkelCanvas.getCurrentZF();
        if (zf != null) {
            zf.Filename = "";
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ZirkelCanvas zc = JZirkelCanvas.getCurrentZC();
                if (zc != null) {
                    zc.JCM.fix3Dcomments();
                }
            }
        });
    }

    public static void saveFileAs() {
        if (Media.getMedias().size() > 0) {
            JOptionPane.showMessageDialog(JZirkelCanvas.getCurrentZC(), Global.Loc("media.saveas"));
            FileTools.saveWorkBookAs();
        } else {
            String filename = FileTools.getSaveFile();
            if (filename != null) {
                FileTools.saveFile(filename, false, ".zir", false);
            }
        }
    }

    public static void saveFile() {
        if (JZirkelCanvas.isWorkBook()) {
            FileTools.saveWorkBook(JZirkelCanvas.getWorkBookFileName());
        } else if (Media.getMedias().size() > 0) {
            JOptionPane.showMessageDialog(JZirkelCanvas.getCurrentZC(), Global.Loc("media.saveas"));
            FileTools.saveWorkBookAs();
        } else {
            String filename;
            if (JZirkelCanvas.getCurrentZC() == null) {
                return;
            }
            ZirkelFrame ZF = JZirkelCanvas.getCurrentZF();
            ZirkelCanvas ZC = JZirkelCanvas.getCurrentZC();
            String string = filename = ZF.haveFile() ? ZF.Filename : FileTools.getSaveFile();
            if (filename != null) {
                FileTools.saveFile(filename, false, ".zir", !ZF.haveFile());
            }
        }
    }

    private static boolean ICanSave(String Fname, boolean ask) {
        if (!ask) {
            return true;
        }
        if (!new File(Fname).exists()) {
            return true;
        }
        return JOptionPane.showConfirmDialog(null, Global.Loc("filedialog.savemessage1") + Fname + Global.Loc("filedialog.savemessage2"), "", 0) == 0;
    }

    private static void doSave(ZirkelCanvas zc, String Filename, OutputStream o) {
        try {
            if (o == null) {
                o = new FileOutputStream(Filename);
                if (ZirkelFrame.isCompressed(Filename)) {
                    o = new GZIPOutputStream(o, 10000);
                }
            }
            zc.save(o, true, true, false, true, zc.getMacros(), "");
            o.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void saveFile(String Filename, boolean restrict, String ext, boolean ask) {
        if (JZirkelCanvas.getCurrentZC() == null) {
            return;
        }
        if (Filename == null) {
            return;
        }
        ZirkelFrame ZF = JZirkelCanvas.getCurrentZF();
        ZirkelCanvas ZC = JZirkelCanvas.getCurrentZC();
        if (!Filename.endsWith(".zirz") && !Filename.endsWith(".zir")) {
            Filename = Filename + ext;
        }
        if (FileTools.ICanSave(Filename, ask)) {
            try {
                ZF.ZC.getConstruction().BackgroundFile = ZF.Background;
                ZF.ZC.getConstruction().ResizeBackground = Global.getParameter("background.usesize", false);
                FileTools.doSave(ZF.ZC, Filename, null);
                ZF.Filename = Filename;
                tab_main_panel.setCurrentTabName(FileName.filename(Filename), Filename);
            }
            catch (Exception e2) {
                Warning w = new Warning(pipe_tools.getFrame(), Global.Loc("warning.save"), FileName.chop(32, e2.toString(), 64), Global.Loc("warning"), true);
                w.center(null);
                w.setVisible(true);
            }
        }
        pipe_tools.TabHaveChanged(false);
    }

    public static String getConstruction(ZirkelCanvas zc) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            FileTools.doSave(zc, null, out);
            return out.toString("utf-8");
        }
        catch (Exception ex) {
            return "Error";
        }
    }

    public static String convertStreamToString(InputStream is) {
        if (is != null) {
            StringBuilder sb = new StringBuilder();
            try {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                while ((line = reader.readLine()) != null) {
                    sb.append(line).append("\n");
                }
                is.close();
            }
            catch (Exception e2) {
                return null;
            }
            return sb.toString();
        }
        return null;
    }

    public static void saveWorkBookAs() {
        String filename = FileTools.getSaveFile();
        if (filename != null) {
            FileTools.saveWorkBook(filename);
        }
    }

    public static void saveWorkBook(String filename) {
        if (filename == null) {
            return;
        }
        if (!filename.endsWith(".zirs")) {
            filename = filename + ".zirs";
        }
        try {
            int i;
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(filename));
            Progress_Bar.create(Global.Loc("progressbar.workbooksavemessage"), 0, tab_main_panel.getBTNSsize() - 1);
            for (i = 0; i < tab_main_panel.getBTNSsize(); ++i) {
                tab_btn btn = tab_main_panel.getBTN(i);
                ZirkelCanvas ZC = btn.getPanel().getZC();
                out.putNextEntry(new ZipEntry(btn.getTabName() + ".zir"));
                if (btn.getPanel().getByteArrayInputFile() == null) {
                    ByteArrayOutputStream file = new ByteArrayOutputStream();
                    FileTools.doSave(ZC, null, file);
                    out.write(file.toByteArray());
                } else {
                    out.write(btn.getPanel().getByteArrayInputFile());
                }
                out.flush();
                out.closeEntry();
                Progress_Bar.nextValue();
            }
            for (i = 0; i < Media.getMedias().size(); ++i) {
                out.putNextEntry(new ZipEntry(Media.getMedias().get(i).getImageFileName()));
                out.write(Media.getMedias().get(i).getImageBytes());
            }
            out.putNextEntry(new ZipEntry("preferences.txt"));
            out.write(FileTools.createPreferencesFile());
            Progress_Bar.close();
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        JZirkelCanvas.setWorkBookFileName(filename, true);
    }

    public static byte[] createPreferencesFile() {
        String file = "** COMMON PART (APPLET and Application) :\n";
        file = file + "\n";
        file = file + "showcomments=" + Global.getParameter("comment", true) + "\n";
        file = file + "showpalette=" + RightPanel.isPanelVisible() + "\n";
        file = file + "showleftpanel=" + LeftPanel.isPanelVisible() + "\n";
        file = file + "showtabs=" + (tab_main_panel.getBTNSsize() > 1) + "\n";
        file = file + "showstatus=" + (tab_main_panel.getBTNSsize() > 1) + "\n";
        file = file + "currenttab=" + (tab_main_panel.getActiveBtnPos() + 1);
        file = file + "\n\n\n";
        file = file + "** APPLICATION SPECIFIC PART :\n";
        file = file + "\n";
        file = file + "window_width=" + pipe_tools.getWindowSize().width + "\n";
        file = file + "window_height=" + pipe_tools.getWindowSize().height + "\n";
        file = file + "\n";
        return file.getBytes();
    }

    public static void openWorkBook() {
        String filename = FileTools.getOpenFile();
        if (filename != null) {
            FileTools.openWorkBook(filename);
        }
    }

    public static void openWorkBook(String filename) {
        try {
            ZipFile zpf = new ZipFile(filename);
            String prefsFileContent = null;
            Progress_Bar.create(Global.Loc("progressbar.workbookloadmessage"), 0, Collections.list(zpf.entries()).size());
            Enumeration<? extends ZipEntry> entries = zpf.entries();
            tab_btn lastbtn = tab_main_panel.getLastBtn();
            int last_tab_pos = tab_main_panel.getBTNSsize() - 1;
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (FileTools.validZirkelFileName(entry.getName())) {
                    tab_btn curbtn = tab_main_panel.addBtn(entry.getName());
                    curbtn.getPanel().setInputFile(zpf.getInputStream(entry));
                } else if (FileTools.validImageFileName(entry.getName())) {
                    Media.createMedia(entry.getName(), FileTools.copyToByteArray(zpf.getInputStream(entry)));
                } else if (FileTools.validPreferencesFileName(entry.getName())) {
                    prefsFileContent = FileTools.convertStreamToString(zpf.getInputStream(entry));
                }
                Progress_Bar.nextValue();
            }
            JZirkelCanvas.setWorkBookFileName(filename, false);
            Progress_Bar.close();
            if (prefsFileContent != null) {
                FileTools.applyWorkBookPreferences(prefsFileContent, last_tab_pos);
            } else {
                tab_main_panel.setActiveBtn(1);
                tab_main_panel.showActiveBtn();
            }
            if (lastbtn.getPanel().getZC().isEmpty() && lastbtn.getPanel().getByteArrayInputFile() == null) {
                tab_main_panel.removeBtn(lastbtn);
            }
            pipe_tools.setWindowComponents();
            pipe_tools.setWindowComponents();
            Open_left_panel_btn.setmode();
            Open_middle_panel_btn.setmode();
            Open_right_panel_btn.setmode();
            JGeneralMenuBar.initToggleItems();
            tab_main_panel.initToggleItems();
        }
        catch (Exception e2) {
            return;
        }
    }

    public static String getPref(String prefs, String property) {
        Matcher m = Pattern.compile("\\Q" + property + "=\\E(\\w+)\\W", 8).matcher(prefs);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    public static void applyWorkBookPreferences(String prefs, int last_tab_pos) {
        int tabnum = last_tab_pos;
        try {
            tabnum += Integer.parseInt(FileTools.getPref(prefs, "currenttab"));
        }
        catch (Exception e2) {
            tabnum = last_tab_pos;
        }
        tab_main_panel.setActiveBtn(tabnum);
        tab_main_panel.showActiveBtn();
        Global.setParameter("comment", "true".equals(FileTools.getPref(prefs, "showcomments")));
        RightPanel.showPanel("true".equals(FileTools.getPref(prefs, "showpalette")));
        LeftPanel.showPanel("true".equals(FileTools.getPref(prefs, "showleftpanel")));
        if (pipe_tools.isApplet()) {
            themes.setShowTabs("true".equals(FileTools.getPref(prefs, "showtabs")));
            themes.setShowStatus("true".equals(FileTools.getPref(prefs, "showstatus")));
        } else {
            themes.setShowTabs(true);
            themes.setShowStatus(true);
        }
        try {
            int w = Integer.parseInt(FileTools.getPref(prefs, "window_width"));
            int h = Integer.parseInt(FileTools.getPref(prefs, "window_height"));
            pipe_tools.setAndCheckWindowSize(w, h);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void openWorkBook(URL url) {
        try {
            ZipInputStream zpf = new ZipInputStream(url.openStream());
            int length = 0;
            ZipEntry entry = zpf.getNextEntry();
            while (entry != null) {
                ++length;
                entry = zpf.getNextEntry();
            }
            Progress_Bar.create(Global.Loc("progressbar.workbookloadmessage"), 0, length);
            zpf = new ZipInputStream(url.openStream());
            String prefsFileContent = null;
            tab_btn lastbtn = tab_main_panel.getLastBtn();
            ZipEntry entry2 = zpf.getNextEntry();
            while (entry2 != null) {
                ByteArrayOutputStream outBuffer;
                if (FileTools.validZirkelFileName(entry2.getName())) {
                    int read;
                    tab_btn curbtn = tab_main_panel.addBtn(entry2.getName());
                    ByteArrayOutputStream outBuffer2 = new ByteArrayOutputStream();
                    while ((read = zpf.read()) != -1) {
                        outBuffer2.write(read);
                    }
                    curbtn.getPanel().setInputFile(outBuffer2.toByteArray());
                } else if (FileTools.validImageFileName(entry2.getName())) {
                    int read;
                    outBuffer = new ByteArrayOutputStream();
                    while ((read = zpf.read()) != -1) {
                        outBuffer.write(read);
                    }
                    Media.createMedia(entry2.getName(), outBuffer.toByteArray());
                } else if (FileTools.validPreferencesFileName(entry2.getName())) {
                    int read;
                    outBuffer = new ByteArrayOutputStream();
                    while ((read = zpf.read()) != -1) {
                        outBuffer.write(read);
                    }
                    prefsFileContent = new String(outBuffer.toByteArray());
                }
                entry2 = zpf.getNextEntry();
            }
            Progress_Bar.close();
            JZirkelCanvas.setWorkBookFileName(url.getFile(), false);
            if (prefsFileContent != null) {
                FileTools.applyWorkBookPreferences(prefsFileContent, 0);
            } else {
                tab_main_panel.setActiveBtn(0);
                tab_main_panel.showActiveBtn();
            }
            if (lastbtn.getPanel().getZC().isEmpty() && lastbtn.getPanel().getByteArrayInputFile() == null) {
                tab_main_panel.removeBtn(lastbtn);
            }
            pipe_tools.setWindowComponents();
            pipe_tools.setWindowComponents();
            Open_left_panel_btn.setmode();
            Open_middle_panel_btn.setmode();
            Open_right_panel_btn.setmode();
            JGeneralMenuBar.initToggleItems();
            tab_main_panel.initToggleItems();
        }
        catch (Exception e2) {
            System.out.println("Workbook reading error");
            return;
        }
    }

    public static byte[] copyToByteArray(InputStream in) {
        int BUFFER_SIZE = 4096;
        ByteArrayOutputStream out = new ByteArrayOutputStream(BUFFER_SIZE);
        try {
            int byteCount = 0;
            byte[] buffer = new byte[BUFFER_SIZE];
            int bytesRead = -1;
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
                byteCount += bytesRead;
            }
            out.flush();
            in.close();
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toByteArray();
    }

    public static void open(String filename) {
        if (filename.endsWith(".mcr")) {
            FileTools.openMacro(filename);
        } else if (filename.endsWith(".zirs")) {
            FileTools.openWorkBook(filename);
        } else {
            FileTools.openFile(filename, null, false);
        }
    }

    public static void OpenStartupFiles() {
        for (int i = 0; i < StartupFiles.size(); ++i) {
            String filename = StartupFiles.get(i);
            FileTools.open(filename);
        }
        StartupFiles.clear();
    }

    public static void FirstRun() {
        if (isStartup) {
            JPropertiesBar.CreatePopertiesBar();
            MainWindow mw = new MainWindow();
            PaletteManager.init();
            PaletteManager.setSelected_with_clic("point", true);
            JZirkelCanvas.ActualiseMacroPanel();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FileTools.OpenStartupFiles();
            }
        });
        isStartup = false;
    }

    public static void savepng(boolean issave) {
        ZirkelFrame ZF = JZirkelCanvas.getCurrentZF();
        if (ZF == null) {
            return;
        }
        if (issave) {
            ExportPictureDlg dlg = new ExportPictureDlg(pipe_tools.getFrame());
            dlg.setPictureWidth(ZF.ZC.getSize().width);
            dlg.setPictureHeight(ZF.ZC.getSize().height);
            dlg.setPercentScale(100);
            if (dlg.select()) {
                ZF.ZC.startWaiting();
                double Scale = (double)dlg.getPercentScale() / 100.0;
                int w = (int)((double)ZF.ZC.getSize().width * Scale);
                int h = (int)((double)ZF.ZC.getSize().height * Scale);
                ZF.ZC.PointSize = (int)((double)Global.getParameter("minpointsize", 3) * Scale);
                ZF.ZC.FontSize = (int)((double)Global.getParameter("minfontsize", 12) * Scale);
                ZF.ZC.IW = w;
                ZF.ZC.IH = h;
                Image I = ZF.ZC.createImage(w, h);
                MyGraphics13 IG = new MyGraphics13(I.getGraphics(), Scale, ZF.ZC, null);
                IG.setSize(w, h);
                IG.setDefaultFont((int)ZF.ZC.FontSize, Global.getParameter("font.large", false), Global.getParameter("font.bold", false));
                ZF.ZC.recompute();
                IG.clearRect(0, 0, w, h, Color.white);
                ZF.ZC.dopaint(IG);
                ZF.ZC.endWaiting();
                int dpi = 300;
                try {
                    BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(dlg.getFileName()));
                    PngEncoder png = new PngEncoder(I, false, 0, 9);
                    png.setDPI(300.0);
                    out.write(png.pngEncode());
                    out.close();
                }
                catch (Exception exception) {}
            }
        } else {
            ZF.ZC.startWaiting();
            int Scale = 3;
            int w = ZF.ZC.getSize().width * Scale;
            int h = ZF.ZC.getSize().height * Scale;
            ZF.ZC.PointSize = Global.getParameter("minpointsize", 3) * Scale;
            ZF.ZC.FontSize = Global.getParameter("minfontsize", 12) * Scale;
            ZF.ZC.IW = w;
            ZF.ZC.IH = h;
            Image I = ZF.ZC.createImage(w, h);
            MyGraphics13 IG = new MyGraphics13(I.getGraphics(), Scale, ZF.ZC, null);
            IG.setSize(w, h);
            IG.setDefaultFont((int)ZF.ZC.FontSize, Global.getParameter("font.large", false), Global.getParameter("font.bold", false));
            ZF.ZC.recompute();
            IG.clearRect(0, 0, w, h, Color.white);
            ZF.ZC.dopaint(IG);
            ZF.ZC.endWaiting();
            try {
                Clipboard clipboard = pipe_tools.getFrame().getToolkit().getSystemClipboard();
                ImageSelection is = new ImageSelection(I);
                clipboard.setContents(is, null);
            }
            catch (Exception e2) {
                Scale = 1;
                I = null;
                JOptionPane.showMessageDialog(null, "Sorry : error occured while copying...");
            }
        }
    }

    public static void savepng(String filename) {
        ZirkelFrame ZF = JZirkelCanvas.getCurrentZF();
        if (ZF == null) {
            return;
        }
        ZF.ZC.startWaiting();
        double Scale = 1.0;
        int w = (int)((double)ZF.ZC.getSize().width * 1.0);
        int h = (int)((double)ZF.ZC.getSize().height * 1.0);
        ZF.ZC.PointSize = (int)((double)Global.getParameter("minpointsize", 3) * 1.0);
        ZF.ZC.FontSize = (int)((double)Global.getParameter("minfontsize", 12) * 1.0);
        ZF.ZC.IW = w;
        ZF.ZC.IH = h;
        Image I = ZF.ZC.createImage(w, h);
        MyGraphics13 IG = new MyGraphics13(I.getGraphics(), 1.0, ZF.ZC, null);
        IG.setSize(w, h);
        IG.setDefaultFont((int)ZF.ZC.FontSize, Global.getParameter("font.large", false), Global.getParameter("font.bold", false));
        ZF.ZC.recompute();
        IG.clearRect(0, 0, w, h, Color.white);
        ZF.ZC.dopaint(IG);
        ZF.ZC.endWaiting();
        int dpi = 300;
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(filename));
            PngEncoder png = new PngEncoder(I, false, 0, 9);
            png.setDPI(300.0);
            out.write(png.pngEncode());
            out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void saveeps() {
        ZirkelFrame ZF = JZirkelCanvas.getCurrentZF();
        if (ZF == null) {
            return;
        }
        boolean Scale = true;
        int w = ZF.ZC.getSize().width * 1;
        int h = ZF.ZC.getSize().height * 1;
        ZF.ZC.PointSize = Global.getParameter("minpointsize", 3) * 1;
        ZF.ZC.FontSize = Global.getParameter("minfontsize", 12) * 1;
        ZF.ZC.IW = w;
        ZF.ZC.IH = h;
        ZF.ZC.recompute();
        FileSystemView vueSysteme = FileSystemView.getFileSystemView();
        File def = vueSysteme.getHomeDirectory();
        File desk = vueSysteme.getChild(def, "Desktop");
        File choice = desk == null ? def : desk;
        JFileChooser jfc = new JFileChooser(choice);
        jfc.setDialogType(1);
        jfc.setApproveButtonText("Export to EPS");
        jfc.setAcceptAllFileFilterUsed(false);
        jfc.addChoosableFileFilter(new ImageFilter());
        int rep = jfc.showSaveDialog(null);
        if (rep == 0) {
            File outputfile = jfc.getSelectedFile();
            String filename = outputfile.getAbsolutePath();
            String ext = outputfile.getAbsolutePath().endsWith(".eps") ? "" : ".eps";
            FileOutputStream o = null;
            try {
                o = new FileOutputStream(filename + ext);
            }
            catch (FileNotFoundException ex) {
                ex.printStackTrace();
            }
            try {
                MyGraphicsEPS eps = new MyGraphicsEPS(o, w, h);
                eps.setSize(w, h);
                eps.setLineWidth(Global.getParameter("minlinesize", 1));
                eps.setDefaultFont((int)ZF.ZC.FontSize, Global.getParameter("font.large", false), Global.getParameter("font.bold", false));
                ZF.ZC.dopaint(eps);
                eps.close();
                ((OutputStream)o).close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void saveeps(String filename) {
        ZirkelFrame ZF = JZirkelCanvas.getCurrentZF();
        if (ZF == null) {
            return;
        }
        boolean Scale = true;
        int w = ZF.ZC.getSize().width * 1;
        int h = ZF.ZC.getSize().height * 1;
        ZF.ZC.PointSize = Global.getParameter("minpointsize", 3) * 1;
        ZF.ZC.FontSize = Global.getParameter("minfontsize", 12) * 1;
        ZF.ZC.IW = w;
        ZF.ZC.IH = h;
        ZF.ZC.recompute();
        FileOutputStream o = null;
        try {
            o = new FileOutputStream(filename);
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        try {
            MyGraphicsEPS eps = new MyGraphicsEPS(o, w, h);
            eps.setSize(w, h);
            eps.setLineWidth(Global.getParameter("minlinesize", 1));
            eps.setDefaultFont((int)ZF.ZC.FontSize, Global.getParameter("font.large", false), Global.getParameter("font.bold", false));
            ZF.ZC.dopaint(eps);
            eps.close();
            ((OutputStream)o).close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static void saveSVG() {
        ZirkelFrame ZF = JZirkelCanvas.getCurrentZF();
        if (ZF == null) {
            return;
        }
        boolean Scale = true;
        int w = ZF.ZC.getSize().width * 1;
        int h = ZF.ZC.getSize().height * 1;
        ZF.ZC.PointSize = Global.getParameter("minpointsize", 3) * 1;
        ZF.ZC.FontSize = Global.getParameter("minfontsize", 12) * 1;
        ZF.ZC.IW = w;
        ZF.ZC.IH = h;
        ZF.ZC.recompute();
        FileSystemView vueSysteme = FileSystemView.getFileSystemView();
        File def = vueSysteme.getHomeDirectory();
        File desk = vueSysteme.getChild(def, "Desktop");
        File choice = desk == null ? def : desk;
        JFileChooser jfc = new JFileChooser(choice);
        jfc.setDialogType(1);
        jfc.setApproveButtonText("Export to SVG");
        jfc.setAcceptAllFileFilterUsed(false);
        jfc.addChoosableFileFilter(new ImageFilter());
        int rep = jfc.showSaveDialog(null);
        if (rep == 0) {
            File outputfile = jfc.getSelectedFile();
            String filename = outputfile.getAbsolutePath();
            String ext = outputfile.getAbsolutePath().endsWith(".svg") ? "" : ".svg";
            try {
                OutputStream o = new FileOutputStream(filename + ext);
                if (ZirkelFrame.isCompressed(filename)) {
                    o = new GZIPOutputStream(o);
                }
                PrintWriter out = new PrintWriter(new OutputStreamWriter(o, "UTF8"));
                MyGraphicsSvg svg = new MyGraphicsSvg(out, w, h);
                svg.setSize(w, h);
                svg.setDefaultFont((int)ZF.ZC.FontSize, Global.getParameter("font.large", false), Global.getParameter("font.bold", false));
                ZF.ZC.dopaint(svg);
                svg.close();
                out.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void saveSVG(String filename) {
        ZirkelFrame ZF = JZirkelCanvas.getCurrentZF();
        if (ZF == null) {
            return;
        }
        boolean Scale = true;
        int w = ZF.ZC.getSize().width * 1;
        int h = ZF.ZC.getSize().height * 1;
        ZF.ZC.PointSize = Global.getParameter("minpointsize", 3) * 1;
        ZF.ZC.FontSize = Global.getParameter("minfontsize", 12) * 1;
        ZF.ZC.IW = w;
        ZF.ZC.IH = h;
        ZF.ZC.recompute();
        File outputfile = new File(filename);
        try {
            OutputStream o = new FileOutputStream(filename);
            if (ZirkelFrame.isCompressed(filename)) {
                o = new GZIPOutputStream(o);
            }
            PrintWriter out = new PrintWriter(new OutputStreamWriter(o, "UTF8"));
            MyGraphicsSvg svg = new MyGraphicsSvg(out, w, h);
            svg.setSize(w, h);
            svg.setDefaultFont((int)ZF.ZC.FontSize, Global.getParameter("font.large", false), Global.getParameter("font.bold", false));
            ZF.ZC.dopaint(svg);
            svg.close();
            out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

