/*
 * Decompiled with CFR 0.152.
 */
package carmetal.constructors;

import carmetal.construction.Construction;
import carmetal.construction.ConstructionException;
import carmetal.constructors.LineConstructor;
import carmetal.constructors.PointConstructor;
import carmetal.objects.ConstructionObject;
import carmetal.objects.MidpointObject;
import carmetal.objects.PointObject;
import carmetal.rene.gui.Global;
import carmetal.rene.util.xml.XmlTag;
import carmetal.rene.util.xml.XmlTree;
import carmetal.rene.zirkel.ZirkelCanvas;

public class MidpointConstructor
extends LineConstructor {
    @Override
    public ConstructionObject create(Construction c2, PointObject p1, PointObject p2) {
        return new MidpointObject(c2, p1, p2);
    }

    @Override
    public void showStatus(ZirkelCanvas zc) {
        if (this.P1 == null) {
            zc.showStatus(Global.name("message.midpoint.first", "Midpoint: Set the first point!"));
        } else {
            zc.showStatus(Global.name("message.midpoint.second", "Midpoint: Set the second point!"));
        }
    }

    @Override
    public boolean construct(XmlTree tree, Construction c2) throws ConstructionException {
        if (!this.testTree(tree, "Midpoint")) {
            return false;
        }
        XmlTag tag = tree.getTag();
        if (!tag.hasParam("first") || !tag.hasParam("second")) {
            throw new ConstructionException("Line points missing!");
        }
        try {
            PointObject p1 = (PointObject)c2.find(tag.getValue("first"));
            PointObject p2 = (PointObject)c2.find(tag.getValue("second"));
            MidpointObject p = new MidpointObject(c2, p1, p2);
            PointConstructor.setType(tag, p);
            this.setName(tag, p);
            this.set(tree, p);
            c2.add(p);
            this.setConditionals(tree, c2, p);
        }
        catch (ConstructionException e2) {
            throw e2;
        }
        catch (Exception e3) {
            throw new ConstructionException("Midpoint points illegal!");
        }
        return true;
    }

    @Override
    public String getPrompt() {
        return Global.name("prompt.midpoint");
    }

    @Override
    public String getTag() {
        return "Midpoint";
    }

    @Override
    public void construct(Construction c2, String name, String[] params, int nparams) throws ConstructionException {
        if (nparams != 2) {
            throw new ConstructionException(Global.name("exception.nparams"));
        }
        ConstructionObject P1 = c2.find(params[0]);
        if (P1 == null) {
            throw new ConstructionException(Global.name("exception.notfound") + " " + params[0]);
        }
        if (!(P1 instanceof PointObject)) {
            throw new ConstructionException(Global.name("exception.type") + " " + params[0]);
        }
        ConstructionObject P2 = c2.find(params[1]);
        if (P2 == null) {
            throw new ConstructionException(Global.name("exception.notfound") + " " + params[1]);
        }
        if (!(P2 instanceof PointObject)) {
            throw new ConstructionException(Global.name("exception.type") + " " + params[1]);
        }
        MidpointObject s = new MidpointObject(c2, (PointObject)P1, (PointObject)P2);
        if (!name.equals("")) {
            s.setNameCheck(name);
        }
        c2.add(s);
        s.setDefaults();
    }
}

