/*
 * Decompiled with CFR 0.152.
 */
package units;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import units.Env;
import units.FileParser;
import units.FileSemantics;
import units.Location;
import units.SourceString;
import units.applet;
import units.convert;

class UnitsFile {
    static FileAcc fileAcc;
    String name;
    String contents;
    private static final Charset cs;

    UnitsFile(String name) {
        this.name = name;
    }

    boolean readunits(int depth) {
        int linenum = 1;
        int linestart = 0;
        int pos = 0;
        int startpos = 0;
        StringBuilder fileBuf = new StringBuilder();
        InputStream is = fileAcc.open(this.name);
        if (is == null) {
            return false;
        }
        InputStreamReader isr = new InputStreamReader(is, cs);
        BufferedReader reader = new BufferedReader(isr);
        FileParser parser = new FileParser();
        FileSemantics sem = parser.semantics();
        parser.setMemo(1);
        block4: while (true) {
            StringBuilder lineBuf = new StringBuilder();
            linestart = linenum;
            startpos = pos;
            boolean continued = false;
            while (true) {
                String line;
                try {
                    line = reader.readLine();
                }
                catch (IOException e) {
                    Env.out.println("Error in reading line " + linenum + " from file '" + this.name + "': " + e.getMessage());
                    return false;
                }
                if (line == null) {
                    if (!continued) break block4;
                    Env.out.println("The last line of '" + this.name + "' is missing its continuation and is ignored.");
                    break block4;
                }
                fileBuf.append(line).append("\n");
                pos += line.length() + 1;
                ++linenum;
                lineBuf.append(line);
                if (!line.endsWith("\\")) break;
                lineBuf.setCharAt(lineBuf.length() - 1, ' ');
                continued = true;
            }
            int i = lineBuf.indexOf("#");
            if (i >= 0) {
                lineBuf.delete(i, lineBuf.length());
            }
            String line = lineBuf.toString();
            SourceString src = new SourceString(line);
            sem.loc = new Location(this, linestart, startpos, pos - 1);
            sem.depth = depth;
            parser.parse(src);
        }
        try {
            reader.close();
        }
        catch (IOException e) {
            Env.out.println(e.getMessage());
        }
        this.contents = fileBuf.toString();
        return true;
    }

    static {
        cs = Charset.forName("UTF-8");
    }

    static class AppletAcc
    extends FileAcc {
        AppletAcc() {
        }

        @Override
        InputStream open(String name) {
            try {
                URL url = applet.class.getResource(name);
                return url.openStream();
            }
            catch (IOException e) {
                Env.out.println("Error in file '" + name + "': " + e.getMessage());
                return null;
            }
        }
    }

    static class StandAcc
    extends FileAcc {
        StandAcc() {
        }

        @Override
        InputStream open(String name) {
            InputStream is = convert.class.getResourceAsStream(name);
            if (is != null) {
                return is;
            }
            try {
                return new FileInputStream(name);
            }
            catch (FileNotFoundException e) {
                Env.out.println("File '" + name + "' was not found");
                return null;
            }
        }
    }

    static abstract class FileAcc {
        FileAcc() {
        }

        abstract InputStream open(String var1);
    }
}

