/*
 * Decompiled with CFR 0.152.
 */
package units;

import java.util.Enumeration;
import java.util.Hashtable;
import units.Entity;
import units.Env;
import units.Factor;
import units.Ignore;
import units.Location;
import units.Value;

class Prefix
extends Factor {
    static Hashtable<String, Prefix> table = null;
    static Value one = new Value();

    Prefix(String name, Location loc, String def) {
        super(name, loc, def);
    }

    static void define(String name, String def, Location loc) {
        String prefname = name.substring(0, name.length() - 1);
        String diag = Entity.checkName(prefname);
        if (diag != null) {
            Env.out.println(loc.where() + ". Prefix '" + prefname + "' is ignored. It " + diag + ".");
            return;
        }
        Prefix old = table.put(prefname, new Prefix(prefname, loc, def));
        if (old != null) {
            Env.out.println("Prefix '" + name + "' defined in " + old.location.where() + ", is redefined in " + loc.where() + ".");
        }
    }

    @Override
    void check() {
        if (Env.verbose == 2) {
            Env.out.println(this.location.where() + ". Doing '" + this.name + "'");
        }
        int plevel = 0;
        for (int i = 0; i < this.def.length(); ++i) {
            char ch = this.def.charAt(i);
            if (ch == ')') {
                --plevel;
                continue;
            }
            if (ch == '(') {
                ++plevel;
                continue;
            }
            if (plevel != 0 || ch != '/') continue;
            Env.out.println(this.location.where() + ". Prefix '" + this.name + "-' defined as '" + this.def + "' contains bad '/'");
            return;
        }
        Value v = Value.fromString(this.name);
        if (v == null || !v.isCompatibleWith(one, Ignore.PRIMITIVE)) {
            Env.out.println(this.location.where() + ". Prefix '" + this.name + "' defined as '" + this.def + "' is irreducible");
        }
    }

    static Prefix find(String name) {
        int maxlg = 0;
        Prefix maxp = null;
        Enumeration<Prefix> enu = table.elements();
        while (enu.hasMoreElements()) {
            Prefix p = enu.nextElement();
            int plg = p.name.length();
            if (plg <= maxlg || !name.startsWith(p.name)) continue;
            maxp = p;
            maxlg = plg;
        }
        return maxp;
    }

    @Override
    boolean conformsTo(Value v) {
        return one.isCompatibleWith(v, Ignore.DIMLESS);
    }

    @Override
    String desc() {
        return "<prefix> " + this.def;
    }
}

