/*
 * Decompiled with CFR 0.152.
 */
package units;

import java.util.Vector;
import units.CurrentRule;
import units.SemanticsBase;
import units.Source;

public class ParserBase
implements CurrentRule {
    Source source;
    int endpos;
    int pos;
    protected SemanticsBase sem;
    protected String trace = "";
    Phrase current = null;

    protected ParserBase() {
    }

    public void init(Source src) {
        this.source = src;
        this.pos = 0;
        this.endpos = this.source.end();
        this.current = new Phrase("", "", 0);
    }

    @Override
    public Phrase lhs() {
        return this.current;
    }

    @Override
    public Phrase rhs(int i) {
        return this.current.rhs.elementAt(i);
    }

    @Override
    public int rhsSize() {
        return this.current.rhs.size();
    }

    @Override
    public String rhsText(int i, int j) {
        return this.source.at(this.rhs((int)i).start, this.rhs((int)(j - 1)).end);
    }

    public void setTrace(String trace) {
        this.trace = trace;
        this.sem.trace = trace;
    }

    protected boolean failure() {
        if (this.current.errPos >= 0) {
            System.out.println(this.current.errMsg());
        }
        return false;
    }

    protected void begin(String name) {
        Phrase p = new Phrase(name, name, this.pos);
        p.parent = this.current;
        this.current = p;
    }

    protected void begin(String name, String diag) {
        Phrase p = new Phrase(name, diag, this.pos);
        p.parent = this.current;
        this.current = p;
    }

    protected boolean accept() {
        Phrase p = this.pop();
        p.rhs = null;
        if (p.errPos == p.start) {
            p.errSet(p.diag, p.start);
        }
        p.success = true;
        this.current.end = this.pos;
        this.current.rhs.add(p);
        this.current.errMerge(p);
        return true;
    }

    protected boolean acceptInner() {
        Phrase p = this.pop();
        p.success = true;
        this.current.end = this.pos;
        this.current.rhs.addAll(p.rhs);
        this.current.errMerge(p);
        return true;
    }

    protected boolean acceptAnd() {
        Phrase p = this.pop();
        p.end = p.start;
        p.rhs = null;
        p.errClear();
        p.success = true;
        this.pos = p.start;
        return true;
    }

    protected boolean acceptNot() {
        Phrase p = this.pop();
        p.rhs = null;
        p.errClear();
        p.success = true;
        return true;
    }

    protected boolean reject() {
        Phrase p = this.pop();
        p.end = p.start;
        p.rhs = null;
        if (p.errPos == p.start) {
            p.errSet(p.diag, p.start);
        }
        p.success = false;
        this.current.errMerge(p);
        this.pos = p.start;
        return false;
    }

    protected boolean boolReject() {
        this.current.end = this.pos = this.current.start;
        this.current.rhs.clear();
        this.current.errSet(this.current.diag, this.pos);
        return false;
    }

    protected boolean rejectInner() {
        Phrase p = this.pop();
        p.end = p.start;
        p.rhs = null;
        p.success = false;
        this.current.errMerge(p);
        this.pos = p.start;
        return false;
    }

    protected boolean rejectAnd() {
        Phrase p = this.pop();
        p.rhs = null;
        p.errSet(p.diag, this.pos);
        p.success = false;
        this.current.errMerge(p);
        return false;
    }

    protected boolean rejectNot() {
        Phrase p = this.pop();
        p.end = p.start;
        p.rhs = null;
        this.pos = p.start;
        p.errSet(p.diag, this.pos);
        p.success = false;
        this.current.errMerge(p);
        return false;
    }

    protected boolean next(char ch) {
        if (this.pos < this.endpos && this.source.at(this.pos) == ch) {
            return this.consume(1);
        }
        return this.fail("'" + ch + "'");
    }

    protected boolean nextNot(char ch) {
        if (this.pos < this.endpos && this.source.at(this.pos) != ch) {
            return this.consume(1);
        }
        return this.fail("not '" + ch + "'");
    }

    protected boolean ahead(char ch) {
        if (this.pos < this.endpos && this.source.at(this.pos) == ch) {
            return true;
        }
        return this.fail("'" + ch + "'");
    }

    protected boolean aheadNotNot(char ch) {
        return this.ahead(ch);
    }

    protected boolean aheadNot(char ch) {
        if (this.pos < this.endpos && this.source.at(this.pos) == ch) {
            return this.fail("not '" + ch + "'");
        }
        return true;
    }

    protected boolean next(String s) {
        int lg = s.length();
        if (this.pos + lg <= this.endpos && this.source.at(this.pos, this.pos + lg).equals(s)) {
            return this.consume(lg);
        }
        return this.fail("'" + s + "'");
    }

    protected boolean ahead(String s) {
        int lg = s.length();
        if (this.pos + lg <= this.endpos && this.source.at(this.pos, this.pos + lg).equals(s)) {
            return true;
        }
        return this.fail("'" + s + "'");
    }

    protected boolean aheadNot(String s) {
        int lg = s.length();
        if (this.pos + lg <= this.endpos && this.source.at(this.pos, this.pos + lg).equals(s)) {
            return this.fail("not '" + s + "'");
        }
        return true;
    }

    protected boolean nextIn(String s) {
        if (this.pos < this.endpos && s.indexOf(this.source.at(this.pos)) >= 0) {
            return this.consume(1);
        }
        return this.fail("[" + s + "]");
    }

    protected boolean nextNotIn(String s) {
        if (this.pos < this.endpos && s.indexOf(this.source.at(this.pos)) < 0) {
            return this.consume(1);
        }
        return this.fail("not [" + s + "]");
    }

    protected boolean aheadIn(String s) {
        if (this.pos < this.endpos && s.indexOf(this.source.at(this.pos)) >= 0) {
            return true;
        }
        return this.fail("[" + s + "]");
    }

    protected boolean aheadNotNotIn(String s) {
        return this.aheadIn(s);
    }

    protected boolean aheadNotIn(String s) {
        if (this.pos < this.endpos && s.indexOf(this.source.at(this.pos)) >= 0) {
            return this.fail("not [" + s + "]");
        }
        return true;
    }

    protected boolean nextIn(char a, char z) {
        if (this.pos < this.endpos && this.source.at(this.pos) >= a && this.source.at(this.pos) <= z) {
            return this.consume(1);
        }
        return this.fail("[" + a + "-" + z + "]");
    }

    protected boolean aheadIn(char a, char z) {
        if (this.pos < this.endpos && this.source.at(this.pos) >= a && this.source.at(this.pos) <= z) {
            return true;
        }
        return this.fail("[" + a + "-" + z + "]");
    }

    protected boolean aheadNotIn(char a, char z) {
        if (this.pos < this.endpos && this.source.at(this.pos) >= a && this.source.at(this.pos) <= z) {
            return this.fail("not [" + a + "-" + z + "]");
        }
        return true;
    }

    protected boolean next() {
        if (this.pos < this.endpos) {
            return this.consume(1);
        }
        return this.fail("any character");
    }

    protected boolean ahead() {
        if (this.pos < this.endpos) {
            return true;
        }
        return this.fail("any character");
    }

    protected boolean aheadNot() {
        if (this.pos < this.endpos) {
            return this.fail("end of text");
        }
        return true;
    }

    private Phrase pop() {
        Phrase p = this.current;
        this.current = p.parent;
        p.parent = null;
        return p;
    }

    private boolean consume(int n) {
        Phrase p = new Phrase("", "", this.pos);
        this.pos += n;
        p.end = this.pos;
        this.current.rhs.add(p);
        this.current.end = this.pos;
        return true;
    }

    private boolean fail(String msg) {
        this.current.errAdd(msg);
        return false;
    }

    public class Phrase
    implements units.Phrase {
        final String name;
        final String diag;
        final int start;
        int end;
        boolean success;
        Vector<Phrase> rhs = new Vector(10, 10);
        Object value = null;
        Phrase parent = null;
        int errPos = -1;
        Vector<String> errTxt = new Vector();

        Phrase(String name, String diag, int start) {
            this.name = name;
            this.diag = diag;
            this.start = start;
            this.end = start;
        }

        @Override
        public void put(Object o) {
            this.value = o;
        }

        @Override
        public Object get() {
            return this.value;
        }

        @Override
        public String text() {
            return ParserBase.this.source.at(this.start, this.end);
        }

        @Override
        public char charAt(int i) {
            return ParserBase.this.source.at(this.start + i);
        }

        @Override
        public boolean isEmpty() {
            return this.start == this.end;
        }

        @Override
        public String rule() {
            return this.name;
        }

        @Override
        public boolean isA(String rule) {
            return this.name.equals(rule);
        }

        @Override
        public boolean isTerm() {
            return this.name.isEmpty();
        }

        @Override
        public String errMsg() {
            if (this.errPos < 0) {
                return "";
            }
            return ParserBase.this.source.where(this.errPos) + ":" + this.listErr();
        }

        @Override
        public void errClear() {
            this.errTxt.clear();
            this.errPos = -1;
        }

        @Override
        public String where(int i) {
            return ParserBase.this.source.where(this.start + i);
        }

        void errSet(String who, int where) {
            this.errTxt.clear();
            this.errTxt.add(who);
            this.errPos = where;
        }

        void errAdd(String who) {
            if (this.errPos > ParserBase.this.pos) {
                return;
            }
            if (this.errPos < ParserBase.this.pos) {
                this.errTxt.clear();
                this.errPos = ParserBase.this.pos;
                this.errTxt.add(who);
                return;
            }
            this.errTxt.add(who);
        }

        void errMerge(Phrase p) {
            if (p.errPos < ParserBase.this.pos && this.errPos < ParserBase.this.pos) {
                this.errClear();
                return;
            }
            if (p.errPos < 0) {
                return;
            }
            if (this.errPos > p.errPos) {
                return;
            }
            if (this.errPos < p.errPos) {
                this.errTxt.clear();
                this.errPos = p.errPos;
                this.errTxt.addAll(p.errTxt);
                return;
            }
            this.errTxt.addAll(p.errTxt);
        }

        private String listErr() {
            StringBuilder one = new StringBuilder();
            StringBuilder two = new StringBuilder();
            Vector<String> done = new Vector<String>();
            for (String s : this.errTxt) {
                if (done.contains(s)) continue;
                done.add(s);
                if (s.startsWith("not ")) {
                    this.toPrint(" or " + s.substring(4), two);
                    continue;
                }
                this.toPrint(" or " + s, one);
            }
            if (one.length() > 0) {
                if (two.length() == 0) {
                    return " expected " + one.toString().substring(4);
                }
                return " expected " + one.toString().substring(4) + "; not expected " + two.toString().substring(4);
            }
            return " not expected " + two.toString().substring(4);
        }

        private void toPrint(String s, StringBuilder sb) {
            block7: for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                switch (c) {
                    case '\b': {
                        sb.append("\\b");
                        continue block7;
                    }
                    case '\f': {
                        sb.append("\\f");
                        continue block7;
                    }
                    case '\n': {
                        sb.append("\\n");
                        continue block7;
                    }
                    case '\r': {
                        sb.append("\\r");
                        continue block7;
                    }
                    case '\t': {
                        sb.append("\\t");
                        continue block7;
                    }
                    default: {
                        if (c < ' ' || c > '\u0100') {
                            String u = "000" + Integer.toHexString(c);
                            sb.append("\\u" + u.substring(u.length() - 4, u.length()));
                            continue block7;
                        }
                        sb.append(c);
                        continue block7;
                    }
                }
            }
        }
    }
}

