/*
 * Decompiled with CFR 0.152.
 */
package units;

import units.Entity;
import units.EvalError;
import units.Ignore;
import units.Location;
import units.Prefix;
import units.Unit;
import units.Value;

abstract class Factor
extends Entity {
    String def;
    boolean isPrimitive = false;
    boolean isDimless = false;
    boolean isNumber = false;

    boolean ignoredIf(Ignore what) {
        if (what == Ignore.PRIMITIVE && this.isPrimitive) {
            return true;
        }
        return what == Ignore.DIMLESS && this.isDimless;
    }

    Factor(String name, Location loc, String def) {
        super(name, loc);
        Double d;
        this.def = def;
        if (def.equals("!")) {
            this.isPrimitive = true;
        }
        if (def.equals("!dimensionless")) {
            this.isPrimitive = true;
            this.isDimless = true;
        }
        try {
            d = Double.valueOf(def);
        }
        catch (NumberFormatException e) {
            return;
        }
        if (d.isInfinite() || d.isNaN()) {
            return;
        }
        this.isNumber = true;
    }

    static Factor[] split(String name) {
        if (Entity.checkName(name) != null) {
            return null;
        }
        Unit u = Unit.find(name);
        if (u != null) {
            return new Factor[]{null, u};
        }
        Prefix p = Prefix.find(name);
        if (p == null) {
            return null;
        }
        String prefix = p.name;
        if (name.equals(prefix)) {
            return new Factor[]{p, null};
        }
        String rest = name.substring(prefix.length(), name.length());
        u = Unit.find(rest);
        if (u != null) {
            return new Factor[]{p, u};
        }
        return null;
    }

    static String showdef(String name) {
        Value v;
        Factor[] pu;
        StringBuilder sb = new StringBuilder();
        String def = name;
        while ((pu = Factor.split(def)) != null) {
            Factor pref = pu[0];
            Factor unit = pu[1];
            if (unit == null) {
                def = pref.def;
                if (pref.isNumber) {
                    return name + sb.toString() + " = " + def;
                }
                sb.append(" = " + def);
                continue;
            }
            if (pref == null) {
                def = unit.def;
                if (unit.isNumber) {
                    return name + sb.toString() + " = " + def;
                }
                if (unit.isPrimitive) {
                    if (sb.length() == 0) {
                        return "'" + name + "' is a primitive unit";
                    }
                    return name + sb.toString();
                }
                sb.append(" = " + def);
                continue;
            }
            sb.append(" = " + pref.def + " " + (unit.isPrimitive || unit.isNumber ? unit.name : unit.def));
            break;
        }
        try {
            v = Value.parse(name);
        }
        catch (EvalError e) {
            return null;
        }
        v.completereduce();
        return name + sb.toString() + " = " + v.asString();
    }
}

