/*
 * Decompiled with CFR 0.152.
 */
package units;

import java.awt.Font;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Properties;
import java.util.Vector;
import units.DefinedFunction;
import units.EvalError;
import units.Tables;
import units.UnitList;
import units.Value;

public class Env {
    static final String PROGNAME = "gnu.units";
    static final String VERSION = "1.89.J01";
    static final String ORIGVER = "1.89e";
    static final String UNITSFILE = "units.dat";
    static final String FILEVER = "Version 1.53 (17 November 2011)";
    static final String PROPFILE = "units.opt";
    static final String LOCALE = "en_US";
    static final String GUIFONT = "Monospaced";
    static final int MAXFILES = 25;
    static final int MAXINCLUDE = 5;
    static final String COPYRIGHT = "This is an extended Java version of GNU Units 1.89e, a program\nwritten in C by Adrian Mariano, copyright (C) 1996, 1997, 1999,\n2000, 2001, 2002, 2003, 2004, 2005, 2006, 2007, 2010, 2011 by\nFree Software Foundation, Inc.\nJava version copyright (C) 2003, 2004, 2005, 2006, 2007, 2008,\n2009, 2010, 2011, 2012 by Roman R Redziejowski.\nThe program is free software; you can redistribute it and/or\nmodify under the terms of the GNU General Public License\nas published by the Free SoftwareFoundation; either version 3\nof the License or (at your option) any later version.\nThe program is distributed in the hope that it will be useful,\nbut WITHOUT ANY WARRANTY; without even the implied warranty\nof MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.\nFor more details, see the GNU General Public License\n(http://www.gnu.org/licenses/).";
    static String propfile = null;
    static Font guiFont = null;
    static Vector<String> filenames;
    static String locale;
    static String encoding;
    static String font;
    static int verbose;
    static boolean quiet;
    static boolean oneline;
    static boolean strict;
    static boolean unitcheck;
    static boolean round;
    public static Writer out;

    public static void getProperties() {
        FileInputStream propFile;
        propfile = null;
        String classPath = System.getProperty("java.class.path");
        String filSep = System.getProperty("file.separator");
        String propPath = classPath.substring(0, classPath.lastIndexOf(filSep) + 1) + PROPFILE;
        try {
            propFile = new FileInputStream(propPath);
        }
        catch (FileNotFoundException e) {
            return;
        }
        Properties props = new Properties();
        try {
            props.load(propFile);
            propFile.close();
        }
        catch (Exception e) {
            out.println("gnu.units: error reading properties from '" + propPath + "'.\n" + e);
            return;
        }
        propfile = propPath;
        String prop = props.getProperty("UNITSFILE");
        if (prop != null) {
            filenames = new Vector();
            while (prop != null) {
                String fileName;
                int i = prop.indexOf(59);
                if (i >= 0) {
                    fileName = prop.substring(0, i).trim();
                    prop = prop.substring(i + 1, prop.length());
                } else {
                    fileName = prop.trim();
                    prop = null;
                }
                filenames.add(fileName);
            }
        }
        if ((prop = props.getProperty("LOCALE")) != null) {
            locale = prop.trim();
        }
        if ((prop = props.getProperty("ENCODING")) != null) {
            encoding = prop.trim();
        }
        if ((prop = props.getProperty("GUIFONT")) != null) {
            font = prop.trim();
        }
    }

    public static void getPersonalUnits() {
        String home = System.getProperty("user.home");
        File personal = new File(home + File.separator + UNITSFILE);
        if (personal.exists()) {
            filenames.add(personal.getPath());
        }
    }

    public static void showAbout() {
        out.println("Version: 1.89.J01.");
        if (propfile != null) {
            out.println("Property list " + propfile + ".");
        }
        out.print("Units database:");
        String sep = filenames.size() == 1 ? " " : "\n\t";
        for (int i = 0; i < filenames.size(); ++i) {
            String name = filenames.elementAt(i);
            if (name.length() == 0 || name.equals(UNITSFILE)) {
                out.print(sep + UNITSFILE + " version " + FILEVER);
                continue;
            }
            out.print(sep + name);
        }
        out.println("\ncontaining " + Tables.stat());
        out.println("Locale: " + locale + ".");
        out.println("\nWARNING: the currency conversions in units.dat are out of date!");
        out.println("\nThis is an extended Java version of GNU Units 1.89e, a program\nwritten in C by Adrian Mariano, copyright (C) 1996, 1997, 1999,\n2000, 2001, 2002, 2003, 2004, 2005, 2006, 2007, 2010, 2011 by\nFree Software Foundation, Inc.\nJava version copyright (C) 2003, 2004, 2005, 2006, 2007, 2008,\n2009, 2010, 2011, 2012 by Roman R Redziejowski.\nThe program is free software; you can redistribute it and/or\nmodify under the terms of the GNU General Public License\nas published by the Free SoftwareFoundation; either version 3\nof the License or (at your option) any later version.\nThe program is distributed in the hope that it will be useful,\nbut WITHOUT ANY WARRANTY; without even the implied warranty\nof MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.\nFor more details, see the GNU General Public License\n(http://www.gnu.org/licenses/).");
    }

    public static boolean convert(String fromExpr, Value fromValue, String toString) {
        String uList = UnitList.isUnitList(toString);
        if (uList != null) {
            UnitList ul = null;
            try {
                ul = new UnitList(uList);
            }
            catch (EvalError ee) {
                out.println("Invalid unit list. " + ee.getMessage());
                return false;
            }
            boolean ok = ul.convert(fromExpr, fromValue);
            return ok;
        }
        DefinedFunction func = DefinedFunction.table.get(toString);
        if (func != null) {
            boolean ok = func.convert(fromExpr, fromValue);
            return ok;
        }
        Value toValue = Value.fromString(toString);
        if (toValue == null) {
            return false;
        }
        boolean ok = Value.convert(fromExpr, fromValue, toString, toValue);
        return ok;
    }

    public static abstract class Writer {
        abstract void print(String var1);

        abstract void println(String var1);
    }
}

