/*
 * Decompiled with CFR 0.152.
 */
package units;

import units.DefinedFunction;
import units.Entity;
import units.Env;
import units.EvalError;
import units.Function;
import units.Ignore;
import units.Location;
import units.Value;

class ComputedFunction
extends DefinedFunction {
    private FuncDef forward;
    private FuncDef inverse;

    ComputedFunction(String nam, Location loc, String fpar, String fdf, String fdim, String ipar, String idf, String idim) {
        super(nam, loc);
        this.forward = new FuncDef(fpar, fdf, fdim);
        this.inverse = new FuncDef(ipar, idf, idim);
    }

    static void define(String name, String param, String fwddim, String invdim, String fwddef, String invdef, Location loc) {
        String diag = Entity.checkName(name);
        if (diag != null) {
            Env.out.println(loc.where() + ". Function '" + name + "' is ignored. Its name " + diag + ".");
            return;
        }
        Function old = table.put(name, new ComputedFunction(name, loc, param, fwddef, fwddim, name, invdef, invdim));
        if (old != null) {
            Env.out.println("Function '" + name + "' defined in " + old.location.where() + ", is redefined in " + loc.where() + ".");
        }
    }

    @Override
    void applyTo(Value v) {
        this.forward.applyTo(v, "");
    }

    @Override
    void applyInverseTo(Value v) {
        this.inverse.applyTo(v, "~");
    }

    @Override
    String showdef() {
        return this.name + "(" + this.forward.param + ") = " + this.forward.def;
    }

    @Override
    void check() {
        if (Env.verbose == 2) {
            Env.out.println(this.location.where() + ". Doing function " + this.name);
        }
        this.checkHiding();
        if (this.inverse.dimen != null) {
            try {
                Value.parse(this.inverse.dimen);
            }
            catch (EvalError e) {
                Env.out.println(this.location.where() + ". Dimension '" + this.inverse.dimen + "' specified for argument of '~" + this.name + "' is invalid. " + e.getMessage() + ".");
            }
        }
        Value v = new Value();
        if (this.forward.dimen != null) {
            try {
                v = Value.parse(this.forward.dimen);
                v.completereduce();
            }
            catch (EvalError e) {
                Env.out.println(this.location.where() + ". Dimension '" + this.forward.dimen + "' specified for argument of '" + this.name + "' is invalid. " + e.getMessage() + ".");
                return;
            }
        }
        if (this.inverse.def == null) {
            Env.out.println(this.location.where() + ". Warning: no inverse for function '" + this.name + "'.");
            return;
        }
        v.factor *= 7.0;
        Value saved = new Value(v);
        try {
            this.applyTo(v);
        }
        catch (EvalError e) {
            Env.out.println(this.location.where() + ". Warning: inverse was not checked for '" + this.name + "'.");
            return;
        }
        try {
            this.applyInverseTo(v);
            v.div(saved);
            v.completereduce();
            double delta = v.factor - 1.0;
            if (!v.isNumber() || delta < -1.0E-12 || delta > 1.0E-12) {
                Env.out.println(this.location.where() + ". Inverse is not the inverse for function '" + this.name + "'.");
            }
        }
        catch (EvalError e) {
            Env.out.println(this.location.where() + ". Error in '~" + this.name + "(" + this.inverse.param + ")' defined as '" + this.inverse.def + "'.");
        }
    }

    @Override
    boolean conformsTo(Value v) {
        if (this.inverse.dimen == null) {
            return false;
        }
        try {
            Value thisvalue = Value.parse(this.inverse.dimen);
            thisvalue.completereduce();
            return thisvalue.isCompatibleWith(v, Ignore.DIMLESS);
        }
        catch (EvalError e) {
            return false;
        }
    }

    @Override
    String desc() {
        return "<function>";
    }

    private class FuncDef {
        String param;
        String def;
        String dimen;

        FuncDef(String param, String def, String dimen) {
            this.param = param;
            this.def = def;
            this.dimen = dimen;
        }

        void applyTo(Value v, String inv) {
            Value result;
            v.completereduce();
            if (this.dimen != null) {
                Value dim;
                try {
                    dim = Value.parse(this.dimen);
                }
                catch (EvalError e) {
                    throw new EvalError("Invalid argument dimension, " + this.dimen + ", of function " + inv + ComputedFunction.this.name + ". " + e.getMessage());
                }
                dim.completereduce();
                if (!dim.isCompatibleWith(v, Ignore.NONE)) {
                    throw new EvalError("Argument " + v.asString() + " of function " + inv + ComputedFunction.this.name + " is not conformable to " + dim.asString() + ".");
                }
            }
            try {
                result = Value.parse(this.def, this.param, v);
            }
            catch (EvalError e) {
                throw new EvalError("Invalid application of function '" + inv + ComputedFunction.this.name + "'. " + e.getMessage());
            }
            v.copyFrom(result);
        }
    }
}

