/*
 * Decompiled with CFR 0.152.
 */
package units;

import java.util.Hashtable;
import units.EvalError;
import units.Function;
import units.Location;
import units.Unit;
import units.Value;

class BuiltInFunction
extends Function {
    static Hashtable<String, BuiltInFunction> table = null;
    private type funcType;
    private proc procID;
    private static Unit radian;

    BuiltInFunction(String name, type funcType, proc procID) {
        super(name, new Location());
        this.funcType = funcType;
        this.procID = procID;
    }

    private static void insert(String name, type funcType, proc procID) {
        table.put(name, new BuiltInFunction(name, funcType, procID));
    }

    static void makeTable() {
        BuiltInFunction.insert("sin", type.ANGLEIN, proc.SIN);
        BuiltInFunction.insert("cos", type.ANGLEIN, proc.COS);
        BuiltInFunction.insert("tan", type.ANGLEIN, proc.TAN);
        BuiltInFunction.insert("ln", type.DIMLESS, proc.LN);
        BuiltInFunction.insert("log", type.DIMLESS, proc.LOG);
        BuiltInFunction.insert("log2", type.DIMLESS, proc.LOG2);
        BuiltInFunction.insert("exp", type.DIMLESS, proc.EXP);
        BuiltInFunction.insert("acos", type.ANGLEOUT, proc.ACOS);
        BuiltInFunction.insert("atan", type.ANGLEOUT, proc.ATAN);
        BuiltInFunction.insert("asin", type.ANGLEOUT, proc.ASIN);
        BuiltInFunction.insert("sqrt", type.NOCHECK, proc.SQRT);
        BuiltInFunction.insert("cuberoot", type.NOCHECK, proc.CBRT);
        Unit r = Unit.table.get("radian");
        if (r != null) {
            radian = r;
        } else {
            r = new Unit("radian", new Location(), "!");
        }
    }

    @Override
    void applyTo(Value v) {
        switch (this.funcType) {
            case ANGLEIN: {
                if (v.isNumber()) break;
                String s = v.asString();
                v.denominator.add(radian);
                if (v.isNumber()) break;
                throw new EvalError("Argument '" + s + "' of '" + this.name + "' is not a number or angle.");
            }
            case ANGLEOUT: 
            case DIMLESS: {
                if (v.isNumber()) break;
                throw new EvalError("Argument '" + v.asString() + "' of '" + this.name + "' is not a number.");
            }
            case NOCHECK: {
                break;
            }
            default: {
                throw new Error("Program Error; funcType=" + (Object)((Object)this.funcType));
            }
        }
        double arg = v.factor;
        switch (this.procID) {
            case SIN: {
                v.factor = Math.sin(arg);
                break;
            }
            case COS: {
                v.factor = Math.cos(arg);
                break;
            }
            case TAN: {
                v.factor = Math.tan(arg);
                break;
            }
            case LN: {
                v.factor = Math.log(arg);
                break;
            }
            case LOG: {
                v.factor = Math.log(arg) / Math.log(10.0);
                break;
            }
            case LOG2: {
                v.factor = Math.log(arg) / Math.log(2.0);
                break;
            }
            case EXP: {
                v.factor = Math.exp(arg);
                break;
            }
            case ASIN: {
                v.factor = Math.asin(arg);
                break;
            }
            case ACOS: {
                v.factor = Math.acos(arg);
                break;
            }
            case ATAN: {
                v.factor = Math.atan(arg);
                break;
            }
            case SQRT: {
                v.root(2);
                break;
            }
            case CBRT: {
                v.root(3);
                break;
            }
            default: {
                throw new Error("Program Error; procID=" + (Object)((Object)this.procID));
            }
        }
        double result = v.factor;
        boolean NaN = Double.isNaN(result) | Double.isInfinite(result);
        switch (this.funcType) {
            case ANGLEIN: 
            case DIMLESS: {
                if (!NaN) break;
                throw new EvalError("The result of " + this.name + "(" + arg + ") is undefined.");
            }
            case ANGLEOUT: {
                if (NaN) {
                    throw new EvalError("The result of " + this.name + "(" + arg + ") is undefined.");
                }
                v.numerator.add(radian);
                break;
            }
            case NOCHECK: {
                break;
            }
            default: {
                throw new Error("Program Error; funcType=" + (Object)((Object)this.funcType));
            }
        }
    }

    @Override
    void applyInverseTo(Value v) {
        throw new Error("Program Error");
    }

    @Override
    String showdef() {
        throw new Error("Program Error");
    }

    @Override
    void check() {
        throw new Error("Program Error");
    }

    @Override
    boolean conformsTo(Value v) {
        throw new Error("Program Error");
    }

    @Override
    String desc() {
        throw new Error("Program Error");
    }

    private static enum proc {
        SIN,
        COS,
        TAN,
        LN,
        LOG,
        LOG2,
        EXP,
        ASIN,
        ACOS,
        ATAN,
        SQRT,
        CBRT;

    }

    private static enum type {
        DIMLESS,
        ANGLEIN,
        ANGLEOUT,
        NOCHECK;

    }
}

