/*
 * Decompiled with CFR 0.152.
 */
package georegression.struct.shapes;

import georegression.geometry.UtilPolygons2D_F32;
import georegression.metric.Area2D_F32;
import georegression.metric.Intersection2D_F32;
import georegression.struct.line.LineSegment2D_F32;
import georegression.struct.point.Point2D_F32;
import java.io.Serializable;
import org.ddogleg.struct.FastQueue;

public class Polygon2D_F32
implements Serializable {
    public FastQueue<Point2D_F32> vertexes;

    public Polygon2D_F32(Polygon2D_F32 a) {
        this.vertexes = new FastQueue<Point2D_F32>(a.size(), Point2D_F32.class, true);
        for (int i = 0; i < a.size(); ++i) {
            this.vertexes.grow().set(a.get(i));
        }
    }

    public Polygon2D_F32(int numVertexes) {
        this.vertexes = new FastQueue<Point2D_F32>(numVertexes, Point2D_F32.class, true);
        this.vertexes.growArray(numVertexes);
        this.vertexes.size = numVertexes;
    }

    public Polygon2D_F32(float ... points) {
        if (points.length % 2 == 1) {
            throw new IllegalArgumentException("Expected an even number");
        }
        this.vertexes = new FastQueue<Point2D_F32>(points.length / 2, Point2D_F32.class, true);
        this.vertexes.growArray(points.length / 2);
        this.vertexes.size = points.length / 2;
        int count = 0;
        for (int i = 0; i < points.length; i += 2) {
            ((Point2D_F32[])this.vertexes.data)[count++].set(points[i], points[i + 1]);
        }
    }

    public Polygon2D_F32() {
        this.vertexes = new FastQueue<Point2D_F32>(Point2D_F32.class, true);
    }

    public void set(Polygon2D_F32 orig) {
        this.vertexes.resize(orig.size());
        for (int i = 0; i < orig.size(); ++i) {
            ((Point2D_F32[])this.vertexes.data)[i].set(((Point2D_F32[])orig.vertexes.data)[i]);
        }
    }

    public void set(int index, float x, float y) {
        ((Point2D_F32[])this.vertexes.data)[index].set(x, y);
    }

    public Point2D_F32 get(int index) {
        return ((Point2D_F32[])this.vertexes.data)[index];
    }

    public int size() {
        return this.vertexes.size();
    }

    public Polygon2D_F32 copy() {
        return new Polygon2D_F32(this);
    }

    public float areaSimple() {
        return Area2D_F32.polygonSimple(this);
    }

    public boolean isInside(Point2D_F32 p) {
        if (this.isConvex()) {
            return Intersection2D_F32.containConvex(this, p);
        }
        return Intersection2D_F32.containConcave(this, p);
    }

    public boolean isCCW() {
        return UtilPolygons2D_F32.isCCW(this.vertexes.toList());
    }

    public boolean isConvex() {
        return UtilPolygons2D_F32.isConvex(this);
    }

    public boolean isIdentical(Polygon2D_F32 a, float tol) {
        return UtilPolygons2D_F32.isIdentical(this, a, tol);
    }

    public boolean isEquivalent(Polygon2D_F32 a, float tol) {
        return UtilPolygons2D_F32.isEquivalent(this, a, tol);
    }

    public void flip() {
        UtilPolygons2D_F32.flip(this);
    }

    public LineSegment2D_F32 getLine(int index, LineSegment2D_F32 storage) {
        if (storage == null) {
            storage = new LineSegment2D_F32();
        }
        int j = (index + 1) % this.vertexes.size;
        storage.a.set(this.get(index));
        storage.b.set(this.get(j));
        return storage;
    }

    public String toString() {
        String out = this.getClass().getSimpleName() + "{ order " + this.vertexes.size + " : vertexes [ ";
        for (int i = 0; i < this.vertexes.size; ++i) {
            Point2D_F32 p = this.vertexes.get(i);
            out = out + p.x + " , " + p.y + " ; ";
        }
        out = out + " ] }";
        return out;
    }
}

