/*
 * Decompiled with CFR 0.152.
 */
package georegression.struct.se;

import georegression.geometry.GeometryMath_F64;
import georegression.struct.point.Vector3D_F64;
import georegression.struct.se.SpecialEuclidean;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.CommonOps;

public class Se3_F64
implements SpecialEuclidean<Se3_F64> {
    public static final long serialVersionUID = 1L;
    public DenseMatrix64F R;
    public Vector3D_F64 T;

    public Se3_F64() {
        this.R = CommonOps.identity(3);
        this.T = new Vector3D_F64();
    }

    public Se3_F64(DenseMatrix64F R, Vector3D_F64 T) {
        this(R, T, false);
    }

    public Se3_F64(DenseMatrix64F R, Vector3D_F64 T, boolean assign) {
        if (assign) {
            this.R = R;
            this.T = T;
        } else {
            this.R = R.copy();
            this.T = T.copy();
        }
    }

    @Override
    public void set(Se3_F64 se) {
        this.R.set(se.getR());
        this.T.set(se.getT());
    }

    public void setRotation(DenseMatrix64F R) {
        this.R.set(R);
    }

    public void setTranslation(Vector3D_F64 T) {
        this.T.set(T);
    }

    public void setTranslation(double x, double y, double z) {
        this.T.set(x, y, z);
    }

    public DenseMatrix64F getRotation() {
        return this.R;
    }

    public Vector3D_F64 getTranslation() {
        return this.T;
    }

    public DenseMatrix64F getR() {
        return this.R;
    }

    public Vector3D_F64 getT() {
        return this.T;
    }

    public double getX() {
        return this.T.getX();
    }

    public double getY() {
        return this.T.getY();
    }

    public double getZ() {
        return this.T.getZ();
    }

    @Override
    public int getDimension() {
        return 3;
    }

    @Override
    public Se3_F64 createInstance() {
        return new Se3_F64();
    }

    @Override
    public Se3_F64 concat(Se3_F64 second, Se3_F64 result) {
        if (result == null) {
            result = new Se3_F64();
        }
        CommonOps.mult(second.getR(), this.getR(), result.getR());
        GeometryMath_F64.mult(second.getR(), this.getT(), result.getT());
        GeometryMath_F64.add(second.getT(), result.getT(), result.getT());
        return result;
    }

    @Override
    public Se3_F64 invert(Se3_F64 inverse) {
        if (inverse == null) {
            inverse = new Se3_F64();
        }
        GeometryMath_F64.multTran(this.R, this.T, inverse.T);
        GeometryMath_F64.changeSign(inverse.T);
        CommonOps.transpose(this.R, inverse.R);
        return inverse;
    }

    @Override
    public void reset() {
        CommonOps.setIdentity(this.R);
        this.T.set(0.0, 0.0, 0.0);
    }

    public Se3_F64 copy() {
        Se3_F64 ret = new Se3_F64();
        ret.set(this);
        return ret;
    }

    public String toString() {
        String ret = "Se3_F64: T = " + this.T.toString() + "\n";
        ret = ret + this.R;
        return ret + "\n";
    }

    public void print() {
        System.out.println(this);
    }
}

