/*
 * Decompiled with CFR 0.152.
 */
package georegression.struct.se;

import georegression.geometry.GeometryMath_F32;
import georegression.struct.point.Vector3D_F32;
import georegression.struct.se.SpecialEuclidean;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.CommonOps;

public class Se3_F32
implements SpecialEuclidean<Se3_F32> {
    public static final long serialVersionUID = 1L;
    public DenseMatrix64F R;
    public Vector3D_F32 T;

    public Se3_F32() {
        this.R = CommonOps.identity(3);
        this.T = new Vector3D_F32();
    }

    public Se3_F32(DenseMatrix64F R, Vector3D_F32 T) {
        this(R, T, false);
    }

    public Se3_F32(DenseMatrix64F R, Vector3D_F32 T, boolean assign) {
        if (assign) {
            this.R = R;
            this.T = T;
        } else {
            this.R = R.copy();
            this.T = T.copy();
        }
    }

    @Override
    public void set(Se3_F32 se) {
        this.R.set(se.getR());
        this.T.set(se.getT());
    }

    public void setRotation(DenseMatrix64F R) {
        this.R.set(R);
    }

    public void setTranslation(Vector3D_F32 T) {
        this.T.set(T);
    }

    public void setTranslation(float x, float y, float z) {
        this.T.set(x, y, z);
    }

    public DenseMatrix64F getRotation() {
        return this.R;
    }

    public Vector3D_F32 getTranslation() {
        return this.T;
    }

    public DenseMatrix64F getR() {
        return this.R;
    }

    public Vector3D_F32 getT() {
        return this.T;
    }

    public float getX() {
        return this.T.getX();
    }

    public float getY() {
        return this.T.getY();
    }

    public float getZ() {
        return this.T.getZ();
    }

    @Override
    public int getDimension() {
        return 3;
    }

    @Override
    public Se3_F32 createInstance() {
        return new Se3_F32();
    }

    @Override
    public Se3_F32 concat(Se3_F32 second, Se3_F32 result) {
        if (result == null) {
            result = new Se3_F32();
        }
        CommonOps.mult(second.getR(), this.getR(), result.getR());
        GeometryMath_F32.mult(second.getR(), this.getT(), result.getT());
        GeometryMath_F32.add(second.getT(), result.getT(), result.getT());
        return result;
    }

    @Override
    public Se3_F32 invert(Se3_F32 inverse) {
        if (inverse == null) {
            inverse = new Se3_F32();
        }
        GeometryMath_F32.multTran(this.R, this.T, inverse.T);
        GeometryMath_F32.changeSign(inverse.T);
        CommonOps.transpose(this.R, inverse.R);
        return inverse;
    }

    @Override
    public void reset() {
        CommonOps.setIdentity(this.R);
        this.T.set(0.0f, 0.0f, 0.0f);
    }

    public Se3_F32 copy() {
        Se3_F32 ret = new Se3_F32();
        ret.set(this);
        return ret;
    }

    public String toString() {
        String ret = "Se3_F32: T = " + this.T.toString() + "\n";
        ret = ret + this.R;
        return ret + "\n";
    }

    public void print() {
        System.out.println(this);
    }
}

