/*
 * Decompiled with CFR 0.152.
 */
package georegression.struct.line;

import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Vector2D_F64;
import java.io.Serializable;

public class LineParametric2D_F64
implements Serializable {
    public Point2D_F64 p = new Point2D_F64();
    public Vector2D_F64 slope = new Vector2D_F64();

    public LineParametric2D_F64(double x_0, double y_0, double slopeX, double slopeY) {
        this.p.set(x_0, y_0);
        this.slope.set(slopeX, slopeY);
    }

    public LineParametric2D_F64(Point2D_F64 p, Vector2D_F64 slope) {
        this.setPoint(p);
        this.setSlope(slope);
    }

    public LineParametric2D_F64() {
    }

    public void set(LineParametric2D_F64 line) {
        this.p.set(line.p);
        this.slope.set(line.slope);
    }

    public void setPoint(Point2D_F64 pt) {
        this.p.set(pt);
    }

    public void setPoint(double x, double y) {
        this.p.x = x;
        this.p.y = y;
    }

    public void setSlope(Vector2D_F64 slope) {
        this.slope.set(slope);
    }

    public void setSlope(double slopeX, double slopeY) {
        this.slope.x = slopeX;
        this.slope.y = slopeY;
    }

    public void setAngle(double angle) {
        this.slope.set(Math.cos(angle), Math.sin(angle));
    }

    public double getAngle() {
        return Math.atan2(this.slope.y, this.slope.x);
    }

    public Point2D_F64 getPointOnLine(double t) {
        return new Point2D_F64(this.slope.x * t + this.p.x, this.slope.y * t + this.p.y);
    }

    public Point2D_F64 getPoint() {
        return this.p;
    }

    public final double getSlopeX() {
        return this.slope.x;
    }

    public final double getSlopeY() {
        return this.slope.y;
    }

    public final double getX() {
        return this.p.x;
    }

    public final double getY() {
        return this.p.y;
    }

    public Point2D_F64 getP() {
        return this.p;
    }

    public void setP(Point2D_F64 p) {
        this.p = p;
    }

    public Vector2D_F64 getSlope() {
        return this.slope;
    }

    public LineParametric2D_F64 copy() {
        return new LineParametric2D_F64(this.p, this.slope);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " P( " + this.p.x + " " + this.p.y + " ) Slope( " + this.slope.x + " " + this.slope.y + " )";
    }
}

