/*
 * Decompiled with CFR 0.152.
 */
package georegression.metric;

import georegression.geometry.UtilPoint2D_F64;
import georegression.metric.ClosestPoint2D_F64;
import georegression.struct.line.LineGeneral2D_F64;
import georegression.struct.line.LineParametric2D_F64;
import georegression.struct.line.LineSegment2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.shapes.Polygon2D_F64;
import georegression.struct.shapes.Quadrilateral_F64;

public class Distance2D_F64 {
    public static double distance(LineParametric2D_F64 line, Point2D_F64 p) {
        return Math.sqrt(Distance2D_F64.distanceSq(line, p));
    }

    public static double distanceSq(LineParametric2D_F64 line, Point2D_F64 p) {
        double t = ClosestPoint2D_F64.closestPointT(line, p);
        double a = line.slope.x * t + line.p.x;
        double b = line.slope.y * t + line.p.y;
        double dx = p.x - a;
        double dy = p.y - b;
        return dx * dx + dy * dy;
    }

    public static double distance(LineSegment2D_F64 line, Point2D_F64 p) {
        return Math.sqrt(Distance2D_F64.distanceSq(line, p));
    }

    public static double distanceSq(LineSegment2D_F64 line, Point2D_F64 p) {
        double a = line.b.x - line.a.x;
        double b = line.b.y - line.a.y;
        double t = a * (p.x - line.a.x) + b * (p.y - line.a.y);
        if ((t /= a * a + b * b) < 0.0) {
            return UtilPoint2D_F64.distanceSq(line.a.x, line.a.y, p.x, p.y);
        }
        if (t > 1.0) {
            return UtilPoint2D_F64.distanceSq(line.b.x, line.b.y, p.x, p.y);
        }
        return UtilPoint2D_F64.distanceSq(line.a.x + t * a, line.a.y + t * b, p.x, p.y);
    }

    public static double distance(LineSegment2D_F64 segmentA, LineSegment2D_F64 segmentB) {
        return Math.sqrt(Distance2D_F64.distanceSq(segmentA, segmentB));
    }

    public static double distanceSq(LineSegment2D_F64 segmentA, LineSegment2D_F64 segmentB) {
        double slopeAX = segmentA.slopeX();
        double slopeAY = segmentA.slopeY();
        double slopeBX = segmentB.slopeX();
        double slopeBY = segmentB.slopeY();
        double ta = slopeBX * (segmentA.a.y - segmentB.a.y) - slopeBY * (segmentA.a.x - segmentB.a.x);
        double bottom = slopeBY * slopeAX - slopeAY * slopeBX;
        if (bottom != 0.0 && (ta /= bottom) >= 0.0 && ta <= 1.0) {
            double tb = slopeAX * (segmentB.a.y - segmentA.a.y) - slopeAY * (segmentB.a.x - segmentA.a.x);
            if ((tb /= slopeAY * slopeBX - slopeBY * slopeAX) >= 0.0 && tb <= 1.0) {
                return 0.0;
            }
        }
        double closest = Double.MAX_VALUE;
        closest = Math.min(closest, Distance2D_F64.distanceSq(segmentA, segmentB.a));
        closest = Math.min(closest, Distance2D_F64.distanceSq(segmentA, segmentB.b));
        closest = Math.min(closest, Distance2D_F64.distanceSq(segmentB, segmentA.a));
        closest = Math.min(closest, Distance2D_F64.distanceSq(segmentB, segmentA.b));
        return closest;
    }

    public static double distance(Quadrilateral_F64 quad, Point2D_F64 p) {
        return Math.sqrt(Distance2D_F64.distanceSq(quad, p));
    }

    public static double distanceSq(Quadrilateral_F64 quad, Point2D_F64 p) {
        LineSegment2D_F64 seg = LineSegment2D_F64.wrap(quad.a, quad.b);
        double a = Distance2D_F64.distanceSq(seg, p);
        seg.a = quad.b;
        seg.b = quad.c;
        a = Math.min(a, Distance2D_F64.distanceSq(seg, p));
        seg.a = quad.c;
        seg.b = quad.d;
        a = Math.min(a, Distance2D_F64.distanceSq(seg, p));
        seg.a = quad.d;
        seg.b = quad.a;
        return Math.min(a, Distance2D_F64.distanceSq(seg, p));
    }

    public static double distance(Polygon2D_F64 poly, Point2D_F64 p) {
        return Math.sqrt(Distance2D_F64.distanceSq(poly, p, null));
    }

    public static double distanceSq(Polygon2D_F64 poly, Point2D_F64 p, LineSegment2D_F64 storage) {
        if (storage == null) {
            storage = LineSegment2D_F64.wrap(null, null);
        }
        double minimum = Double.MAX_VALUE;
        for (int i = 0; i < poly.size(); ++i) {
            int j = (i + 1) % poly.size();
            storage.a = ((Point2D_F64[])poly.vertexes.data)[i];
            storage.b = ((Point2D_F64[])poly.vertexes.data)[j];
            double d = Distance2D_F64.distanceSq(storage, p);
            if (!(d < minimum)) continue;
            minimum = d;
        }
        return minimum;
    }

    public static double distance(LineGeneral2D_F64 line, Point2D_F64 p) {
        return Math.abs(line.A * p.x + line.B * p.y + line.C) / Math.sqrt(line.A * line.A + line.B * line.B);
    }

    public static double distanceNorm(LineGeneral2D_F64 line, Point2D_F64 p) {
        return Math.abs(line.A * p.x + line.B * p.y + line.C);
    }

    public static double distanceOrigin(LineParametric2D_F64 line) {
        double top = line.slope.y * line.p.x - line.slope.x * line.p.y;
        return Math.abs(top) / line.slope.norm();
    }
}

