/*
 * Decompiled with CFR 0.152.
 */
package georegression.geometry;

import georegression.struct.GeoTuple2D_F64;
import georegression.struct.GeoTuple3D_F64;
import org.ejml.alg.dense.mult.VectorVectorMult;
import org.ejml.data.DenseMatrix64F;

public class GeometryMath_F64 {
    public static DenseMatrix64F crossMatrix(double x0, double x1, double x2, DenseMatrix64F ret) {
        if (ret == null) {
            ret = new DenseMatrix64F(3, 3);
        } else {
            ret.zero();
        }
        ret.set(0, 1, -x2);
        ret.set(0, 2, x1);
        ret.set(1, 0, x2);
        ret.set(1, 2, -x0);
        ret.set(2, 0, -x1);
        ret.set(2, 1, x0);
        return ret;
    }

    public static DenseMatrix64F crossMatrix(GeoTuple3D_F64 v, DenseMatrix64F ret) {
        if (ret == null) {
            ret = new DenseMatrix64F(3, 3);
        } else {
            ret.zero();
        }
        double x = v.getX();
        double y = v.getY();
        double z = v.getZ();
        ret.set(0, 1, -z);
        ret.set(0, 2, y);
        ret.set(1, 0, z);
        ret.set(1, 2, -x);
        ret.set(2, 0, -y);
        ret.set(2, 1, x);
        return ret;
    }

    public static void cross(GeoTuple3D_F64 a, GeoTuple3D_F64 b, GeoTuple3D_F64 c) {
        c.x = a.y * b.z - a.z * b.y;
        c.y = a.z * b.x - a.x * b.z;
        c.z = a.x * b.y - a.y * b.x;
    }

    public static void cross(double a_x, double a_y, double a_z, double b_x, double b_y, double b_z, GeoTuple3D_F64 c) {
        c.x = a_y * b_z - a_z * b_y;
        c.y = a_z * b_x - a_x * b_z;
        c.z = a_x * b_y - a_y * b_x;
    }

    public static void cross(GeoTuple2D_F64 a, GeoTuple3D_F64 b, GeoTuple3D_F64 c) {
        c.x = a.y * b.z - b.y;
        c.y = b.x - a.x * b.z;
        c.z = a.x * b.y - a.y * b.x;
    }

    public static void cross(GeoTuple2D_F64 a, GeoTuple2D_F64 b, GeoTuple3D_F64 c) {
        c.x = a.y * 1.0 - b.y;
        c.y = b.x - a.x;
        c.z = a.x * b.y - a.y * b.x;
    }

    public static void add(GeoTuple3D_F64 a, GeoTuple3D_F64 b, GeoTuple3D_F64 c) {
        c.x = a.x + b.x;
        c.y = a.y + b.y;
        c.z = a.z + b.z;
    }

    public static void add(double a0, GeoTuple3D_F64 pt0, double a1, GeoTuple3D_F64 pt1, GeoTuple3D_F64 pt2) {
        pt2.x = a0 * pt0.x + a1 * pt1.x;
        pt2.y = a0 * pt0.y + a1 * pt1.y;
        pt2.z = a0 * pt0.z + a1 * pt1.z;
    }

    public static <T extends GeoTuple3D_F64> T addMult(T p0, DenseMatrix64F M, T p1, T ret) {
        ret = GeometryMath_F64.mult(M, p1, ret);
        ret.x += p0.x;
        ret.y += p0.y;
        ret.z += p0.z;
        return ret;
    }

    public static void sub(GeoTuple3D_F64 a, GeoTuple3D_F64 b, GeoTuple3D_F64 c) {
        c.x = a.x - b.x;
        c.y = a.y - b.y;
        c.z = a.z - b.z;
    }

    public static void rotate(double theta, GeoTuple2D_F64 pt, GeoTuple2D_F64 solution) {
        double c = Math.cos(theta);
        double s = Math.sin(theta);
        double x = pt.x;
        double y = pt.y;
        solution.x = c * x - s * y;
        solution.y = s * x + c * y;
    }

    public static void rotate(double c, double s, GeoTuple2D_F64 pt, GeoTuple2D_F64 solution) {
        double x = pt.x;
        double y = pt.y;
        solution.x = c * x - s * y;
        solution.y = s * x + c * y;
    }

    public static <T extends GeoTuple3D_F64> T mult(DenseMatrix64F M, T pt, T result) {
        if (M.numRows != 3 || M.numCols != 3) {
            throw new IllegalArgumentException("Input matrix must be 3 by 3, not " + M.numRows + " " + M.numCols);
        }
        if (result == null) {
            result = (GeoTuple3D_F64)pt.createNewInstance();
        }
        double x = pt.x;
        double y = pt.y;
        double z = pt.z;
        result.x = M.unsafe_get(0, 0) * x + M.unsafe_get(0, 1) * y + M.unsafe_get(0, 2) * z;
        result.y = M.unsafe_get(1, 0) * x + M.unsafe_get(1, 1) * y + M.unsafe_get(1, 2) * z;
        result.z = M.unsafe_get(2, 0) * x + M.unsafe_get(2, 1) * y + M.unsafe_get(2, 2) * z;
        return result;
    }

    public static <T extends GeoTuple2D_F64> T mult(DenseMatrix64F M, GeoTuple3D_F64 pt, T mod) {
        if (M.numRows != 3 || M.numCols != 3) {
            throw new IllegalArgumentException("Input matrix must be 3 by 3, not " + M.numRows + " " + M.numCols);
        }
        double x = pt.x;
        double y = pt.y;
        double z = pt.z;
        mod.x = M.unsafe_get(0, 0) * x + M.unsafe_get(0, 1) * y + M.unsafe_get(0, 2) * z;
        mod.y = M.unsafe_get(1, 0) * x + M.unsafe_get(1, 1) * y + M.unsafe_get(1, 2) * z;
        z = M.unsafe_get(2, 0) * x + M.unsafe_get(2, 1) * y + M.unsafe_get(2, 2) * z;
        mod.x /= z;
        mod.y /= z;
        return mod;
    }

    public static void mult(DenseMatrix64F M, GeoTuple2D_F64 pt, GeoTuple3D_F64 mod) {
        if (M.numRows != 3 || M.numCols != 3) {
            throw new IllegalArgumentException("Input matrix must be 3 by 3, not " + M.numRows + " " + M.numCols);
        }
        double x = pt.x;
        double y = pt.y;
        mod.x = M.unsafe_get(0, 0) * x + M.unsafe_get(0, 1) * y + M.unsafe_get(0, 2);
        mod.y = M.unsafe_get(1, 0) * x + M.unsafe_get(1, 1) * y + M.unsafe_get(1, 2);
        mod.z = M.unsafe_get(2, 0) * x + M.unsafe_get(2, 1) * y + M.unsafe_get(2, 2);
    }

    public static <T extends GeoTuple2D_F64> T mult(DenseMatrix64F M, T pt, T mod) {
        if (M.numRows != 3 || M.numCols != 3) {
            throw new IllegalArgumentException("Input matrix must be 3 by 3, not " + M.numRows + " " + M.numCols);
        }
        if (mod == null) {
            throw new IllegalArgumentException("Must provide an instance in mod");
        }
        double x = pt.x;
        double y = pt.y;
        double modz = M.unsafe_get(2, 0) * x + M.unsafe_get(2, 1) * y + M.unsafe_get(2, 2);
        mod.x = (M.unsafe_get(0, 0) * x + M.unsafe_get(0, 1) * y + M.unsafe_get(0, 2)) / modz;
        mod.y = (M.unsafe_get(1, 0) * x + M.unsafe_get(1, 1) * y + M.unsafe_get(1, 2)) / modz;
        return mod;
    }

    public static DenseMatrix64F multCrossA(GeoTuple2D_F64 A, DenseMatrix64F M, DenseMatrix64F result) {
        if (M.numRows != 3 || M.numCols != 3) {
            throw new IllegalArgumentException("Input matrix must be 3 by 3, not " + M.numRows + " " + M.numCols);
        }
        if (result == null) {
            result = new DenseMatrix64F(3, 3);
        }
        double x = A.x;
        double y = A.y;
        double a11 = M.data[0];
        double a12 = M.data[1];
        double a13 = M.data[2];
        double a21 = M.data[3];
        double a22 = M.data[4];
        double a23 = M.data[5];
        double a31 = M.data[6];
        double a32 = M.data[7];
        double a33 = M.data[8];
        result.data[0] = -a21 + a31 * y;
        result.data[1] = -a22 + a32 * y;
        result.data[2] = -a23 + a33 * y;
        result.data[3] = a11 - a31 * x;
        result.data[4] = a12 - a32 * x;
        result.data[5] = a13 - a33 * x;
        result.data[6] = -a11 * y + a21 * x;
        result.data[7] = -a12 * y + a22 * x;
        result.data[8] = -a13 * y + a23 * x;
        return result;
    }

    public static DenseMatrix64F multCrossA(GeoTuple3D_F64 A, DenseMatrix64F M, DenseMatrix64F result) {
        if (M.numRows != 3 || M.numCols != 3) {
            throw new IllegalArgumentException("Input matrix must be 3 by 3, not " + M.numRows + " " + M.numCols);
        }
        if (result == null) {
            result = new DenseMatrix64F(3, 3);
        }
        double x = A.x;
        double y = A.y;
        double z = A.z;
        double a11 = M.data[0];
        double a12 = M.data[1];
        double a13 = M.data[2];
        double a21 = M.data[3];
        double a22 = M.data[4];
        double a23 = M.data[5];
        double a31 = M.data[6];
        double a32 = M.data[7];
        double a33 = M.data[8];
        result.data[0] = -a21 * z + a31 * y;
        result.data[1] = -a22 * z + a32 * y;
        result.data[2] = -a23 * z + a33 * y;
        result.data[3] = a11 * z - a31 * x;
        result.data[4] = a12 * z - a32 * x;
        result.data[5] = a13 * z - a33 * x;
        result.data[6] = -a11 * y + a21 * x;
        result.data[7] = -a12 * y + a22 * x;
        result.data[8] = -a13 * y + a23 * x;
        return result;
    }

    public static <T extends GeoTuple3D_F64> T multTran(DenseMatrix64F M, T pt, T mod) {
        if (M.numRows != 3 || M.numCols != 3) {
            throw new IllegalArgumentException("Rotation matrices are 3 by 3.");
        }
        if (mod == null) {
            mod = (GeoTuple3D_F64)pt.createNewInstance();
        }
        double x = pt.x;
        double y = pt.y;
        double z = pt.z;
        mod.x = M.unsafe_get(0, 0) * x + M.unsafe_get(1, 0) * y + M.unsafe_get(2, 0) * z;
        mod.y = M.unsafe_get(0, 1) * x + M.unsafe_get(1, 1) * y + M.unsafe_get(2, 1) * z;
        mod.z = M.unsafe_get(0, 2) * x + M.unsafe_get(1, 2) * y + M.unsafe_get(2, 2) * z;
        return mod;
    }

    public static <T extends GeoTuple3D_F64> T multTran(DenseMatrix64F M, GeoTuple2D_F64 pt, T mod) {
        if (M.numRows != 3 || M.numCols != 3) {
            throw new IllegalArgumentException("Rotation matrices are 3 by 3.");
        }
        if (mod == null) {
            throw new IllegalArgumentException("Must provide an instance in mod");
        }
        double x = pt.x;
        double y = pt.y;
        mod.x = M.unsafe_get(0, 0) * x + M.unsafe_get(1, 0) * y + M.unsafe_get(2, 0);
        mod.y = M.unsafe_get(0, 1) * x + M.unsafe_get(1, 1) * y + M.unsafe_get(2, 1);
        mod.z = M.unsafe_get(0, 2) * x + M.unsafe_get(1, 2) * y + M.unsafe_get(2, 2);
        return mod;
    }

    public static <T extends GeoTuple2D_F64> T multTran(DenseMatrix64F M, GeoTuple2D_F64 pt, T mod) {
        if (M.numRows != 3 || M.numCols != 3) {
            throw new IllegalArgumentException("Rotation matrices are 3 by 3.");
        }
        if (mod == null) {
            throw new IllegalArgumentException("Must provide an instance in mod");
        }
        double x = pt.x;
        double y = pt.y;
        double modZ = M.unsafe_get(0, 2) * x + M.unsafe_get(1, 2) * y + M.unsafe_get(2, 2);
        mod.x = (M.unsafe_get(0, 0) * x + M.unsafe_get(1, 0) * y + M.unsafe_get(2, 0)) / modZ;
        mod.y = (M.unsafe_get(0, 1) * x + M.unsafe_get(1, 1) * y + M.unsafe_get(2, 1)) / modZ;
        return mod;
    }

    public static double innerProd(GeoTuple3D_F64 a, DenseMatrix64F M, GeoTuple3D_F64 b) {
        if (M.numRows != 3 || M.numCols != 3) {
            throw new IllegalArgumentException("M must be 3 by 3.");
        }
        DenseMatrix64F m1 = new DenseMatrix64F(3, 1, true, a.x, a.y, a.z);
        DenseMatrix64F m2 = new DenseMatrix64F(3, 1, true, b.x, b.y, b.z);
        return VectorVectorMult.innerProdA(m1, M, m2);
    }

    public static double innerProdTranM(GeoTuple3D_F64 a, DenseMatrix64F M, GeoTuple3D_F64 b) {
        if (M.numRows != 3 || M.numCols != 3) {
            throw new IllegalArgumentException("M must be 3 by 3.");
        }
        DenseMatrix64F m1 = new DenseMatrix64F(3, 1, true, a.x, a.y, a.z);
        DenseMatrix64F m2 = new DenseMatrix64F(3, 1, true, b.x, b.y, b.z);
        return VectorVectorMult.innerProdTranA(m1, M, m2);
    }

    public static DenseMatrix64F outerProd(GeoTuple3D_F64 a, GeoTuple3D_F64 b, DenseMatrix64F ret) {
        if (ret == null) {
            ret = new DenseMatrix64F(3, 3);
        }
        ret.data[0] = a.x * b.x;
        ret.data[1] = a.x * b.y;
        ret.data[2] = a.x * b.z;
        ret.data[3] = a.y * b.x;
        ret.data[4] = a.y * b.y;
        ret.data[5] = a.y * b.z;
        ret.data[6] = a.z * b.x;
        ret.data[7] = a.z * b.y;
        ret.data[8] = a.z * b.z;
        return ret;
    }

    public static DenseMatrix64F addOuterProd(DenseMatrix64F A, double scalar, GeoTuple3D_F64 b, GeoTuple3D_F64 c, DenseMatrix64F ret) {
        if (ret == null) {
            ret = new DenseMatrix64F(3, 3);
        }
        ret.data[0] = A.data[0] + scalar * b.x * c.x;
        ret.data[1] = A.data[1] + scalar * b.x * c.y;
        ret.data[2] = A.data[2] + scalar * b.x * c.z;
        ret.data[3] = A.data[3] + scalar * b.y * c.x;
        ret.data[4] = A.data[4] + scalar * b.y * c.y;
        ret.data[5] = A.data[5] + scalar * b.y * c.z;
        ret.data[6] = A.data[6] + scalar * b.z * c.x;
        ret.data[7] = A.data[7] + scalar * b.z * c.y;
        ret.data[8] = A.data[8] + scalar * b.z * c.z;
        return ret;
    }

    public static double innerProd(GeoTuple2D_F64 a, DenseMatrix64F M, GeoTuple2D_F64 b) {
        if (M.numRows != 3 || M.numCols != 3) {
            throw new IllegalArgumentException("M must be 3 by 3.");
        }
        DenseMatrix64F m1 = new DenseMatrix64F(3, 1, true, a.x, a.y, 1.0);
        DenseMatrix64F m2 = new DenseMatrix64F(3, 1, true, b.x, b.y, 1.0);
        return VectorVectorMult.innerProdA(m1, M, m2);
    }

    public static double dot(GeoTuple3D_F64 a, GeoTuple3D_F64 b) {
        return a.x * b.x + a.y * b.y + a.z * b.z;
    }

    public static void scale(GeoTuple3D_F64 p, double v) {
        p.x *= v;
        p.y *= v;
        p.z *= v;
    }

    public static void changeSign(GeoTuple3D_F64 t) {
        t.x = -t.x;
        t.y = -t.y;
        t.z = -t.z;
    }

    public static DenseMatrix64F toMatrix(GeoTuple3D_F64 in, DenseMatrix64F out) {
        if (out == null) {
            out = new DenseMatrix64F(3, 1);
        } else if (out.getNumElements() != 3) {
            throw new IllegalArgumentException("Vector with 3 elements expected");
        }
        out.data[0] = in.x;
        out.data[1] = in.y;
        out.data[2] = in.z;
        return out;
    }

    public static void toTuple3D(DenseMatrix64F in, GeoTuple3D_F64 out) {
        out.x = in.get(0);
        out.y = in.get(1);
        out.z = in.get(2);
    }
}

