/*
 * Decompiled with CFR 0.152.
 */
package georegression.fitting.se;

import georegression.fitting.MotionTransformPoint;
import georegression.geometry.GeometryMath_F64;
import georegression.geometry.UtilPoint3D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import java.util.List;
import org.ejml.data.DenseMatrix64F;
import org.ejml.factory.DecompositionFactory;
import org.ejml.interfaces.decomposition.SingularValueDecomposition;
import org.ejml.ops.CommonOps;
import org.ejml.ops.SingularOps;

public class MotionSe3PointSVD_F64
implements MotionTransformPoint<Se3_F64, Point3D_F64> {
    private Se3_F64 motion = new Se3_F64();
    SingularValueDecomposition<DenseMatrix64F> svd = DecompositionFactory.svd(3, 3, true, true, false);

    @Override
    public Se3_F64 getTransformSrcToDst() {
        return this.motion;
    }

    @Override
    public boolean process(List<Point3D_F64> srcPts, List<Point3D_F64> dstPts) {
        if (srcPts.size() != dstPts.size()) {
            throw new IllegalArgumentException("There must be a 1 to 1 correspondence between the two sets of points");
        }
        Point3D_F64 meanSrc = UtilPoint3D_F64.mean(srcPts, null);
        Point3D_F64 meanDst = UtilPoint3D_F64.mean(dstPts, null);
        int N = srcPts.size();
        double s11 = 0.0;
        double s12 = 0.0;
        double s13 = 0.0;
        double s21 = 0.0;
        double s22 = 0.0;
        double s23 = 0.0;
        double s31 = 0.0;
        double s32 = 0.0;
        double s33 = 0.0;
        for (int i = 0; i < N; ++i) {
            Point3D_F64 f = srcPts.get(i);
            Point3D_F64 t = dstPts.get(i);
            double dfx = f.x - meanSrc.x;
            double dfy = f.y - meanSrc.y;
            double dfz = f.z - meanSrc.z;
            double dtx = t.x - meanDst.x;
            double dty = t.y - meanDst.y;
            double dtz = t.z - meanDst.z;
            s11 += dtx * dfx;
            s12 += dtx * dfy;
            s13 += dtx * dfz;
            s21 += dty * dfx;
            s22 += dty * dfy;
            s23 += dty * dfz;
            s31 += dtz * dfx;
            s32 += dtz * dfy;
            s33 += dtz * dfz;
        }
        DenseMatrix64F Sigma = new DenseMatrix64F(3, 3, true, s11, s12, s13, s21, s22, s23, s31, s32, s33);
        if (!this.svd.decompose(Sigma)) {
            throw new RuntimeException("SVD failed!?");
        }
        DenseMatrix64F U = this.svd.getU(null, false);
        DenseMatrix64F V = this.svd.getV(null, false);
        SingularOps.descendingOrder(U, false, this.svd.getSingularValues(), 3, V, false);
        if (CommonOps.det(U) < 0.0 ^ CommonOps.det(V) < 0.0) {
            V.data[2] = -V.data[2];
            V.data[5] = -V.data[5];
            V.data[8] = -V.data[8];
        }
        CommonOps.multTransB(U, V, this.motion.getR());
        Point3D_F64 temp = new Point3D_F64();
        GeometryMath_F64.mult(this.motion.getR(), meanSrc, temp);
        this.motion.getT().set(meanDst.x - temp.x, meanDst.y - temp.y, meanDst.z - temp.z);
        return true;
    }

    @Override
    public int getMinimumPoints() {
        return 3;
    }
}

