/*
 * Decompiled with CFR 0.152.
 */
package georegression.fitting.ellipse;

import georegression.struct.point.Vector2D_F32;
import org.ejml.data.Complex64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.factory.DecompositionFactory;
import org.ejml.interfaces.decomposition.EigenDecomposition;

public class CovarianceToEllipse_F32 {
    EigenDecomposition<DenseMatrix64F> eigen = DecompositionFactory.eig(2, true);
    DenseMatrix64F Q = new DenseMatrix64F(2, 2);
    Vector2D_F32 x = new Vector2D_F32();
    Vector2D_F32 y = new Vector2D_F32();
    float lengthX;
    float lengthY;
    float numStdev = 1.0f;

    public void setNumStdev(float numStdev) {
        this.numStdev = numStdev;
    }

    public boolean setCovariance(float a11, float a12, float a22) {
        DenseMatrix64F a1;
        DenseMatrix64F a0;
        this.Q.data[0] = a11;
        this.Q.data[1] = a12;
        this.Q.data[2] = a12;
        this.Q.data[3] = a22;
        if (!this.eigen.decompose(this.Q)) {
            System.err.println("Eigenvalue decomposition failed!");
            return false;
        }
        Complex64F v0 = this.eigen.getEigenvalue(0);
        Complex64F v1 = this.eigen.getEigenvalue(1);
        if (v0.getMagnitude2() > v1.getMagnitude2()) {
            a0 = this.eigen.getEigenVector(0);
            a1 = this.eigen.getEigenVector(1);
            this.lengthX = (float)v0.getMagnitude();
            this.lengthY = (float)v1.getMagnitude();
        } else {
            a0 = this.eigen.getEigenVector(1);
            a1 = this.eigen.getEigenVector(0);
            this.lengthX = (float)v1.getMagnitude();
            this.lengthY = (float)v0.getMagnitude();
        }
        if (a0 == null || a1 == null) {
            System.err.println("Complex eigenvalues: " + v0 + "  " + v1);
            return false;
        }
        this.lengthX = (float)Math.sqrt(this.lengthX);
        this.lengthY = (float)Math.sqrt(this.lengthY);
        this.x.set((float)a0.get(0), (float)a0.get(1));
        this.y.set((float)a1.get(0), (float)a1.get(1));
        return true;
    }

    public Vector2D_F32 getMajorVector() {
        return this.x;
    }

    public Vector2D_F32 getMinorVector() {
        return this.y;
    }

    public float getAngle() {
        return (float)Math.atan2(this.x.y, this.x.x);
    }

    public float getMajorAxis() {
        return this.numStdev * this.lengthX;
    }

    public float getMinorAxis() {
        return this.numStdev * this.lengthY;
    }
}

