/*
 * Decompiled with CFR 0.152.
 */
package georegression.fitting.cylinder;

import georegression.fitting.cylinder.CodecCylinder3D_F32;
import georegression.metric.MiscOps;
import georegression.struct.point.Point3D_F32;
import georegression.struct.point.Vector3D_F32;
import georegression.struct.shapes.Cylinder3D_F32;
import java.util.List;
import org.ddogleg.optimization.functions.FunctionNtoMxN;

public class CylinderToPointSignedDistanceJacobian_F32
implements FunctionNtoMxN {
    private Cylinder3D_F32 cylinder = new Cylinder3D_F32();
    private List<Point3D_F32> points;
    private CodecCylinder3D_F32 codec = new CodecCylinder3D_F32();

    public void setPoints(List<Point3D_F32> points) {
        this.points = points;
    }

    @Override
    public int getNumOfInputsN() {
        return 7;
    }

    @Override
    public int getNumOfOutputsM() {
        return this.points.size();
    }

    @Override
    public void process(double[] input, double[] output) {
        this.codec.decode(input, this.cylinder);
        Point3D_F32 cp = this.cylinder.line.p;
        Vector3D_F32 cs = this.cylinder.line.slope;
        float slopeDot = cs.dot(cs);
        float slopeNorm = (float)Math.sqrt(slopeDot);
        int index = 0;
        for (int i = 0; i < this.points.size(); ++i) {
            Point3D_F32 p = this.points.get(i);
            float x = cp.x - p.x;
            float y = cp.y - p.y;
            float z = cp.z - p.z;
            float cc = x * x + y * y + z * z;
            float xdots = MiscOps.dot(x, y, z, cs);
            float b = xdots / slopeNorm;
            float distance = cc - b * b;
            if (distance < 0.0f) {
                output[index++] = 0.0;
                output[index++] = 0.0;
                output[index++] = 0.0;
                output[index++] = 0.0;
                output[index++] = 0.0;
                output[index++] = 0.0;
                output[index++] = -1.0;
                continue;
            }
            distance = (float)Math.sqrt(distance);
            output[index++] = (cp.x - p.x - xdots * cs.x / slopeDot) / distance;
            output[index++] = (cp.y - p.y - xdots * cs.y / slopeDot) / distance;
            output[index++] = (cp.z - p.z - xdots * cs.z / slopeDot) / distance;
            output[index++] = -xdots * ((cp.x - p.x) / slopeDot - xdots / slopeDot * (cs.x / slopeDot)) / distance;
            output[index++] = -xdots * ((cp.y - p.y) / slopeDot - xdots / slopeDot * (cs.y / slopeDot)) / distance;
            output[index++] = -xdots * ((cp.z - p.z) / slopeDot - xdots / slopeDot * (cs.z / slopeDot)) / distance;
            output[index++] = -1.0;
        }
    }
}

