/*
 * Decompiled with CFR 0.152.
 */
package georegression.examples;

import georegression.metric.Distance2D_F64;
import georegression.metric.Intersection2D_F64;
import georegression.struct.line.LineParametric2D_F64;
import georegression.struct.line.LineSegment2D_F64;
import georegression.struct.point.Point2D_F64;

public class ExampleMetricLine {
    public static void distancePointToLine() {
        System.out.println("Distance of points to lines");
        Point2D_F64 a = new Point2D_F64(0.0, 0.0);
        Point2D_F64 b = new Point2D_F64(10.0, 10.0);
        Point2D_F64 c = new Point2D_F64(20.0, 20.0);
        Point2D_F64 d = new Point2D_F64(5.0, 8.0);
        LineSegment2D_F64 ls = new LineSegment2D_F64(a, b);
        LineParametric2D_F64 lp = new LineParametric2D_F64(a.x, a.y, b.x - a.x, b.y - a.y);
        System.out.println("Distance of line segment to point c     : " + Distance2D_F64.distance(ls, c));
        System.out.println("Distance of parametric line to point c  : " + Distance2D_F64.distance(lp, c));
        System.out.println("Distance of line segment to point d     : " + Distance2D_F64.distance(ls, d));
        System.out.println("Distance of parametric line to point d  : " + Distance2D_F64.distance(lp, d));
    }

    public static void intersectionLineSegment() {
        LineSegment2D_F64 lineA = new LineSegment2D_F64(-10.0, -10.0, 10.0, 10.0);
        LineSegment2D_F64 lineB = new LineSegment2D_F64(-10.0, 10.0, 10.0, -10.0);
        LineSegment2D_F64 lineC = new LineSegment2D_F64(-10.0, -9.0, 10.0, 11.0);
        LineSegment2D_F64 lineD = new LineSegment2D_F64(-20.0, -20.0, -18.0, -18.0);
        LineSegment2D_F64 lineE = new LineSegment2D_F64(-20.0, -20.0, -9.0, -9.0);
        System.out.println("Intersection between line segments");
        System.out.println("A and B (one)  : " + Intersection2D_F64.intersection(lineA, lineB, null));
        System.out.println("A and C (none) : " + Intersection2D_F64.intersection(lineA, lineC, null));
        System.out.println("A and D (none) : " + Intersection2D_F64.intersection(lineA, lineD, null));
        System.out.println("A and E (many) : " + Intersection2D_F64.intersection(lineA, lineE, null));
    }

    public static void intersectionParametric() {
        LineParametric2D_F64 lineA = new LineParametric2D_F64(0.0, 0.0, 1.0, 1.0);
        LineParametric2D_F64 lineB = new LineParametric2D_F64(0.0, 0.0, 1.0, -1.0);
        LineParametric2D_F64 lineC = new LineParametric2D_F64(1.0, 0.0, 1.0, 1.0);
        LineParametric2D_F64 lineD = new LineParametric2D_F64(-1.0, -1.0, 1.0, 1.0);
        System.out.println("Intersection between lines");
        System.out.println("A and B (one)  : " + Intersection2D_F64.intersection(lineA, lineB));
        System.out.println("A and C (none) : " + Intersection2D_F64.intersection(lineA, lineC));
        System.out.println("A and D (many) : " + Intersection2D_F64.intersection(lineA, lineD));
    }

    public static void main(String[] args) {
        ExampleMetricLine.distancePointToLine();
        System.out.println();
        ExampleMetricLine.intersectionLineSegment();
        System.out.println();
        ExampleMetricLine.intersectionParametric();
    }
}

