/*
 * Decompiled with CFR 0.152.
 */
package org.spaceroots.rkcheck;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import org.spaceroots.rkcheck.QuadraticSurd;
import org.spaceroots.rkcheck.RKCheckException;
import org.spaceroots.rkcheck.RungeKuttaMethod;
import org.spaceroots.rkcheck.XMLFile;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RungeKuttaFile
extends XMLFile {
    private static String EltRungeKutta = "Runge-Kutta";
    private static String EltTime = "time-steps";
    private static String EltInternal = "internal-weights";
    private static String EltEstimation = "estimation-weights";
    private static String EltError = "error-weights";
    private static String EltRow = "row";
    private static String EltZero = "zero";
    private static String EltOne = "one";
    private static String EltInteger = "integer";
    private static String EltRational = "rational";
    private static String EltQSurd = "quadratic-surd";
    private static String EltReal = "real";
    private static String EltP = "p";
    private static String EltQ = "q";
    private static String EltP1 = "p1";
    private static String EltP2 = "p2";
    private static String EltD = "d";
    private static String AttRungeKuttaName = "name";
    RungeKuttaMethod method;

    public RungeKuttaFile(RungeKuttaMethod method) throws RKCheckException {
        this.method = method;
    }

    @Override
    public void analyze(Document document, String uri) throws RKCheckException, NumberFormatException {
        Element rkElt = this.getElement(document, EltRungeKutta, false);
        this.method.setName(this.getAttribute(rkElt, AttRungeKuttaName, false));
        QuadraticSurd[] timeSteps = this.analyzeList(this.getElement(rkElt, EltTime, false));
        int stages = timeSteps.length;
        this.method.setTimeSteps(timeSteps);
        QuadraticSurd[][] internalWeights = new QuadraticSurd[stages][];
        NodeList list = this.getElement(rkElt, EltInternal, false).getChildNodes();
        int s = 0;
        for (int i = 0; i < list.getLength(); ++i) {
            Node row = list.item(i);
            if (row.getNodeType() != 1 || !row.getNodeName().equals(EltRow)) continue;
            internalWeights[s] = this.analyzeList(row);
            if (internalWeights[s].length != s) {
                throw new RKCheckException("row {0} has {1} elements, but should have {2} elements", new String[]{Integer.toString(s + 1), Integer.toString(internalWeights[s].length), Integer.toString(s)});
            }
            ++s;
        }
        if (s != stages) {
            throw new RKCheckException("internal weights array has {0} rows, but time steps array has {1} elements", new String[]{Integer.toString(s), Integer.toString(stages)});
        }
        this.method.setInternalWeights(internalWeights);
        QuadraticSurd[] estimationWeights = this.analyzeList(this.getElement(rkElt, EltEstimation, false));
        if (estimationWeights.length != stages) {
            throw new RKCheckException("estimation weights array has {0} rows, but time steps array has {1} elements", new String[]{Integer.toString(estimationWeights.length), Integer.toString(stages)});
        }
        this.method.setEstimationWeights(estimationWeights);
        Element errorElt = this.getElement(rkElt, EltError, true);
        if (errorElt != null) {
            QuadraticSurd[] errorWeights = this.analyzeList(errorElt);
            if (errorWeights.length != stages) {
                throw new RKCheckException("error weights array has {0} rows, but time steps array has {1} elements", new String[]{Integer.toString(errorWeights.length), Integer.toString(stages)});
            }
            this.method.setErrorWeights(errorWeights);
        }
    }

    private QuadraticSurd[] analyzeList(Node element) throws RKCheckException {
        ArrayList<QuadraticSurd> numbers = new ArrayList<QuadraticSurd>();
        NodeList list = element.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node number = list.item(i);
            if (number.getNodeType() != 1) continue;
            if (number.getNodeName().equals(EltZero)) {
                numbers.add(new QuadraticSurd(0L));
                continue;
            }
            if (number.getNodeName().equals(EltOne)) {
                numbers.add(new QuadraticSurd(1L));
                continue;
            }
            if (number.getNodeName().equals(EltInteger)) {
                numbers.add(new QuadraticSurd(new BigInteger(this.getContent(number).trim())));
                continue;
            }
            if (number.getNodeName().equals(EltRational)) {
                BigInteger p = new BigInteger(this.getContent(this.getElement(number, EltP, false)).trim());
                BigInteger q = new BigInteger(this.getContent(this.getElement(number, EltQ, false)).trim());
                numbers.add(new QuadraticSurd(p, q));
                continue;
            }
            if (number.getNodeName().equals(EltQSurd)) {
                BigInteger p1 = new BigInteger(this.getContent(this.getElement(number, EltP1, false)).trim());
                BigInteger p2 = new BigInteger(this.getContent(this.getElement(number, EltP2, false)).trim());
                BigInteger d = new BigInteger(this.getContent(this.getElement(number, EltD, false)).trim());
                BigInteger q = new BigInteger(this.getContent(this.getElement(number, EltQ, false)).trim());
                numbers.add(new QuadraticSurd(p1, p2, d, q));
                continue;
            }
            if (!number.getNodeName().equals(EltReal)) continue;
            BigDecimal r = new BigDecimal(this.getContent(number).trim());
            BigDecimal tol = new BigDecimal(BigInteger.ONE, r.scale());
            numbers.add(new QuadraticSurd(r, tol));
        }
        return numbers.toArray(new QuadraticSurd[numbers.size()]);
    }

    @Override
    public void build(Document document, String uri) throws RKCheckException {
        Element rkElt = document.createElement(EltRungeKutta);
        rkElt.setAttribute(AttRungeKuttaName, this.method.getName());
        document.appendChild(rkElt);
        Element timeElt = this.buildList(document, EltTime, this.method.getTimeSteps());
        rkElt.appendChild(timeElt);
        QuadraticSurd[][] internalWeights = this.method.getInternalWeights();
        Element internalElt = document.createElement(EltInternal);
        for (int i = 0; i < internalWeights.length; ++i) {
            internalElt.appendChild(this.buildList(document, EltRow, internalWeights[i]));
        }
        rkElt.appendChild(internalElt);
        Element estimationElt = this.buildList(document, EltEstimation, this.method.getEstimationWeights());
        rkElt.appendChild(estimationElt);
        if (this.method.getErrorWeights() != null) {
            Element errorWeights = this.buildList(document, EltError, this.method.getErrorWeights());
            rkElt.appendChild(errorWeights);
        }
    }

    private Element buildList(Document document, String name, QuadraticSurd[] numbers) {
        Element element = document.createElement(name);
        for (int i = 0; i < numbers.length; ++i) {
            QuadraticSurd number = numbers[i];
            if (number.isZero()) {
                element.appendChild(document.createElement(EltZero));
                continue;
            }
            if (number.isOne()) {
                element.appendChild(document.createElement(EltOne));
                continue;
            }
            if (number.isInteger()) {
                BigInteger n = number.getRationalNumerator();
                Element integerElt = document.createElement(EltInteger);
                integerElt.appendChild(document.createTextNode(n.toString()));
                element.appendChild(integerElt);
                continue;
            }
            if (number.isRational()) {
                Element rationalElt = document.createElement(EltRational);
                Element pElt = document.createElement(EltP);
                pElt.appendChild(document.createTextNode(number.getRationalNumerator().toString()));
                Element qElt = document.createElement(EltQ);
                qElt.appendChild(document.createTextNode(number.getDenominator().toString()));
                rationalElt.appendChild(pElt);
                rationalElt.appendChild(qElt);
                element.appendChild(rationalElt);
                continue;
            }
            Element qSurdElt = document.createElement(EltQSurd);
            Element p1Elt = document.createElement(EltP1);
            p1Elt.appendChild(document.createTextNode(number.getRationalNumerator().toString()));
            Element p2Elt = document.createElement(EltP2);
            p2Elt.appendChild(document.createTextNode(number.getRootCoefficient().toString()));
            Element dElt = document.createElement(EltD);
            dElt.appendChild(document.createTextNode(number.getRootElement().toString()));
            Element qElt = document.createElement(EltQ);
            qElt.appendChild(document.createTextNode(number.getDenominator().toString()));
            qSurdElt.appendChild(p1Elt);
            qSurdElt.appendChild(p2Elt);
            qSurdElt.appendChild(dElt);
            qSurdElt.appendChild(qElt);
            element.appendChild(qSurdElt);
        }
        return element;
    }

    @Override
    protected String getPublicId() {
        return "-//spaceroots.org//DTD Runge-Kutta V1.2//EN";
    }

    @Override
    protected String getSystemId() {
        return "http://www.spaceroots.org/Runge-Kutta.dtd";
    }
}

