/*
 * Decompiled with CFR 0.152.
 */
package javolution37.javolution.xml.sax;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javolution37.javolution.lang.Reflection;
import javolution37.javolution.xml.sax.Attributes;
import javolution37.javolution.xml.sax.ContentHandler;
import javolution37.javolution.xml.sax.XmlSaxParserImpl;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public final class XMLReaderImpl
implements XMLReader {
    private static Sax2DefaultHandler DEFAULT_HANDLER = new Sax2DefaultHandler();
    private final XmlSaxParserImpl _parser = new XmlSaxParserImpl();
    private final Proxy _proxy = new Proxy();
    private static final Reflection.Constructor NEW_URL = Reflection.getConstructor("java.net.URL(java.lang.String)");
    private static final Reflection.Method OPEN_STREAM = Reflection.getMethod("java.net.URL.openStream()");
    private static final Reflection.Constructor NEW_FILE_INPUT_STREAM = Reflection.getConstructor("java.io.FileInputStream(java.lang.String)");

    @Override
    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this._parser.getFeature(name);
    }

    @Override
    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        this._parser.setFeature(name, value);
    }

    @Override
    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this._parser.getProperty(name);
    }

    @Override
    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        this._parser.setProperty(name, value);
    }

    @Override
    public void setEntityResolver(EntityResolver resolver) {
        this._parser.setEntityResolver(resolver);
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this._parser.getEntityResolver();
    }

    @Override
    public void setDTDHandler(DTDHandler handler) {
        this._parser.setDTDHandler(handler);
    }

    @Override
    public DTDHandler getDTDHandler() {
        return this._parser.getDTDHandler();
    }

    @Override
    public void setContentHandler(org.xml.sax.ContentHandler handler) {
        if (handler == null) {
            throw new NullPointerException();
        }
        this._proxy._sax2Handler = handler;
        this._parser.setContentHandler(this._proxy);
    }

    @Override
    public org.xml.sax.ContentHandler getContentHandler() {
        return this._proxy._sax2Handler == DEFAULT_HANDLER ? null : this._proxy._sax2Handler;
    }

    @Override
    public void setErrorHandler(ErrorHandler handler) {
        this._parser.setErrorHandler(handler);
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this._parser.getErrorHandler();
    }

    @Override
    public void parse(InputSource input) throws IOException, SAXException {
        Reader reader = input.getCharacterStream();
        if (reader != null) {
            this._parser.parse(reader);
        } else {
            InputStream inStream = input.getByteStream();
            if (inStream != null) {
                String encoding = input.getEncoding();
                if (encoding == null || encoding.equals("UTF-8") || encoding.equals("utf-8")) {
                    this._parser.parse(inStream);
                } else {
                    reader = new InputStreamReader(inStream, encoding);
                    this._parser.parse(reader);
                }
            } else {
                this.parse(input.getSystemId());
            }
        }
    }

    @Override
    public void parse(String systemId) throws IOException, SAXException {
        InputStream in;
        try {
            Object url = NEW_URL.newInstance(systemId);
            in = (InputStream)OPEN_STREAM.invoke(url);
        }
        catch (Exception urlException) {
            try {
                in = (InputStream)NEW_FILE_INPUT_STREAM.newInstance(systemId);
            }
            catch (Exception fileException) {
                throw new UnsupportedOperationException("Cannot parse " + systemId);
            }
        }
        this._parser.parse(in);
    }

    private static final class Sax2DefaultHandler
    implements EntityResolver,
    DTDHandler,
    org.xml.sax.ContentHandler,
    ErrorHandler {
        private Sax2DefaultHandler() {
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            return null;
        }

        @Override
        public void notationDecl(String name, String publicId, String systemId) throws SAXException {
        }

        @Override
        public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
        }

        @Override
        public void startElement(String uri, String localName, String qName, org.xml.sax.Attributes atts) throws SAXException {
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            throw exception;
        }
    }

    private static final class Proxy
    implements ContentHandler,
    org.xml.sax.Attributes {
        private org.xml.sax.ContentHandler _sax2Handler = XMLReaderImpl.access$200();
        private Attributes _attributes;

        @Override
        public void setDocumentLocator(Locator locator) {
            this._sax2Handler.setDocumentLocator(locator);
        }

        @Override
        public void startDocument() throws SAXException {
            this._sax2Handler.startDocument();
        }

        @Override
        public void endDocument() throws SAXException {
            this._sax2Handler.endDocument();
            this._sax2Handler = DEFAULT_HANDLER;
        }

        @Override
        public void startPrefixMapping(CharSequence prefix, CharSequence uri) throws SAXException {
            this._sax2Handler.startPrefixMapping(prefix.toString(), uri.toString());
        }

        @Override
        public void endPrefixMapping(CharSequence prefix) throws SAXException {
            this._sax2Handler.endPrefixMapping(prefix.toString());
        }

        @Override
        public void startElement(CharSequence namespaceURI, CharSequence localName, CharSequence qName, Attributes atts) throws SAXException {
            this._attributes = atts;
            this._sax2Handler.startElement(namespaceURI.toString(), localName.toString(), qName.toString(), this);
        }

        @Override
        public void endElement(CharSequence namespaceURI, CharSequence localName, CharSequence qName) throws SAXException {
            this._sax2Handler.endElement(namespaceURI.toString(), localName.toString(), qName.toString());
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this._sax2Handler.characters(ch, start, length);
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            this._sax2Handler.ignorableWhitespace(ch, start, length);
        }

        @Override
        public void processingInstruction(CharSequence target, CharSequence data) throws SAXException {
            this._sax2Handler.processingInstruction(target.toString(), data.toString());
        }

        @Override
        public void skippedEntity(CharSequence name) throws SAXException {
            this._sax2Handler.skippedEntity(name.toString());
        }

        @Override
        public int getLength() {
            return this._attributes.getLength();
        }

        @Override
        public String getURI(int index) {
            CharSequence chars = this._attributes.getURI(index);
            return chars != null ? chars.toString() : null;
        }

        @Override
        public String getLocalName(int index) {
            CharSequence chars = this._attributes.getLocalName(index);
            return chars != null ? chars.toString() : null;
        }

        @Override
        public String getQName(int index) {
            CharSequence chars = this._attributes.getQName(index);
            return chars != null ? chars.toString() : null;
        }

        @Override
        public String getType(int index) {
            return this._attributes.getType(index);
        }

        @Override
        public String getValue(int index) {
            CharSequence chars = this._attributes.getValue(index);
            return chars != null ? chars.toString() : null;
        }

        @Override
        public int getIndex(String uri, String localName) {
            return this._attributes.getIndex(uri, localName);
        }

        @Override
        public int getIndex(String qName) {
            return this._attributes.getIndex(qName);
        }

        @Override
        public String getType(String uri, String localName) {
            return this._attributes.getType(uri, localName);
        }

        @Override
        public String getType(String qName) {
            return this._attributes.getType(qName);
        }

        @Override
        public String getValue(String uri, String localName) {
            return this._attributes.getValue(uri, localName).toString();
        }

        @Override
        public String getValue(String qName) {
            return this._attributes.getValue(qName).toString();
        }
    }
}

