/*
 * Decompiled with CFR 0.152.
 */
package javolution37.javolution.realtime;

import javax.realtime.MemoryArea;
import javolution37.javolution.Configuration;
import javolution37.javolution.JavolutionError;
import javolution37.javolution.lang.ClassInitializer;
import javolution37.javolution.realtime.Context;
import javolution37.javolution.realtime.ObjectPool;
import javolution37.javolution.realtime.PoolContext;

public abstract class ObjectFactory<T> {
    static final int MAX = Configuration.factories();
    static ObjectFactory[] INSTANCES = new ObjectFactory[MAX];
    static volatile int Count;
    final int _index;
    private final HeapPool _heapPool = new HeapPool();

    protected ObjectFactory() {
        this._index = ObjectFactory.add(this);
    }

    private static synchronized int add(ObjectFactory factory) {
        int count = Count;
        if (count >= MAX) {
            throw new UnsupportedOperationException("Maximum number of factories (system property \"javolution37.javolution.factories\", value " + MAX + ") has been reached");
        }
        Class<?> factoryClass = factory.getClass();
        for (int i = 0; i < count; ++i) {
            if (factoryClass != INSTANCES[i].getClass()) continue;
            throw new UnsupportedOperationException(factoryClass + "  cannot have more than one instance");
        }
        ObjectFactory.INSTANCES[count] = factory;
        return Count++;
    }

    protected abstract T create();

    public T object() {
        PoolContext poolContext = Context.poolContext(Thread.currentThread());
        return poolContext == null ? this.create() : poolContext.getLocalPool(this._index).next();
    }

    public final ObjectPool<T> currentPool() {
        PoolContext poolContext = Context.poolContext(Thread.currentThread());
        return poolContext != null ? poolContext.getLocalPool(this._index) : this._heapPool;
    }

    public final ObjectPool<T> heapPool() {
        return this._heapPool;
    }

    protected void cleanup(T obj) {
        throw new UnsupportedOperationException();
    }

    protected ObjectPool<T> newPool() {
        return new LocalPool();
    }

    static ObjectFactory getInstance(Class factoryClass) {
        String className = factoryClass.getName();
        int sep = className.lastIndexOf(36);
        if (sep > 0) {
            ClassInitializer.initialize(className.substring(0, sep));
        }
        ClassInitializer.initialize(factoryClass);
        for (int i = 0; i < Count; ++i) {
            if (!INSTANCES[i].getClass().equals(factoryClass)) continue;
            return INSTANCES[i];
        }
        return null;
    }

    static final class Node {
        Object _object;
        Node _next;

        Node() {
        }
    }

    private final class LocalPool
    extends ObjectPool {
        private final MemoryArea _memoryArea = MemoryArea.getMemoryArea(this);
        private boolean _doCleanup = true;
        private int _size;
        private Node _usedNodes;
        private Node _availNodes;
        private Node _usedNodesTail;
        private Node _node;

        private LocalPool() {
        }

        @Override
        public int size() {
            return this._size;
        }

        public Object next() {
            if (this._availNodes != null) {
                this._node = this._availNodes;
                this._availNodes = this._node._next;
            } else {
                this._memoryArea.executeInArea(new Runnable(){

                    @Override
                    public void run() {
                        LocalPool.this._node = new Node();
                        ((LocalPool)LocalPool.this)._node._object = ObjectFactory.this.create();
                    }
                });
                ++this._size;
            }
            if (this._usedNodes == null) {
                this._usedNodesTail = this._node;
            }
            this._node._next = this._usedNodes;
            this._usedNodes = this._node;
            return this._node._object;
        }

        public void recycle(Object obj) {
            Node node;
            if (this._doCleanup) {
                try {
                    ObjectFactory.this.cleanup(obj);
                }
                catch (UnsupportedOperationException ex) {
                    this._doCleanup = false;
                }
            }
            if (this._usedNodes._object == obj) {
                node = this._usedNodes;
                if (node == this._usedNodesTail) {
                    this._usedNodesTail = null;
                    if (node._next != null) {
                        throw new JavolutionError("Pool Corrupted");
                    }
                }
            } else {
                Node previous = this._usedNodes;
                Node node2 = previous._next;
                while (node2 != null) {
                    if (node2._object == obj) {
                        if (node2 == this._usedNodesTail) {
                            this._usedNodesTail = previous;
                        }
                        previous._next = node2._next;
                        node2._next = this._availNodes;
                        this._availNodes = node2;
                        return;
                    }
                    previous = node2;
                    node2 = node2._next;
                }
                throw new IllegalArgumentException("Object not in the pool");
            }
            this._usedNodes = node._next;
            node._next = this._availNodes;
            this._availNodes = node;
        }

        @Override
        protected void recycleAll() {
            if (this._doCleanup) {
                try {
                    Node node = this._usedNodes;
                    while (node != null) {
                        ObjectFactory.this.cleanup(node._object);
                        node = node._next;
                    }
                }
                catch (UnsupportedOperationException ex) {
                    this._doCleanup = false;
                }
            }
            if (this._usedNodes != null) {
                this._usedNodesTail._next = this._availNodes;
                this._availNodes = this._usedNodes;
                this._usedNodes = null;
                this._usedNodesTail = null;
            }
        }

        @Override
        protected void clearAll() {
            this._availNodes = null;
            this._usedNodes = null;
            this._usedNodesTail = null;
        }
    }

    private final class HeapPool
    extends ObjectPool<T> {
        private HeapPool() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public T next() {
            return ObjectFactory.this.create();
        }

        @Override
        public void recycle(T obj) {
        }

        @Override
        protected void recycleAll() {
        }

        @Override
        protected void clearAll() {
        }
    }
}

