/*
 * Decompiled with CFR 0.152.
 */
package javolution37.javolution.realtime;

import javax.realtime.MemoryArea;
import javax.realtime.RealtimeThread;
import javolution37.javolution.Configuration;
import javolution37.javolution.lang.Reflection;
import javolution37.javolution.realtime.ConcurrentException;
import javolution37.javolution.realtime.ConcurrentThread;
import javolution37.javolution.realtime.Context;
import javolution37.javolution.realtime.LocalReference;
import javolution37.javolution.realtime.PoolContext;

public class ConcurrentContext
extends Context {
    private static final Class CLASS = Reflection.getClass("javolution37.javolution.realtime.ConcurrentContext");
    private static final LocalReference ENABLED = new LocalReference<Boolean>(new Boolean(true));
    private int _activeCount;
    private Throwable _error;
    private ConcurrentThread[] _threads;
    private boolean _isEnabled;
    private static final Boolean TRUE = new Boolean(true);
    private static final Boolean FALSE = new Boolean(false);
    private final Object[] _args1 = new Object[1];
    private final Object[] _args2 = new Object[2];
    private final Object[] _args3 = new Object[3];
    private final Object[] _args4 = new Object[4];
    private final Object[] _args5 = new Object[5];
    private final Object[] _args6 = new Object[6];

    public ConcurrentContext() {
    }

    public ConcurrentContext(ConcurrentThread[] threads) {
        this._threads = threads;
    }

    public final ConcurrentThread[] getConcurrentThreads() {
        if (this._threads != null) {
            return this._threads;
        }
        for (Context ctx = this.getOuter(); ctx != null; ctx = ctx.getOuter()) {
            if (!(ctx instanceof ConcurrentContext)) continue;
            ConcurrentContext that = (ConcurrentContext)ctx;
            if (that._threads == null) continue;
            return that._threads;
        }
        return null;
    }

    @Override
    public void clear() {
        if (this._threads != null) {
            for (int i = 0; i < this._threads.length; ++i) {
                this._threads[i].terminate();
            }
            this._threads = null;
        }
    }

    public static ConcurrentContext current() {
        for (Context ctx = Context.current(); ctx != null; ctx = ctx.getOuter()) {
            if (!(ctx instanceof ConcurrentContext)) continue;
            return (ConcurrentContext)ctx;
        }
        return null;
    }

    public static void enter() {
        Context.enter(CLASS);
    }

    public static void exit() {
        Context.exit(CLASS);
    }

    public static void setEnabled(boolean enabled) {
        ENABLED.set(enabled ? TRUE : FALSE);
    }

    public static boolean isEnabled() {
        return (Boolean)ENABLED.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(Logic logic) {
        ConcurrentContext ctx = ConcurrentContext.current();
        if (ctx._isEnabled) {
            ConcurrentThread[] threads = ctx.getConcurrentThreads();
            MemoryArea area = RealtimeThread.getCurrentMemoryArea();
            for (int i = 0; i < threads.length; ++i) {
                if (!threads[i].execute(logic, ctx, area)) continue;
                ConcurrentContext concurrentContext = ctx;
                synchronized (concurrentContext) {
                    ++ctx._activeCount;
                    return;
                }
            }
        }
        ctx.executeByCurrentThread(logic, Logic.NO_ARG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(Logic logic, Object arg0) {
        ConcurrentContext ctx = ConcurrentContext.current();
        if (ctx._isEnabled) {
            ConcurrentThread[] threads = ctx.getConcurrentThreads();
            MemoryArea area = RealtimeThread.getCurrentMemoryArea();
            for (int i = 0; i < threads.length; ++i) {
                if (!threads[i].execute(logic, arg0, ctx, area)) continue;
                ConcurrentContext concurrentContext = ctx;
                synchronized (concurrentContext) {
                    ++ctx._activeCount;
                    return;
                }
            }
        }
        ctx._args1[0] = arg0;
        ctx.executeByCurrentThread(logic, ctx._args1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(Logic logic, Object arg0, Object arg1) {
        ConcurrentContext ctx = ConcurrentContext.current();
        if (ctx._isEnabled) {
            ConcurrentThread[] threads = ctx.getConcurrentThreads();
            MemoryArea area = RealtimeThread.getCurrentMemoryArea();
            for (int i = 0; i < threads.length; ++i) {
                if (!threads[i].execute(logic, arg0, arg1, ctx, area)) continue;
                ConcurrentContext concurrentContext = ctx;
                synchronized (concurrentContext) {
                    ++ctx._activeCount;
                    return;
                }
            }
        }
        ctx._args2[0] = arg0;
        ctx._args2[1] = arg1;
        ctx.executeByCurrentThread(logic, ctx._args2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(Logic logic, Object arg0, Object arg1, Object arg2) {
        ConcurrentContext ctx = ConcurrentContext.current();
        if (ctx._isEnabled) {
            ConcurrentThread[] threads = ctx.getConcurrentThreads();
            MemoryArea area = RealtimeThread.getCurrentMemoryArea();
            for (int i = 0; i < threads.length; ++i) {
                if (!threads[i].execute(logic, arg0, arg1, arg2, ctx, area)) continue;
                ConcurrentContext concurrentContext = ctx;
                synchronized (concurrentContext) {
                    ++ctx._activeCount;
                    return;
                }
            }
        }
        ctx._args3[0] = arg0;
        ctx._args3[1] = arg1;
        ctx._args3[2] = arg2;
        ctx.executeByCurrentThread(logic, ctx._args3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(Logic logic, Object arg0, Object arg1, Object arg2, Object arg3) {
        ConcurrentContext ctx = ConcurrentContext.current();
        if (ctx._isEnabled) {
            ConcurrentThread[] threads = ctx.getConcurrentThreads();
            MemoryArea area = RealtimeThread.getCurrentMemoryArea();
            for (int i = 0; i < threads.length; ++i) {
                if (!threads[i].execute(logic, arg0, arg1, arg2, arg3, ctx, area)) continue;
                ConcurrentContext concurrentContext = ctx;
                synchronized (concurrentContext) {
                    ++ctx._activeCount;
                    return;
                }
            }
        }
        ctx._args4[0] = arg0;
        ctx._args4[1] = arg1;
        ctx._args4[2] = arg2;
        ctx._args4[3] = arg3;
        ctx.executeByCurrentThread(logic, ctx._args4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(Logic logic, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4) {
        ConcurrentContext ctx = ConcurrentContext.current();
        if (ctx._isEnabled) {
            ConcurrentThread[] threads = ctx.getConcurrentThreads();
            MemoryArea area = RealtimeThread.getCurrentMemoryArea();
            for (int i = 0; i < threads.length; ++i) {
                if (!threads[i].execute(logic, arg0, arg1, arg2, arg3, arg4, ctx, area)) continue;
                ConcurrentContext concurrentContext = ctx;
                synchronized (concurrentContext) {
                    ++ctx._activeCount;
                    return;
                }
            }
        }
        ctx._args5[0] = arg0;
        ctx._args5[1] = arg1;
        ctx._args5[2] = arg2;
        ctx._args5[3] = arg3;
        ctx._args5[4] = arg4;
        ctx.executeByCurrentThread(logic, ctx._args5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(Logic logic, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        ConcurrentContext ctx = ConcurrentContext.current();
        if (ctx._isEnabled) {
            ConcurrentThread[] threads = ctx.getConcurrentThreads();
            MemoryArea area = RealtimeThread.getCurrentMemoryArea();
            for (int i = 0; i < threads.length; ++i) {
                if (!threads[i].execute(logic, arg0, arg1, arg2, arg3, arg4, arg5, ctx, area)) continue;
                ConcurrentContext concurrentContext = ctx;
                synchronized (concurrentContext) {
                    ++ctx._activeCount;
                    return;
                }
            }
        }
        ctx._args6[0] = arg0;
        ctx._args6[1] = arg1;
        ctx._args6[2] = arg2;
        ctx._args6[3] = arg3;
        ctx._args6[4] = arg4;
        ctx._args6[5] = arg5;
        ctx.executeByCurrentThread(logic, ctx._args6);
    }

    @Override
    protected void enterAction() {
        this._error = null;
        this._activeCount = 0;
        this._isEnabled = ConcurrentContext.isEnabled();
        if (this.getConcurrentThreads() == null) {
            MemoryArea contextArea = MemoryArea.getMemoryArea(this);
            contextArea.executeInArea(new Runnable(){

                @Override
                public void run() {
                    ConcurrentContext.access$102(ConcurrentContext.this, new ConcurrentThread[Configuration.concurrency()]);
                    for (int i = 0; i < ConcurrentContext.this._threads.length; ++i) {
                        ((ConcurrentContext)ConcurrentContext.this)._threads[i] = new ConcurrentThread();
                        ConcurrentContext.this._threads[i].start();
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void exitAction() {
        ConcurrentContext concurrentContext = this;
        synchronized (concurrentContext) {
            while (this._activeCount > 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    throw new ConcurrentException(e);
                }
            }
        }
        if (this._error != null) {
            throw new ConcurrentException(this._error);
        }
    }

    synchronized void setError(Throwable error) {
        if (this._error == null) {
            this._error = error;
        }
    }

    synchronized void decreaseActiveCount() {
        --this._activeCount;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeByCurrentThread(Logic logic, Object[] args) {
        PoolContext.enter();
        try {
            logic.run(args);
        }
        catch (Throwable error) {
            try {
                this.setError(error);
            }
            catch (Throwable throwable) {
                PoolContext.exit();
                int i = 0;
                while (i < args.length) {
                    args[i++] = null;
                }
                throw throwable;
            }
            PoolContext.exit();
            int i = 0;
            while (i < args.length) {
                args[i++] = null;
            }
        }
        PoolContext.exit();
        int i = 0;
        while (i < args.length) {
            args[i++] = null;
        }
    }

    static /* synthetic */ ConcurrentThread[] access$102(ConcurrentContext x0, ConcurrentThread[] x1) {
        x0._threads = x1;
        return x1;
    }

    public static abstract class Logic
    implements Runnable {
        private static final Object[] NO_ARG = new Object[0];

        @Override
        public final void run() {
            this.run(NO_ARG);
        }

        public abstract void run(Object[] var1);
    }
}

