/*
 * Decompiled with CFR 0.152.
 */
package javolution37.javolution.lang;

import java.io.IOException;
import javolution37.javolution.lang.MathLib;
import javolution37.javolution.lang.TextFormat;

public final class TypeFormat {
    private static final char[] DIGIT_TO_CHAR;
    private static final int[] CHAR_TO_DIGIT;
    private static final int[] INT_POW_10;
    private static final long[] LONG_POW_10;
    private static final double POSITIVE_INFINITY = Double.POSITIVE_INFINITY;
    private static final double NEGATIVE_INFINITY = Double.NEGATIVE_INFINITY;

    private TypeFormat() {
    }

    public static boolean parseBoolean(CharSequence csq) {
        if (!(csq.length() != 4 || csq.charAt(0) != 't' && csq.charAt(0) != 'T' || csq.charAt(1) != 'r' && csq.charAt(1) != 'R' || csq.charAt(2) != 'u' && csq.charAt(2) != 'U' || csq.charAt(3) != 'e' && csq.charAt(3) != 'E')) {
            return true;
        }
        if (!(csq.length() != 5 || csq.charAt(0) != 'f' && csq.charAt(0) != 'F' || csq.charAt(1) != 'a' && csq.charAt(1) != 'A' || csq.charAt(2) != 'l' && csq.charAt(2) != 'L' || csq.charAt(3) != 's' && csq.charAt(3) != 'S' || csq.charAt(4) != 'e' && csq.charAt(4) != 'E')) {
            return false;
        }
        throw new IllegalArgumentException("Cannot parse " + csq + " as boolean");
    }

    public static boolean parseBoolean(CharSequence csq, TextFormat.Cursor cursor) {
        int i = cursor.getIndex();
        if (!(csq.length() <= i + 4 || csq.charAt(i) != 't' && csq.charAt(i) != 'T' || csq.charAt(i + 1) != 'r' && csq.charAt(i + 1) != 'R' || csq.charAt(i + 2) != 'u' && csq.charAt(i + 2) != 'U' || csq.charAt(i + 3) != 'e' && csq.charAt(i + 3) != 'E')) {
            cursor.increment(4);
            return true;
        }
        if (!(csq.length() <= i + 5 || csq.charAt(i) != 'f' && csq.charAt(i) != 'F' || csq.charAt(i + 1) != 'a' && csq.charAt(i + 1) != 'A' || csq.charAt(i + 2) != 'l' && csq.charAt(i + 2) != 'L' || csq.charAt(i + 3) != 's' && csq.charAt(i + 3) != 'S' || csq.charAt(i + 4) != 'e' && csq.charAt(i + 4) != 'E')) {
            cursor.increment(5);
            return true;
        }
        throw new IllegalArgumentException("Cannot parse boolean at " + cursor.getIndex());
    }

    public static byte parseByte(CharSequence csq) {
        return TypeFormat.parseByte(csq, 10);
    }

    public static byte parseByte(CharSequence csq, int radix) {
        int i = TypeFormat.parseInt(csq, radix);
        if (i < -128 || i > 127) {
            throw new NumberFormatException("Overflow");
        }
        return (byte)i;
    }

    public static byte parseByte(CharSequence csq, int radix, TextFormat.Cursor cursor) {
        int i = TypeFormat.parseInt(csq, radix, cursor);
        if (i < -128 || i > 127) {
            throw new NumberFormatException("Overflow");
        }
        return (byte)i;
    }

    public static short parseShort(CharSequence csq) {
        return TypeFormat.parseShort(csq, 10);
    }

    public static short parseShort(CharSequence csq, int radix) {
        int i = TypeFormat.parseInt(csq, radix);
        if (i < Short.MIN_VALUE || i > Short.MAX_VALUE) {
            throw new NumberFormatException("Overflow");
        }
        return (short)i;
    }

    public static short parseShort(CharSequence csq, int radix, TextFormat.Cursor cursor) {
        int i = TypeFormat.parseInt(csq, radix, cursor);
        if (i < Short.MIN_VALUE || i > Short.MAX_VALUE) {
            throw new NumberFormatException("Overflow");
        }
        return (short)i;
    }

    public static int parseInt(CharSequence csq) {
        return TypeFormat.parseInt(csq, 10);
    }

    public static int parseInt(CharSequence csq, int radix) {
        try {
            int digit;
            int length = csq.length();
            int i = 0;
            boolean isNegative = csq.charAt(i) == '-';
            char c0 = csq.charAt(i += isNegative || csq.charAt(i) == '+' ? 1 : 0);
            int n = digit = c0 < CHAR_TO_DIGIT.length ? CHAR_TO_DIGIT[c0] : -1;
            if (digit < 0 || digit >= radix) {
                throw new NumberFormatException("Digit expected");
            }
            int result = -digit;
            while (++i < length) {
                char c = csq.charAt(i);
                int n2 = digit = c < CHAR_TO_DIGIT.length ? CHAR_TO_DIGIT[c] : -1;
                if (digit < 0 || digit >= radix) break;
                if (result <= -59652323 && result < (Integer.MIN_VALUE + digit) / radix) {
                    throw new NumberFormatException("Overflow");
                }
                result = result * radix - digit;
            }
            if (!isNegative && result == Integer.MIN_VALUE) {
                throw new NumberFormatException("Overflow");
            }
            return isNegative ? result : -result;
        }
        catch (IndexOutOfBoundsException e) {
            throw new NumberFormatException();
        }
    }

    public static int parseInt(CharSequence csq, int radix, TextFormat.Cursor cursor) {
        try {
            int digit;
            int length = csq.length();
            int i = cursor.getIndex();
            boolean isNegative = csq.charAt(i) == '-';
            char c0 = csq.charAt(i += isNegative || csq.charAt(i) == '+' ? 1 : 0);
            int n = digit = c0 < CHAR_TO_DIGIT.length ? CHAR_TO_DIGIT[c0] : -1;
            if (digit < 0 || digit >= radix) {
                throw new NumberFormatException("Digit expected");
            }
            int result = -digit;
            while (++i < length) {
                char c = csq.charAt(i);
                int n2 = digit = c < CHAR_TO_DIGIT.length ? CHAR_TO_DIGIT[c] : -1;
                if (digit < 0 || digit >= radix) break;
                if (result <= -59652323 && result < (Integer.MIN_VALUE + digit) / radix) {
                    throw new NumberFormatException("Overflow");
                }
                result = result * radix - digit;
            }
            if (!isNegative && result == Integer.MIN_VALUE) {
                throw new NumberFormatException("Overflow");
            }
            cursor.setIndex(i);
            return isNegative ? result : -result;
        }
        catch (IndexOutOfBoundsException e) {
            throw new NumberFormatException();
        }
    }

    public static long parseLong(CharSequence csq) {
        return TypeFormat.parseLong(csq, 10);
    }

    public static long parseLong(CharSequence csq, int radix) {
        try {
            int digit;
            int length = csq.length();
            int i = 0;
            boolean isNegative = csq.charAt(i) == '-';
            char c0 = csq.charAt(i += isNegative || csq.charAt(i) == '+' ? 1 : 0);
            int n = digit = c0 < CHAR_TO_DIGIT.length ? CHAR_TO_DIGIT[c0] : -1;
            if (digit < 0 || digit >= radix) {
                throw new NumberFormatException("Digit expected");
            }
            long result = -digit;
            while (++i < length) {
                char c = csq.charAt(i);
                int n2 = digit = c < CHAR_TO_DIGIT.length ? CHAR_TO_DIGIT[c] : -1;
                if (digit < 0 || digit >= radix) break;
                if (result <= -256204778801521550L && result < (Long.MIN_VALUE + (long)digit) / (long)radix) {
                    throw new NumberFormatException("Overflow");
                }
                result = result * (long)radix - (long)digit;
            }
            if (!isNegative && result == Long.MIN_VALUE) {
                throw new NumberFormatException("Overflow");
            }
            return isNegative ? result : -result;
        }
        catch (IndexOutOfBoundsException e) {
            throw new NumberFormatException();
        }
    }

    public static long parseLong(CharSequence csq, int radix, TextFormat.Cursor cursor) {
        try {
            int digit;
            int length = csq.length();
            int i = cursor.getIndex();
            boolean isNegative = csq.charAt(i) == '-';
            char c0 = csq.charAt(i += isNegative || csq.charAt(i) == '+' ? 1 : 0);
            int n = digit = c0 < CHAR_TO_DIGIT.length ? CHAR_TO_DIGIT[c0] : -1;
            if (digit < 0 || digit >= radix) {
                throw new NumberFormatException("Digit expected");
            }
            long result = -digit;
            while (++i < length) {
                char c = csq.charAt(i);
                int n2 = digit = c < CHAR_TO_DIGIT.length ? CHAR_TO_DIGIT[c] : -1;
                if (digit < 0 || digit >= radix) break;
                if (result <= -256204778801521550L && result < (Long.MIN_VALUE + (long)digit) / (long)radix) {
                    throw new NumberFormatException("Overflow");
                }
                result = result * (long)radix - (long)digit;
            }
            if (!isNegative && result == Long.MIN_VALUE) {
                throw new NumberFormatException("Overflow");
            }
            cursor.setIndex(i);
            return isNegative ? result : -result;
        }
        catch (IndexOutOfBoundsException e) {
            throw new NumberFormatException();
        }
    }

    public static float parseFloat(CharSequence csq) {
        double d = TypeFormat.parseDouble(csq);
        if (d >= -3.4028234663852886E38 && d <= 3.4028234663852886E38) {
            return (float)d;
        }
        throw new NumberFormatException("Overflow");
    }

    public static float parseFloat(CharSequence csq, TextFormat.Cursor cursor) {
        double d = TypeFormat.parseDouble(csq, cursor);
        if (d >= -3.4028234663852886E38 && d <= 3.4028234663852886E38) {
            return (float)d;
        }
        throw new NumberFormatException("Overflow");
    }

    public static double parseDouble(CharSequence csq) throws NumberFormatException {
        TextFormat.Cursor cursor = TextFormat.Cursor.newInstance();
        double result = TypeFormat.parseDouble(csq, cursor);
        cursor.recycle();
        return result;
    }

    public static double parseDouble(CharSequence csq, TextFormat.Cursor cursor) throws NumberFormatException {
        try {
            char c;
            char c2;
            int i = cursor.getIndex();
            boolean isNegative = csq.charAt(i) == '-';
            char c0 = csq.charAt(i += isNegative || csq.charAt(i) == '+' ? 1 : 0);
            if (c0 == 'N' && TypeFormat.startWith(csq, i, "NaN")) {
                cursor.setIndex(i + 3);
                return Double.NaN;
            }
            if (c0 == 'I' && TypeFormat.startWith(csq, i, "Infinity")) {
                cursor.setIndex(i + 8);
                return isNegative ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
            cursor.setIndex(i);
            long decimal = TypeFormat.parseLong(csq, 10, cursor);
            int length = csq.length();
            long fraction = 0L;
            int fractionLength = 0;
            if (cursor.getIndex() < length && (c2 = csq.charAt(cursor.getIndex())) == '.') {
                cursor.increment();
                int startFraction = cursor.getIndex();
                fraction = TypeFormat.parseLong(csq, 10, cursor);
                fractionLength = cursor.getIndex() - startFraction;
            }
            int exponent = 0;
            if (cursor.getIndex() < length && ((c = csq.charAt(cursor.getIndex())) == 'e' || c == 'E')) {
                cursor.increment();
                exponent = TypeFormat.parseInt(csq, 10, cursor);
            }
            double decimalAsDouble = MathLib.toDouble(decimal, exponent);
            double fractionAsDouble = MathLib.toDouble(decimal < 0L ? -fraction : fraction, exponent - fractionLength);
            return isNegative ? -decimalAsDouble - fractionAsDouble : decimalAsDouble + fractionAsDouble;
        }
        catch (IndexOutOfBoundsException e) {
            throw new NumberFormatException();
        }
    }

    static boolean startWith(CharSequence csq, int start, String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (start + i < csq.length() && csq.charAt(start + i) == str.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static Appendable format(boolean b, Appendable csq) throws IOException {
        return b ? TypeFormat.append(csq, "true") : TypeFormat.append(csq, "false");
    }

    public static Appendable format(int i, Appendable csq) throws IOException {
        int j;
        if (i <= 0) {
            if (i == Integer.MIN_VALUE) {
                return TypeFormat.append(csq, "-2147483648");
            }
            if (i == 0) {
                return csq.append('0');
            }
            i = -i;
            csq.append('-');
        }
        for (j = 1; j < 10 && i >= INT_POW_10[j]; ++j) {
        }
        --j;
        while (j >= 0) {
            int pow10 = INT_POW_10[j];
            int digit = i / pow10;
            i -= digit * pow10;
            csq.append(DIGIT_TO_CHAR[digit]);
            --j;
        }
        return csq;
    }

    public static Appendable format(int i, int radix, Appendable csq) throws IOException {
        if (radix == 10) {
            return TypeFormat.format(i, csq);
        }
        if (radix < 2 || radix > 36) {
            throw new IllegalArgumentException("radix: " + radix);
        }
        if (i < 0) {
            csq.append('-');
        } else {
            i = -i;
        }
        TypeFormat.format2(i, radix, csq);
        return csq;
    }

    private static void format2(int i, int radix, Appendable csq) throws IOException {
        if (i <= -radix) {
            TypeFormat.format2(i / radix, radix, csq);
            csq.append(DIGIT_TO_CHAR[-(i % radix)]);
        } else {
            csq.append(DIGIT_TO_CHAR[-i]);
        }
    }

    public static Appendable format(long l, Appendable csq) throws IOException {
        int j;
        if (l <= 0L) {
            if (l == Long.MIN_VALUE) {
                return TypeFormat.append(csq, "-9223372036854775808");
            }
            if (l == 0L) {
                return csq.append('0');
            }
            l = -l;
            csq.append('-');
        }
        for (j = 1; j < 19 && l >= LONG_POW_10[j]; ++j) {
        }
        --j;
        while (j >= 0) {
            long pow10 = LONG_POW_10[j];
            int digit = (int)(l / pow10);
            l -= (long)digit * pow10;
            csq.append(DIGIT_TO_CHAR[digit]);
            --j;
        }
        return csq;
    }

    public static Appendable format(long l, int radix, Appendable csq) throws IOException {
        if (radix == 10) {
            return TypeFormat.format(l, csq);
        }
        if (radix < 2 || radix > 36) {
            throw new IllegalArgumentException("radix: " + radix);
        }
        if (l < 0L) {
            csq.append('-');
        } else {
            l = -l;
        }
        TypeFormat.format2(l, radix, csq);
        return csq;
    }

    private static void format2(long l, int radix, Appendable csq) throws IOException {
        if (l <= (long)(-radix)) {
            TypeFormat.format2(l / (long)radix, radix, csq);
            csq.append(DIGIT_TO_CHAR[(int)(-(l % (long)radix))]);
        } else {
            csq.append(DIGIT_TO_CHAR[(int)(-l)]);
        }
    }

    public static Appendable format(float value, Appendable csq) throws IOException {
        return TypeFormat.format(value, 10, (double)MathLib.abs(value) > 1.0E7, false, csq);
    }

    public static Appendable format(double value, Appendable csq) throws IOException {
        return TypeFormat.format(value, 17, MathLib.abs(value) > 1.0E7, false, csq);
    }

    public static Appendable format(double value, int digits, boolean scientific, boolean showZero, Appendable csq) throws IOException {
        if (digits > 19 || digits <= 0) {
            throw new IllegalArgumentException("digits: " + digits);
        }
        if (value != value) {
            return TypeFormat.append(csq, "NaN");
        }
        if (value == Double.POSITIVE_INFINITY) {
            return TypeFormat.append(csq, "Infinity");
        }
        if (value == Double.NEGATIVE_INFINITY) {
            return TypeFormat.append(csq, "-Infinity");
        }
        if (value == 0.0) {
            if (digits == 1) {
                return TypeFormat.append(csq, "0");
            }
            if (!showZero) {
                return TypeFormat.append(csq, "0.0");
            }
            TypeFormat.append(csq, "0.0");
            for (int i = 2; i < digits; ++i) {
                csq.append('0');
            }
            return csq;
        }
        if (value < 0.0) {
            value = -value;
            csq.append('-');
        }
        int e = value >= 1.0 ? 1 + TypeFormat.minPow10(value) : -TypeFormat.minPow10(1.0 / value);
        double digitValue = value * MathLib.toDouble(1L, digits - e);
        long mantissa = (long)(digitValue + 0.5);
        if (scientific || e <= 0 || e > digits) {
            TypeFormat.format(mantissa / LONG_POW_10[digits - 1], csq);
            TypeFormat.formatFraction(mantissa % LONG_POW_10[digits - 1], digits - 1, showZero, csq);
            csq.append('E');
            TypeFormat.format(e - 1, csq);
        } else if (e == digits) {
            TypeFormat.format(mantissa, csq);
        } else {
            TypeFormat.format(mantissa / LONG_POW_10[digits - e], csq);
            TypeFormat.formatFraction(mantissa % LONG_POW_10[digits - e], digits - e, showZero, csq);
        }
        return csq;
    }

    private static void formatFraction(long fraction, int digits, boolean showZero, Appendable csq) throws IOException {
        if (digits == 0) {
            return;
        }
        csq.append('.');
        int i = digits;
        while (i > 0) {
            long pow10 = LONG_POW_10[--i];
            int digit = (int)(fraction / pow10);
            csq.append(DIGIT_TO_CHAR[digit]);
            if ((fraction -= (long)digit * pow10) != 0L || showZero) continue;
            return;
        }
    }

    private static int minPow10(double value) {
        int minE = 0;
        int maxE = 308;
        while (maxE - minE > 1) {
            int exp = minE + maxE >> 1;
            if (value >= MathLib.toDouble(1L, exp)) {
                minE = exp;
                continue;
            }
            maxE = exp;
        }
        return minE;
    }

    private static Appendable append(Appendable to, String str) throws IOException {
        for (int i = 0; i < str.length(); ++i) {
            to.append(str.charAt(i));
        }
        return to;
    }

    static {
        int i;
        DIGIT_TO_CHAR = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
        CHAR_TO_DIGIT = new int[128];
        for (i = 0; i < CHAR_TO_DIGIT.length; ++i) {
            TypeFormat.CHAR_TO_DIGIT[i] = -1;
        }
        for (i = 0; i < DIGIT_TO_CHAR.length; ++i) {
            TypeFormat.CHAR_TO_DIGIT[TypeFormat.DIGIT_TO_CHAR[i]] = i;
            TypeFormat.CHAR_TO_DIGIT[Character.toUpperCase((char)TypeFormat.DIGIT_TO_CHAR[i])] = i;
        }
        INT_POW_10 = new int[10];
        int pow = 1;
        for (int i2 = 0; i2 < 10; ++i2) {
            TypeFormat.INT_POW_10[i2] = pow;
            pow *= 10;
        }
        LONG_POW_10 = new long[19];
        long pow2 = 1L;
        for (int i3 = 0; i3 < 19; ++i3) {
            TypeFormat.LONG_POW_10[i3] = pow2;
            pow2 *= 10L;
        }
    }
}

