/*
 * Decompiled with CFR 0.152.
 */
package javolution37.javolution.lang;

import java.io.IOException;
import java.io.Serializable;
import javax.realtime.MemoryArea;
import javolution37.javolution.JavolutionError;
import javolution37.javolution.lang.Reusable;
import javolution37.javolution.lang.Text;
import javolution37.javolution.lang.TypeFormat;
import javolution37.javolution.realtime.Realtime;
import javolution37.javolution.realtime.RealtimeObject;

public class TextBuilder
extends RealtimeObject
implements Appendable,
CharSequence,
Reusable,
Serializable {
    private static final RealtimeObject.Factory FACTORY = new RealtimeObject.Factory(){

        @Override
        public Object create() {
            return new TextBuilder();
        }

        @Override
        public void cleanup(Object obj) {
            ((TextBuilder)obj).reset();
        }
    };
    private static final int D0 = 5;
    private static final int M0 = 31;
    private static final int C0 = 32;
    private static final int D1 = 7;
    private static final int R1 = 5;
    private static final int M1 = 127;
    private static final int C1 = 4096;
    private static final int D2 = 9;
    private static final int R2 = 12;
    private static final int M2 = 511;
    private static final int C2 = 0x200000;
    private static final int D3 = 11;
    private static final int R3 = 21;
    private final char[] _chars0 = new char[32];
    private char[][] _chars1;
    private char[][][] _chars2;
    private char[][][][] _chars3;
    private int _capacity = 32;
    private int _length;

    public TextBuilder() {
    }

    public TextBuilder(CharSequence csq) {
        this.append(csq);
    }

    public TextBuilder(int capacity) {
        while (capacity > this._capacity) {
            this.increaseCapacity();
        }
    }

    public static TextBuilder newInstance() {
        return (TextBuilder)FACTORY.object();
    }

    @Override
    public final int length() {
        return this._length;
    }

    @Override
    public final char charAt(int index) {
        if (index < 0 || index >= this._length) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        if (index < 32) {
            return this._chars0[index];
        }
        if (index < 4096) {
            return this._chars1[index >> 5][index & 0x1F];
        }
        if (index < 0x200000) {
            return this._chars2[index >> 12][index >> 5 & 0x7F][index & 0x1F];
        }
        return this._chars3[index >> 21][index >> 12 & 0x1FF][index >> 5 & 0x7F][index & 0x1F];
    }

    public final void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        if (srcBegin < 0 || dstBegin < 0 || srcBegin > srcEnd || srcEnd > this.length() || dstBegin + srcEnd - srcBegin > dst.length) {
            throw new IndexOutOfBoundsException();
        }
        int i = srcBegin;
        int j = dstBegin;
        while (i < srcEnd) {
            dst[j++] = this.charAt(i++);
        }
    }

    public final void setCharAt(int index, char c) {
        if (index < 0 || index >= this._length) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        if (index < 32) {
            this._chars0[index] = c;
        } else if (index < 4096) {
            this._chars1[index >> 5][index & 0x1F] = c;
        } else if (index < 0x200000) {
            this._chars2[index >> 12][index >> 5 & 0x7F][index & 0x1F] = c;
        } else {
            this._chars3[index >> 21][index >> 12 & 0x1FF][index >> 5 & 0x7F][index & 0x1F] = c;
        }
    }

    public final void setLength(int newLength) {
        if (newLength < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (newLength <= this._length) {
            this._length = newLength;
        } else {
            int i = this._length;
            while (i++ < newLength) {
                this.append('\u0000');
            }
        }
    }

    @Override
    public final CharSequence subSequence(int start, int end) {
        if (start < 0 || end < 0 || start > end || end > this._length) {
            throw new IndexOutOfBoundsException();
        }
        return Text.valueOf(this, start, end);
    }

    @Override
    public final TextBuilder append(char c) {
        int i;
        if (this._length >= this._capacity) {
            this.increaseCapacity();
        }
        if ((i = this._length++) < 32) {
            this._chars0[i] = c;
        } else if (i < 4096) {
            this._chars1[i >> 5][i & 0x1F] = c;
        } else if (i < 0x200000) {
            this._chars2[i >> 12][i >> 5 & 0x7F][i & 0x1F] = c;
        } else {
            this._chars3[i >> 21][i >> 12 & 0x1FF][i >> 5 & 0x7F][i & 0x1F] = c;
        }
        return this;
    }

    @Override
    public final TextBuilder append(CharSequence csq) {
        return csq == null ? this.append("null") : this.append(csq, 0, csq.length());
    }

    @Override
    public final TextBuilder append(CharSequence csq, int start, int end) {
        if (csq == null) {
            return this.append("null");
        }
        if (start < 0 || end < 0 || start > end || end > csq.length()) {
            throw new IndexOutOfBoundsException();
        }
        int i = start;
        while (i < end) {
            this.append(csq.charAt(i++));
        }
        return this;
    }

    public final TextBuilder append(Object obj) {
        if (obj instanceof String) {
            return this.append((String)obj);
        }
        if (obj instanceof CharSequence) {
            return this.append((CharSequence)obj);
        }
        if (obj instanceof Realtime) {
            return this.append(((Realtime)obj).toText());
        }
        if (obj != null) {
            return this.append(obj.toString());
        }
        return this.append("null");
    }

    public final TextBuilder append(String str) {
        if (str == null) {
            return this.append("null");
        }
        int length = str.length();
        int i = 0;
        while (i < length) {
            this.append(str.charAt(i++));
        }
        return this;
    }

    public final TextBuilder append(String str, int start, int end) {
        if (str == null) {
            return this.append("null");
        }
        if (start < 0 || end < 0 || start > end || end > str.length()) {
            throw new IndexOutOfBoundsException();
        }
        int i = start;
        while (i < end) {
            this.append(str.charAt(i++));
        }
        return this;
    }

    public TextBuilder append(Text text) {
        if (text == null) {
            return this.append("null");
        }
        int length = text.length();
        int i = 0;
        while (i < length) {
            this.append(text.charAt(i++));
        }
        return this;
    }

    public final TextBuilder append(char[] chars) {
        return this.append(chars, 0, chars.length);
    }

    public final TextBuilder append(char[] chars, int offset, int length) {
        if (offset < 0 || length < 0 || offset + length > chars.length) {
            throw new IndexOutOfBoundsException();
        }
        int end = offset + length;
        int i = offset;
        while (i < end) {
            this.append(chars[i++]);
        }
        return this;
    }

    public final TextBuilder append(boolean b) {
        try {
            TypeFormat.format(b, (Appendable)this);
            return this;
        }
        catch (IOException e) {
            throw new JavolutionError(e);
        }
    }

    public final TextBuilder append(int i) {
        try {
            TypeFormat.format(i, (Appendable)this);
            return this;
        }
        catch (IOException e) {
            throw new JavolutionError(e);
        }
    }

    public final TextBuilder append(int i, int radix) {
        try {
            TypeFormat.format(i, radix, (Appendable)this);
            return this;
        }
        catch (IOException e) {
            throw new JavolutionError(e);
        }
    }

    public final TextBuilder append(long l) {
        try {
            TypeFormat.format(l, (Appendable)this);
            return this;
        }
        catch (IOException e) {
            throw new JavolutionError(e);
        }
    }

    public final TextBuilder append(long l, int radix) {
        try {
            TypeFormat.format(l, radix, (Appendable)this);
            return this;
        }
        catch (IOException e) {
            throw new JavolutionError(e);
        }
    }

    public final TextBuilder append(float f) {
        try {
            TypeFormat.format(f, (Appendable)this);
            return this;
        }
        catch (IOException e) {
            throw new JavolutionError(e);
        }
    }

    public final TextBuilder append(double d) {
        try {
            TypeFormat.format(d, (Appendable)this);
            return this;
        }
        catch (IOException e) {
            throw new JavolutionError(e);
        }
    }

    public final TextBuilder append(double value, int digits, boolean scientific, boolean showZero) {
        try {
            TypeFormat.format(value, digits, scientific, showZero, this);
            return this;
        }
        catch (IOException e) {
            throw new JavolutionError(e);
        }
    }

    public final TextBuilder insert(int index, CharSequence csq) {
        if (index < 0 || index > this._length) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        int shift = csq.length();
        this._length += shift;
        while (this._length >= this._capacity) {
            this.increaseCapacity();
        }
        int i = this._length - shift;
        while (--i >= index) {
            this.setCharAt(i + shift, this.charAt(i));
        }
        i = csq.length();
        while (--i >= 0) {
            this.setCharAt(index + i, csq.charAt(i));
        }
        return this;
    }

    public final TextBuilder delete(int start, int end) {
        if (start < 0 || end < 0 || start > end || end > this.length()) {
            throw new IndexOutOfBoundsException();
        }
        int i = end;
        int j = start;
        while (i < this._length) {
            this.setCharAt(j++, this.charAt(i++));
        }
        this._length -= end - start;
        return this;
    }

    public final TextBuilder reverse() {
        int n = this._length - 1;
        int j = n - 1 >> 1;
        while (j >= 0) {
            char c = this.charAt(j);
            this.setCharAt(j, this.charAt(n - j));
            this.setCharAt(n - j--, c);
        }
        return this;
    }

    @Override
    public final Text toText() {
        return Text.valueOf(this, 0, this.length());
    }

    @Override
    public final void reset() {
        this.setLength(0);
    }

    public final int hashCode() {
        int h = 0;
        int i = 0;
        while (i < this._length) {
            h = 31 * h + this.charAt(i++);
        }
        return h;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TextBuilder)) {
            return false;
        }
        TextBuilder that = (TextBuilder)obj;
        if (this._length != that._length) {
            return false;
        }
        int i = 0;
        while (i < this._length) {
            if (this.charAt(i) == that.charAt(i++)) continue;
            return false;
        }
        return true;
    }

    private void increaseCapacity() {
        MemoryArea.getMemoryArea(this).executeInArea(new Runnable(){

            @Override
            public void run() {
                int c = TextBuilder.this._capacity;
                TextBuilder.this._capacity = TextBuilder.this._capacity + 32;
                if (c < 4096) {
                    if (TextBuilder.this._chars1 == null) {
                        TextBuilder.access$102(TextBuilder.this, new char[128][]);
                    }
                    ((TextBuilder)TextBuilder.this)._chars1[c >> 5] = new char[32];
                } else if (c < 0x200000) {
                    if (TextBuilder.this._chars2 == null) {
                        TextBuilder.access$202(TextBuilder.this, new char[512][][]);
                    }
                    if (TextBuilder.this._chars2[c >> 12] == null) {
                        ((TextBuilder)TextBuilder.this)._chars2[c >> 12] = new char[128][];
                    }
                    ((TextBuilder)TextBuilder.this)._chars2[c >> 12][c >> 5 & 0x7F] = new char[32];
                } else {
                    if (TextBuilder.this._chars3 == null) {
                        TextBuilder.access$302(TextBuilder.this, new char[2048][][][]);
                    }
                    if (TextBuilder.this._chars3[c >> 21] == null) {
                        ((TextBuilder)TextBuilder.this)._chars3[c >> 21] = new char[512][][];
                    }
                    if (TextBuilder.this._chars3[c >> 21][c >> 12 & 0x1FF] == null) {
                        ((TextBuilder)TextBuilder.this)._chars3[c >> 21][c >> 12 & 0x1FF] = new char[128][];
                    }
                    ((TextBuilder)TextBuilder.this)._chars3[c >> 21][c >> 12 & 0x1FF][c >> 5 & 0x7F] = new char[32];
                }
            }
        });
    }

    static /* synthetic */ char[][] access$102(TextBuilder x0, char[][] x1) {
        x0._chars1 = x1;
        return x1;
    }

    static /* synthetic */ char[][][] access$202(TextBuilder x0, char[][][] x1) {
        x0._chars2 = x1;
        return x1;
    }

    static /* synthetic */ char[][][][] access$302(TextBuilder x0, char[][][][] x1) {
        x0._chars3 = x1;
        return x1;
    }
}

