/*
 * Decompiled with CFR 0.152.
 */
package javolution37.javolution;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.RandomAccess;
import java.util.concurrent.ConcurrentHashMap;
import javolution37.javolution.Javolution;
import javolution37.javolution.JavolutionError;
import javolution37.javolution.util.FastCollection;
import javolution37.javolution.util.FastList;
import javolution37.javolution.util.FastMap;
import javolution37.javolution.util.FastSet;
import javolution37.javolution.util.FastTable;

final class Perf_Util
extends Javolution
implements Runnable {
    private static final int MAX_COLLECTION_SIZE = 10000;
    private final Object[] _objects = new Object[10000];

    Perf_Util() {
    }

    @Override
    public void run() throws JavolutionError {
        Perf_Util.println("//////////////////////////////");
        Perf_Util.println("// Package: javolution.util //");
        Perf_Util.println("//////////////////////////////");
        Perf_Util.println("");
        Perf_Util.println("(new)      : The collection is created (using the new keyword), populated, then discarded (throw-away collections).");
        Perf_Util.println("(recycled) : The collection is cleared, populated, then reused (static collections or throw-away collections in PoolContext).");
        Perf_Util.println("");
        for (int i = 0; i < 10000; ++i) {
            this._objects[i] = new Object();
        }
        Perf_Util.println("-- FastTable versus ArrayList -- ");
        Perf_Util.setOutputStream(null);
        this.benchmarkFastTable();
        Perf_Util.setOutputStream(System.out);
        this.benchmarkFastTable();
        Perf_Util.setOutputStream(null);
        this.benchmarkArrayList();
        Perf_Util.setOutputStream(System.out);
        this.benchmarkArrayList();
        Perf_Util.println("-- FastList versus LinkedList -- ");
        Perf_Util.setOutputStream(null);
        this.benchmarkFastList();
        Perf_Util.setOutputStream(System.out);
        this.benchmarkFastList();
        Perf_Util.setOutputStream(null);
        this.benchmarkLinkedList();
        Perf_Util.setOutputStream(System.out);
        this.benchmarkLinkedList();
        Perf_Util.println("");
        Perf_Util.println("-- FastMap versus HashMap  --");
        Perf_Util.setOutputStream(null);
        this.benchmarkFastMap();
        Perf_Util.setOutputStream(System.out);
        this.benchmarkFastMap();
        Perf_Util.setOutputStream(null);
        this.benchmarkHashMap();
        Perf_Util.setOutputStream(System.out);
        this.benchmarkHashMap();
        Perf_Util.setOutputStream(null);
        this.benchmarkLinkedHashMap();
        Perf_Util.setOutputStream(System.out);
        this.benchmarkLinkedHashMap();
        Perf_Util.println("");
        Perf_Util.println("-- FastMap.setShared(true) versus ConcurrentHashMap  --");
        Perf_Util.setOutputStream(null);
        this.benchmarkSharedFastMap();
        Perf_Util.setOutputStream(System.out);
        this.benchmarkSharedFastMap();
        Perf_Util.setOutputStream(null);
        this.benchmarkConcurrentHashMap();
        Perf_Util.setOutputStream(System.out);
        this.benchmarkConcurrentHashMap();
        Perf_Util.println("");
        Perf_Util.println("-- FastSet versus HashSet --");
        Perf_Util.setOutputStream(null);
        this.benchmarkFastSet();
        Perf_Util.setOutputStream(System.out);
        this.benchmarkFastSet();
        Perf_Util.setOutputStream(null);
        this.benchmarkHashSet();
        Perf_Util.setOutputStream(System.out);
        this.benchmarkHashSet();
        Perf_Util.setOutputStream(null);
        this.benchmarkLinkedHashSet();
        Perf_Util.setOutputStream(System.out);
        this.benchmarkLinkedHashSet();
        Perf_Util.println("");
    }

    private void benchmarkFastTable() {
        FastTable<Object> list = new FastTable<Object>();
        Perf_Util.println(list.getClass());
        for (int size = 10; size <= 10000; size *= 10) {
            int i;
            int j;
            int nbrIterations = 1000000 / size;
            Perf_Util.print("    Size: " + size);
            Perf_Util.print(", add (new): ");
            Perf_Util.startTime();
            for (j = 0; j < nbrIterations; ++j) {
                list = new FastTable();
                i = 0;
                while (i < size) {
                    list.add(this._objects[i++]);
                }
            }
            Perf_Util.print(Perf_Util.endTime(nbrIterations * size));
            Perf_Util.print(", add (recycled): ");
            Perf_Util.startTime();
            for (j = 0; j < nbrIterations; ++j) {
                list.clear();
                i = 0;
                while (i < size) {
                    list.add(this._objects[i++]);
                }
            }
            Perf_Util.print(Perf_Util.endTime(nbrIterations * size));
            Perf_Util.print(", iteration (iterator): ");
            Perf_Util.startTime();
            for (j = 0; j < nbrIterations * 10; ++j) {
                Iterator i2 = list.iterator();
                while (i2.hasNext()) {
                    if (i2.next() != list) continue;
                    throw new Error();
                }
            }
            Perf_Util.print(Perf_Util.endTime(nbrIterations * size * 10));
            if (list instanceof RandomAccess) {
                Perf_Util.print(", get(int): ");
                Perf_Util.startTime();
                for (j = 0; j < nbrIterations * 10; ++j) {
                    int i3 = list.size();
                    while (--i3 > 0) {
                        if (list.get(i3) != list) continue;
                        throw new Error();
                    }
                }
                Perf_Util.print(Perf_Util.endTime(nbrIterations * size * 10));
            }
            Perf_Util.println("");
        }
        Perf_Util.println("");
    }

    private void benchmarkFastList() {
        FastList<Object> list = new FastList<Object>();
        Perf_Util.println(list.getClass());
        for (int size = 10; size <= 10000; size *= 10) {
            int j;
            int i;
            int j2;
            int nbrIterations = 1000000 / size;
            Perf_Util.print("    Size: " + size);
            Perf_Util.print(", add (new): ");
            Perf_Util.startTime();
            for (j2 = 0; j2 < nbrIterations; ++j2) {
                list = new FastList();
                i = 0;
                while (i < size) {
                    list.add(this._objects[i++]);
                }
            }
            Perf_Util.print(Perf_Util.endTime(nbrIterations * size));
            Perf_Util.print(", add (recycled): ");
            Perf_Util.startTime();
            for (j2 = 0; j2 < nbrIterations; ++j2) {
                list.clear();
                i = 0;
                while (i < size) {
                    list.add(this._objects[i++]);
                }
            }
            Perf_Util.print(Perf_Util.endTime(nbrIterations * size));
            Perf_Util.print(", iteration (iterator): ");
            Perf_Util.startTime();
            for (j2 = 0; j2 < nbrIterations * 10; ++j2) {
                Iterator i2 = list.iterator();
                while (i2.hasNext()) {
                    if (i2.next() != list) continue;
                    throw new Error();
                }
            }
            Perf_Util.print(Perf_Util.endTime(nbrIterations * size * 10));
            Perf_Util.print(", iteration (node): ");
            FastList<Object> fl = list;
            Perf_Util.startTime();
            for (j = 0; j < nbrIterations * 10; ++j) {
                FastCollection.Record n = fl.head();
                FastCollection.Record end = fl.tail();
                while ((n = ((FastList.Node)n).getNext()) != end) {
                    if (((FastList.Node)n).getValue() != list) continue;
                    throw new Error();
                }
            }
            Perf_Util.print(Perf_Util.endTime(nbrIterations * size * 10));
            if (list instanceof RandomAccess) {
                Perf_Util.print(", get(int): ");
                Perf_Util.startTime();
                for (j = 0; j < nbrIterations * 10; ++j) {
                    int i3 = list.size();
                    while (--i3 > 0) {
                        if (list.get(i3) != list) continue;
                        throw new Error();
                    }
                }
                Perf_Util.print(Perf_Util.endTime(nbrIterations * size * 10));
            }
            Perf_Util.println("");
        }
        Perf_Util.println("");
    }

    private void benchmarkArrayList() {
        ArrayList<Object> list = new ArrayList<Object>();
        if (!list.getClass().getName().equals("java.util.ArrayList")) {
            return;
        }
        Perf_Util.println(list.getClass());
        for (int size = 10; size <= 10000; size *= 10) {
            int i;
            int j;
            int nbrIterations = 1000000 / size;
            Perf_Util.print("    Size: " + size);
            Perf_Util.print(", add (new): ");
            Perf_Util.startTime();
            for (j = 0; j < nbrIterations; ++j) {
                list = new ArrayList();
                i = 0;
                while (i < size) {
                    list.add(this._objects[i++]);
                }
            }
            Perf_Util.print(Perf_Util.endTime(nbrIterations * size));
            Perf_Util.print(", add (recycled): ");
            Perf_Util.startTime();
            for (j = 0; j < nbrIterations; ++j) {
                list.clear();
                i = 0;
                while (i < size) {
                    list.add(this._objects[i++]);
                }
            }
            Perf_Util.print(Perf_Util.endTime(nbrIterations * size));
            Perf_Util.print(", iteration (iterator): ");
            Perf_Util.startTime();
            for (j = 0; j < nbrIterations * 10; ++j) {
                Iterator i2 = list.iterator();
                while (i2.hasNext()) {
                    if (i2.next() != list) continue;
                    throw new Error();
                }
            }
            Perf_Util.print(Perf_Util.endTime(nbrIterations * size * 10));
            if (list instanceof RandomAccess) {
                Perf_Util.print(", get(int): ");
                Perf_Util.startTime();
                for (j = 0; j < nbrIterations * 10; ++j) {
                    int i3 = list.size();
                    while (--i3 > 0) {
                        if (list.get(i3) != list) continue;
                        throw new Error();
                    }
                }
                Perf_Util.print(Perf_Util.endTime(nbrIterations * size * 10));
            }
            Perf_Util.println("");
        }
        Perf_Util.println("");
    }

    private void benchmarkLinkedList() {
        LinkedList<Object> list = new LinkedList<Object>();
        if (!list.getClass().getName().equals("java.util.LinkedList")) {
            return;
        }
        Perf_Util.println(list.getClass());
        for (int size = 10; size <= 10000; size *= 10) {
            int i;
            int j;
            int nbrIterations = 1000000 / size;
            Perf_Util.print("    Size: " + size);
            Perf_Util.print(", add (new): ");
            Perf_Util.startTime();
            for (j = 0; j < nbrIterations; ++j) {
                list = new LinkedList();
                i = 0;
                while (i < size) {
                    list.add(this._objects[i++]);
                }
            }
            Perf_Util.print(Perf_Util.endTime(nbrIterations * size));
            Perf_Util.print(", add (recycled): ");
            Perf_Util.startTime();
            for (j = 0; j < nbrIterations; ++j) {
                list.clear();
                i = 0;
                while (i < size) {
                    list.add(this._objects[i++]);
                }
            }
            Perf_Util.print(Perf_Util.endTime(nbrIterations * size));
            Perf_Util.print(", iteration (iterator): ");
            Perf_Util.startTime();
            for (j = 0; j < nbrIterations * 10; ++j) {
                Iterator i2 = list.iterator();
                while (i2.hasNext()) {
                    if (i2.next() != list) continue;
                    throw new Error();
                }
            }
            Perf_Util.print(Perf_Util.endTime(nbrIterations * size * 10));
            if (list instanceof RandomAccess) {
                Perf_Util.print(", get(int): ");
                Perf_Util.startTime();
                for (j = 0; j < nbrIterations * 10; ++j) {
                    int i3 = list.size();
                    while (--i3 > 0) {
                        if (list.get(i3) != list) continue;
                        throw new Error();
                    }
                }
                Perf_Util.print(Perf_Util.endTime(nbrIterations * size * 10));
            }
            Perf_Util.println("");
        }
        Perf_Util.println("");
    }

    private void benchmarkFastMap() {
        FastMap<Object, String> map = new FastMap<Object, String>();
        Perf_Util.println(map.getClass());
        for (int size = 10; size <= 10000; size *= 10) {
            int i;
            int j;
            int nbrIterations = 1000000 / size;
            Perf_Util.print("    Size: " + size);
            Perf_Util.print(", put (new): ");
            Perf_Util.startTime();
            for (j = 0; j < nbrIterations; ++j) {
                map = new FastMap();
                i = 0;
                while (i < size) {
                    map.put(this._objects[i++], "");
                }
            }
            Perf_Util.print(Perf_Util.endTime(nbrIterations * size));
            Perf_Util.print(", put (recycled): ");
            Perf_Util.startTime();
            for (j = 0; j < nbrIterations; ++j) {
                map.clear();
                i = 0;
                while (i < size) {
                    map.put(this._objects[i++], "");
                }
            }
            Perf_Util.print(Perf_Util.endTime(nbrIterations * size));
            Perf_Util.print(", get: ");
            Perf_Util.startTime();
            for (j = 0; j < nbrIterations; ++j) {
                i = 0;
                while (i < size) {
                    if (map.get(this._objects[i++]) == "") continue;
                    throw new Error();
                }
            }
            Perf_Util.print(Perf_Util.endTime(nbrIterations * size));
            Perf_Util.print(", iteration (iterator): ");
            Perf_Util.startTime();
            for (j = 0; j < nbrIterations * 10; ++j) {
                Iterator i2 = map.entrySet().iterator();
                while (i2.hasNext()) {
                    if (i2.next() != map) continue;
                    throw new Error();
                }
            }
            Perf_Util.print(Perf_Util.endTime(nbrIterations * size * 10));
            Perf_Util.print(", iteration (entry): ");
            Perf_Util.startTime();
            for (j = 0; j < nbrIterations * 10; ++j) {
                FastCollection.Record e = map.head();
                FastMap.Entry end = map.tail();
                while ((e = ((FastMap.Entry)e).getNext()) != end) {
                    if (((FastMap.Entry)e).getValue() != map) continue;
                    throw new Error();
                }
            }
            Perf_Util.print(Perf_Util.endTime(nbrIterations * size * 10));
            Perf_Util.println("");
        }
        Perf_Util.println("");
    }

    private void benchmarkHashMap() {
        HashMap<Object, String> map = new HashMap<Object, String>();
        if (!map.getClass().getName().equals("java.util.HashMap")) {
            return;
        }
        Perf_Util.println(map.getClass());
        for (int size = 10; size <= 10000; size *= 10) {
            int i;
            int j;
            int nbrIterations = 1000000 / size;
            Perf_Util.print("    Size: " + size);
            Perf_Util.print(", put (new): ");
            Perf_Util.startTime();
            for (j = 0; j < nbrIterations; ++j) {
                map = new HashMap();
                i = 0;
                while (i < size) {
                    map.put(this._objects[i++], "");
                }
            }
            Perf_Util.print(Perf_Util.endTime(nbrIterations * size));
            Perf_Util.print(", put (recycled): ");
            Perf_Util.startTime();
            for (j = 0; j < nbrIterations; ++j) {
                map.clear();
                i = 0;
                while (i < size) {
                    map.put(this._objects[i++], "");
                }
            }
            Perf_Util.print(Perf_Util.endTime(nbrIterations * size));
            Perf_Util.print(", get: ");
            Perf_Util.startTime();
            for (j = 0; j < nbrIterations; ++j) {
                i = 0;
                while (i < size) {
                    if (map.get(this._objects[i++]) == "") continue;
                    throw new Error();
                }
            }
            Perf_Util.print(Perf_Util.endTime(nbrIterations * size));
            Perf_Util.print(", iteration (iterator): ");
            Perf_Util.startTime();
            for (j = 0; j < nbrIterations * 10; ++j) {
                Iterator i2 = map.entrySet().iterator();
                while (i2.hasNext()) {
                    if (i2.next() != map) continue;
                    throw new Error();
                }
            }
            Perf_Util.print(Perf_Util.endTime(nbrIterations * size * 10));
            Perf_Util.println("");
        }
        Perf_Util.println("");
    }

    private void benchmarkSharedFastMap() {
        FastMap<Object, String> map = new FastMap().setShared(true);
        Perf_Util.println("Shared FastMap");
        for (int size = 10; size <= 10000; size *= 10) {
            int i;
            int j;
            int nbrIterations = 1000000 / size;
            Perf_Util.print("    Size: " + size);
            Perf_Util.print(", put (new): ");
            Perf_Util.startTime();
            for (j = 0; j < nbrIterations; ++j) {
                map = new FastMap().setShared(true);
                i = 0;
                while (i < size) {
                    map.put(this._objects[i++], "");
                }
            }
            Perf_Util.print(Perf_Util.endTime(nbrIterations * size));
            Perf_Util.print(", put (recycled): ");
            Perf_Util.startTime();
            for (j = 0; j < nbrIterations; ++j) {
                map.clear();
                i = 0;
                while (i < size) {
                    map.put(this._objects[i++], "");
                }
            }
            Perf_Util.print(Perf_Util.endTime(nbrIterations * size));
            Perf_Util.print(", get: ");
            Perf_Util.startTime();
            for (j = 0; j < nbrIterations; ++j) {
                i = 0;
                while (i < size) {
                    if (map.get(this._objects[i++]) == "") continue;
                    throw new Error();
                }
            }
            Perf_Util.print(Perf_Util.endTime(nbrIterations * size));
            Perf_Util.print(", iteration (iterator): ");
            Perf_Util.startTime();
            for (j = 0; j < nbrIterations * 10; ++j) {
                Iterator i2 = map.entrySet().iterator();
                while (i2.hasNext()) {
                    if (i2.next() != map) continue;
                    throw new Error();
                }
            }
            Perf_Util.print(Perf_Util.endTime(nbrIterations * size * 10));
            Perf_Util.print(", iteration (entry): ");
            Perf_Util.startTime();
            for (j = 0; j < nbrIterations * 10; ++j) {
                FastCollection.Record e = map.head();
                FastMap.Entry end = map.tail();
                while ((e = ((FastMap.Entry)e).getNext()) != end) {
                    if (((FastMap.Entry)e).getValue() != map) continue;
                    throw new Error();
                }
            }
            Perf_Util.print(Perf_Util.endTime(nbrIterations * size * 10));
            Perf_Util.println("");
        }
        Perf_Util.println("");
    }

    private void benchmarkConcurrentHashMap() {
        ConcurrentHashMap<Object, String> map = new ConcurrentHashMap<Object, String>();
        if (!map.getClass().getName().equals("java.util.concurrent.ConcurrentHashMap")) {
            return;
        }
        Perf_Util.println(map.getClass());
        for (int size = 10; size <= 10000; size *= 10) {
            int i;
            int j;
            int nbrIterations = 1000000 / size;
            Perf_Util.print("    Size: " + size);
            Perf_Util.print(", put (new): ");
            Perf_Util.startTime();
            for (j = 0; j < nbrIterations; ++j) {
                map = new ConcurrentHashMap();
                i = 0;
                while (i < size) {
                    map.put(this._objects[i++], "");
                }
            }
            Perf_Util.print(Perf_Util.endTime(nbrIterations * size));
            Perf_Util.print(", put (recycled): ");
            Perf_Util.startTime();
            for (j = 0; j < nbrIterations; ++j) {
                map.clear();
                i = 0;
                while (i < size) {
                    map.put(this._objects[i++], "");
                }
            }
            Perf_Util.print(Perf_Util.endTime(nbrIterations * size));
            Perf_Util.print(", get: ");
            Perf_Util.startTime();
            for (j = 0; j < nbrIterations; ++j) {
                i = 0;
                while (i < size) {
                    if (map.get(this._objects[i++]) == "") continue;
                    throw new Error();
                }
            }
            Perf_Util.print(Perf_Util.endTime(nbrIterations * size));
            Perf_Util.print(", iteration (iterator): ");
            Perf_Util.startTime();
            for (j = 0; j < nbrIterations * 10; ++j) {
                Iterator i2 = map.entrySet().iterator();
                while (i2.hasNext()) {
                    if (i2.next() != map) continue;
                    throw new Error();
                }
            }
            Perf_Util.print(Perf_Util.endTime(nbrIterations * size * 10));
            Perf_Util.println("");
        }
        Perf_Util.println("");
    }

    private void benchmarkLinkedHashMap() {
        LinkedHashMap<Object, String> map = new LinkedHashMap<Object, String>();
        if (!map.getClass().getName().equals("java.util.LinkedHashMap")) {
            return;
        }
        Perf_Util.println(map.getClass());
        for (int size = 10; size <= 10000; size *= 10) {
            int i;
            int j;
            int nbrIterations = 1000000 / size;
            Perf_Util.print("    Size: " + size);
            Perf_Util.print(", put (new): ");
            Perf_Util.startTime();
            for (j = 0; j < nbrIterations; ++j) {
                map = new LinkedHashMap();
                i = 0;
                while (i < size) {
                    map.put(this._objects[i++], "");
                }
            }
            Perf_Util.print(Perf_Util.endTime(nbrIterations * size));
            Perf_Util.print(", put (recycled): ");
            Perf_Util.startTime();
            for (j = 0; j < nbrIterations; ++j) {
                map.clear();
                i = 0;
                while (i < size) {
                    map.put(this._objects[i++], "");
                }
            }
            Perf_Util.print(Perf_Util.endTime(nbrIterations * size));
            Perf_Util.print(", get: ");
            Perf_Util.startTime();
            for (j = 0; j < nbrIterations; ++j) {
                i = 0;
                while (i < size) {
                    if (map.get(this._objects[i++]) == "") continue;
                    throw new Error();
                }
            }
            Perf_Util.print(Perf_Util.endTime(nbrIterations * size));
            Perf_Util.print(", iteration (iterator): ");
            Perf_Util.startTime();
            for (j = 0; j < nbrIterations * 10; ++j) {
                Iterator i2 = map.entrySet().iterator();
                while (i2.hasNext()) {
                    if (i2.next() != map) continue;
                    throw new Error();
                }
            }
            Perf_Util.print(Perf_Util.endTime(nbrIterations * size * 10));
            Perf_Util.println("");
        }
        Perf_Util.println("");
    }

    private void benchmarkFastSet() {
        FastSet<Object> set = new FastSet<Object>();
        Perf_Util.println(set.getClass());
        for (int size = 10; size <= 10000; size *= 10) {
            int i;
            int j;
            int nbrIterations = 1000000 / size;
            Perf_Util.print("    Size: " + size);
            Perf_Util.print(", add (new): ");
            Perf_Util.startTime();
            for (j = 0; j < nbrIterations; ++j) {
                set = new FastSet();
                i = 0;
                while (i < size) {
                    set.add(this._objects[i++]);
                }
            }
            Perf_Util.print(Perf_Util.endTime(nbrIterations * size));
            Perf_Util.print(", add (recycled): ");
            Perf_Util.startTime();
            for (j = 0; j < nbrIterations; ++j) {
                set.clear();
                i = 0;
                while (i < size) {
                    set.add(this._objects[i++]);
                }
            }
            Perf_Util.print(Perf_Util.endTime(nbrIterations * size));
            Perf_Util.print(", contain: ");
            Perf_Util.startTime();
            for (j = 0; j < nbrIterations; ++j) {
                i = 0;
                while (i < size) {
                    if (set.contains(this._objects[i++])) continue;
                    throw new Error();
                }
            }
            Perf_Util.print(Perf_Util.endTime(nbrIterations * size));
            Perf_Util.print(", iteration (iterator): ");
            Perf_Util.startTime();
            for (j = 0; j < nbrIterations * 10; ++j) {
                Iterator i2 = set.iterator();
                while (i2.hasNext()) {
                    if (i2.next() != set) continue;
                    throw new Error();
                }
            }
            Perf_Util.print(Perf_Util.endTime(nbrIterations * size * 10));
            Perf_Util.print(", iteration (record): ");
            Perf_Util.startTime();
            for (j = 0; j < nbrIterations * 10; ++j) {
                FastCollection.Record r = set.head();
                FastCollection.Record end = set.tail();
                while ((r = r.getNext()) != end) {
                    if (set.valueOf(r) != set) continue;
                    throw new Error();
                }
            }
            Perf_Util.print(Perf_Util.endTime(nbrIterations * size * 10));
            Perf_Util.println("");
        }
        Perf_Util.println("");
    }

    private void benchmarkHashSet() {
        HashSet<Object> set = new HashSet<Object>();
        if (!set.getClass().getName().equals("java.util.HashSet")) {
            return;
        }
        Perf_Util.println(set.getClass());
        for (int size = 10; size <= 10000; size *= 10) {
            int i;
            int j;
            int nbrIterations = 1000000 / size;
            Perf_Util.print("    Size: " + size);
            Perf_Util.print(", add (new): ");
            Perf_Util.startTime();
            for (j = 0; j < nbrIterations; ++j) {
                set = new HashSet();
                i = 0;
                while (i < size) {
                    set.add(this._objects[i++]);
                }
            }
            Perf_Util.print(Perf_Util.endTime(nbrIterations * size));
            Perf_Util.print(", add (recycled): ");
            Perf_Util.startTime();
            for (j = 0; j < nbrIterations; ++j) {
                set.clear();
                i = 0;
                while (i < size) {
                    set.add(this._objects[i++]);
                }
            }
            Perf_Util.print(Perf_Util.endTime(nbrIterations * size));
            Perf_Util.print(", contain: ");
            Perf_Util.startTime();
            for (j = 0; j < nbrIterations; ++j) {
                i = 0;
                while (i < size) {
                    if (set.contains(this._objects[i++])) continue;
                    throw new Error();
                }
            }
            Perf_Util.print(Perf_Util.endTime(nbrIterations * size));
            Perf_Util.print(", iteration (iterator): ");
            Perf_Util.startTime();
            for (j = 0; j < nbrIterations * 10; ++j) {
                Iterator i2 = set.iterator();
                while (i2.hasNext()) {
                    if (i2.next() != set) continue;
                    throw new Error();
                }
            }
            Perf_Util.print(Perf_Util.endTime(nbrIterations * size * 10));
            Perf_Util.println("");
        }
        Perf_Util.println("");
    }

    private void benchmarkLinkedHashSet() {
        LinkedHashSet<Object> set = new LinkedHashSet<Object>();
        if (!set.getClass().getName().equals("java.util.LinkedHashSet")) {
            return;
        }
        Perf_Util.println(set.getClass());
        for (int size = 10; size <= 10000; size *= 10) {
            int i;
            int j;
            int nbrIterations = 1000000 / size;
            Perf_Util.print("    Size: " + size);
            Perf_Util.print(", add (new): ");
            Perf_Util.startTime();
            for (j = 0; j < nbrIterations; ++j) {
                set = new LinkedHashSet();
                i = 0;
                while (i < size) {
                    set.add(this._objects[i++]);
                }
            }
            Perf_Util.print(Perf_Util.endTime(nbrIterations * size));
            Perf_Util.print(", add (recycled): ");
            Perf_Util.startTime();
            for (j = 0; j < nbrIterations; ++j) {
                set.clear();
                i = 0;
                while (i < size) {
                    set.add(this._objects[i++]);
                }
            }
            Perf_Util.print(Perf_Util.endTime(nbrIterations * size));
            Perf_Util.print(", contain: ");
            Perf_Util.startTime();
            for (j = 0; j < nbrIterations; ++j) {
                i = 0;
                while (i < size) {
                    if (set.contains(this._objects[i++])) continue;
                    throw new Error();
                }
            }
            Perf_Util.print(Perf_Util.endTime(nbrIterations * size));
            Perf_Util.print(", iteration (iterator): ");
            Perf_Util.startTime();
            for (j = 0; j < nbrIterations * 10; ++j) {
                Iterator i2 = set.iterator();
                while (i2.hasNext()) {
                    if (i2.next() != set) continue;
                    throw new Error();
                }
            }
            Perf_Util.print(Perf_Util.endTime(nbrIterations * size * 10));
            Perf_Util.println("");
        }
        Perf_Util.println("");
    }
}

