/*
 * Decompiled with CFR 0.152.
 */
package javolution37.javolution;

import javolution37.javolution.Javolution;
import javolution37.javolution.realtime.ObjectFactory;
import javolution37.javolution.realtime.PoolContext;
import javolution37.javolution.realtime.RealtimeObject;

final class Perf_Realtime
extends Javolution
implements Runnable {
    volatile Object[] _objects = new Object[1000];
    private static final ObjectFactory CHAR128_FACTORY = new ObjectFactory(){

        public Object create() {
            return new char[128];
        }
    };
    private static final ObjectFactory CHAR256_FACTORY = new ObjectFactory(){

        public Object create() {
            return new char[256];
        }
    };

    Perf_Realtime() {
    }

    @Override
    public void run() {
        int j;
        int i;
        Perf_Realtime.println("//////////////////////////////////");
        Perf_Realtime.println("// Package: javolution.realtime //");
        Perf_Realtime.println("//////////////////////////////////");
        Perf_Realtime.println("");
        Perf_Realtime.println("-- Heap versus Stack Allocation (Pool-Context) --");
        Perf_Realtime.print("Small standard object heap creation: ");
        Perf_Realtime.startTime();
        for (i = 0; i < 10000; ++i) {
            j = 0;
            while (j < this._objects.length) {
                this._objects[j++] = new SmallObjectStandard();
            }
        }
        Perf_Realtime.println(Perf_Realtime.endTime(10000 * this._objects.length));
        Perf_Realtime.print("Small real-time object stack creation: ");
        Perf_Realtime.startTime();
        for (i = 0; i < 10000; ++i) {
            PoolContext.enter();
            j = 0;
            while (j < this._objects.length) {
                this._objects[j++] = SmallObjectRealtime.FACTORY.object();
            }
            PoolContext.exit();
        }
        Perf_Realtime.println(Perf_Realtime.endTime(10000 * this._objects.length));
        Perf_Realtime.print("char[128] heap creation: ");
        Perf_Realtime.startTime();
        for (i = 0; i < 1000; ++i) {
            j = 0;
            while (j < this._objects.length) {
                this._objects[j++] = new char[128];
            }
        }
        Perf_Realtime.println(Perf_Realtime.endTime(1000 * this._objects.length));
        Perf_Realtime.print("char[128] stack creation: ");
        Perf_Realtime.startTime();
        for (i = 0; i < 1000; ++i) {
            PoolContext.enter();
            j = 0;
            while (j < this._objects.length) {
                this._objects[j++] = CHAR128_FACTORY.object();
            }
            PoolContext.exit();
        }
        Perf_Realtime.println(Perf_Realtime.endTime(1000 * this._objects.length));
        Perf_Realtime.print("char[256] heap creation: ");
        Perf_Realtime.startTime();
        for (i = 0; i < 1000; ++i) {
            j = 0;
            while (j < this._objects.length) {
                this._objects[j++] = new char[256];
            }
        }
        Perf_Realtime.println(Perf_Realtime.endTime(1000 * this._objects.length));
        Perf_Realtime.print("char[256] stack creation: ");
        Perf_Realtime.startTime();
        for (i = 0; i < 1000; ++i) {
            PoolContext.enter();
            j = 0;
            while (j < this._objects.length) {
                this._objects[j++] = CHAR256_FACTORY.object();
            }
            PoolContext.exit();
        }
        Perf_Realtime.println(Perf_Realtime.endTime(1000 * this._objects.length));
        Perf_Realtime.println("");
    }

    private static final class SmallObjectRealtime
    extends RealtimeObject {
        long longValue;
        int intValue;
        SmallObjectRealtime refValue;
        static final RealtimeObject.Factory FACTORY = new RealtimeObject.Factory(){

            @Override
            public Object create() {
                return new SmallObjectRealtime();
            }
        };

        private SmallObjectRealtime() {
        }
    }

    private static final class SmallObjectStandard {
        long longValue;
        int intValue;
        SmallObjectStandard refValue;

        private SmallObjectStandard() {
        }
    }
}

