/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.ts;

import com.jstatcom.component.StdMessages;
import com.jstatcom.component.TopFrameReference;
import com.jstatcom.ts.TS;
import com.jstatcom.ts.TSHolder;
import com.jstatcom.ts.TSList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.BevelBorder;
import org.apache.log4j.Logger;

public class TSTransDialog
extends JDialog {
    private static final Logger log = Logger.getLogger(TSTransDialog.class);
    private JPanel ivjJDialogContentPane = null;
    private JPanel ivjJPanel2 = null;
    private TSList tSList;
    private JButton ivjCancel = null;
    private JButton ivjOK = null;
    IvjEventHandler ivjEventHandler = new IvjEventHandler();
    private JPanel ivjJPanel1 = null;
    private JRadioButton ivjDiff1Check = null;
    private JRadioButton ivjDiff2Check = null;
    private JRadioButton ivjDiffSeasCheck = null;
    private JRadioButton ivjLevelCheck = null;
    private JCheckBox ivjLogCheck = null;

    public TSTransDialog() {
        this.initialize();
    }

    public TSTransDialog(Frame owner, boolean modal) {
        super(owner, modal);
        this.initialize();
    }

    private void cancel_ActionEvents() {
        this.setVisible(false);
    }

    private void connEtoC1() {
        try {
            this.oK_ActionEvents();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC2() {
        try {
            this.cancel_ActionEvents();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private JButton getCancel() {
        if (this.ivjCancel == null) {
            try {
                this.ivjCancel = new JButton();
                this.ivjCancel.setName("Cancel");
                this.ivjCancel.setPreferredSize(new Dimension(100, 27));
                this.ivjCancel.setText("Cancel");
                this.ivjCancel.setMinimumSize(new Dimension(80, 27));
                this.ivjCancel.setMaximumSize(new Dimension(80, 27));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjCancel;
    }

    private JRadioButton getDiff1Check() {
        if (this.ivjDiff1Check == null) {
            try {
                this.ivjDiff1Check = new JRadioButton();
                this.ivjDiff1Check.setName("Diff1Check");
                this.ivjDiff1Check.setText("1st differences Y(t) - Y(t-1)");
                this.ivjDiff1Check.setBounds(20, 75, 273, 25);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjDiff1Check;
    }

    private JRadioButton getDiff2Check() {
        if (this.ivjDiff2Check == null) {
            try {
                this.ivjDiff2Check = new JRadioButton();
                this.ivjDiff2Check.setName("Diff2Check");
                this.ivjDiff2Check.setText("2nd differences [Y(t)-Y(t-1)] - [Y(t-1)-Y(t-2)]");
                this.ivjDiff2Check.setBounds(20, 105, 271, 25);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjDiff2Check;
    }

    private JRadioButton getDiffSeasCheck() {
        if (this.ivjDiffSeasCheck == null) {
            try {
                this.ivjDiffSeasCheck = new JRadioButton();
                this.ivjDiffSeasCheck.setName("DiffSeasCheck");
                this.ivjDiffSeasCheck.setText("Seasonal differences Y(t) - Y(t-freq)");
                this.ivjDiffSeasCheck.setSize(278, 25);
                this.ivjDiffSeasCheck.setLocation(20, 135);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjDiffSeasCheck;
    }

    private JPanel getJDialogContentPane() {
        if (this.ivjJDialogContentPane == null) {
            try {
                this.ivjJDialogContentPane = new JPanel();
                this.ivjJDialogContentPane.setName("JDialogContentPane");
                this.ivjJDialogContentPane.setLayout(new BorderLayout());
                this.getJDialogContentPane().add((Component)this.getJPanel2(), "Center");
                this.getJDialogContentPane().add((Component)this.getJPanel1(), "South");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJDialogContentPane;
    }

    private JPanel getJPanel1() {
        if (this.ivjJPanel1 == null) {
            try {
                this.ivjJPanel1 = new JPanel();
                this.ivjJPanel1.setName("JPanel1");
                this.ivjJPanel1.setPreferredSize(new Dimension(210, 50));
                this.ivjJPanel1.setLayout(this.getJPanel1FlowLayout());
                this.ivjJPanel1.setMaximumSize(new Dimension(210, 50));
                this.ivjJPanel1.setMinimumSize(new Dimension(210, 50));
                this.getJPanel1().add((Component)this.getOK(), this.getOK().getName());
                this.getJPanel1().add((Component)this.getCancel(), this.getCancel().getName());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJPanel1;
    }

    private FlowLayout getJPanel1FlowLayout() {
        FlowLayout ivjJPanel1FlowLayout = null;
        try {
            ivjJPanel1FlowLayout = new FlowLayout();
            ivjJPanel1FlowLayout.setVgap(10);
            ivjJPanel1FlowLayout.setHgap(50);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        return ivjJPanel1FlowLayout;
    }

    private JPanel getJPanel2() {
        if (this.ivjJPanel2 == null) {
            try {
                this.ivjJPanel2 = new JPanel();
                this.ivjJPanel2.setName("JPanel2");
                this.ivjJPanel2.setBorder(new BevelBorder(1));
                this.ivjJPanel2.setLayout(null);
                this.ivjJPanel2.setMaximumSize(new Dimension(210, 180));
                this.ivjJPanel2.setPreferredSize(new Dimension(210, 180));
                this.ivjJPanel2.setMinimumSize(new Dimension(210, 180));
                this.getJPanel2().add((Component)this.getLevelCheck(), this.getLevelCheck().getName());
                this.getJPanel2().add((Component)this.getDiff1Check(), this.getDiff1Check().getName());
                this.getJPanel2().add((Component)this.getDiff2Check(), this.getDiff2Check().getName());
                this.getJPanel2().add((Component)this.getDiffSeasCheck(), this.getDiffSeasCheck().getName());
                this.getJPanel2().add((Component)this.getLogCheck(), this.getLogCheck().getName());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJPanel2;
    }

    private JRadioButton getLevelCheck() {
        if (this.ivjLevelCheck == null) {
            try {
                this.ivjLevelCheck = new JRadioButton();
                this.ivjLevelCheck.setName("LevelCheck");
                this.ivjLevelCheck.setSelected(true);
                this.ivjLevelCheck.setText("Level");
                this.ivjLevelCheck.setBounds(20, 45, 180, 25);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjLevelCheck;
    }

    private JCheckBox getLogCheck() {
        if (this.ivjLogCheck == null) {
            try {
                this.ivjLogCheck = new JCheckBox();
                this.ivjLogCheck.setName("LogCheck");
                this.ivjLogCheck.setText("Logarithm");
                this.ivjLogCheck.setBounds(20, 10, 180, 25);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjLogCheck;
    }

    private JButton getOK() {
        if (this.ivjOK == null) {
            try {
                this.ivjOK = new JButton();
                this.ivjOK.setName("OK");
                this.ivjOK.setPreferredSize(new Dimension(100, 27));
                this.ivjOK.setText("OK");
                this.ivjOK.setMaximumSize(new Dimension(80, 27));
                this.ivjOK.setMinimumSize(new Dimension(80, 27));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjOK;
    }

    private void handleException(Throwable exception) {
        log.error((Object)"Unhandled Exception", exception);
    }

    private void initConnections() throws Exception {
        this.getOK().addActionListener(this.ivjEventHandler);
        this.getCancel().addActionListener(this.ivjEventHandler);
    }

    private void initialize() {
        try {
            this.setName("TimeSeriesTransform");
            this.setDefaultCloseOperation(2);
            this.setResizable(false);
            this.setSize(400, 280);
            this.setTitle("Transform");
            this.setContentPane(this.getJDialogContentPane());
            this.initConnections();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        ButtonGroup selectGroup = new ButtonGroup();
        selectGroup.add(this.getLevelCheck());
        selectGroup.add(this.getDiff1Check());
        selectGroup.add(this.getDiff2Check());
        selectGroup.add(this.getDiffSeasCheck());
    }

    private void oK_ActionEvents() {
        if (!this.getLogCheck().isSelected() && this.getLevelCheck().isSelected()) {
            this.setVisible(false);
            return;
        }
        TS[] selectedTS = this.tSList.getSelectedTS();
        int subPeriodicity = selectedTS[0].start().subPeriodicity();
        if (subPeriodicity == 1 && this.getDiffSeasCheck().isSelected()) {
            StdMessages.errorSpecification("Seasonal differences not possible for annual data.");
            return;
        }
        TS[] transformedTS = new TS[selectedTS.length];
        for (int i = 0; i < selectedTS.length; ++i) {
            TS newTS = null;
            if (this.getLogCheck().isSelected()) {
                newTS = selectedTS[i].createLog();
            }
            if (this.getDiff1Check().isSelected() || this.getDiffSeasCheck().isSelected()) {
                int period = 0;
                if (this.getDiff1Check().isSelected()) {
                    period = 1;
                }
                if (this.getDiffSeasCheck().isSelected()) {
                    period = subPeriodicity;
                }
                newTS = newTS != null ? newTS.createDiff(period) : selectedTS[i].createDiff(period);
            } else if (this.getDiff2Check().isSelected()) {
                newTS = newTS != null ? newTS.createDiff(1).createDiff(1) : selectedTS[i].createDiff(1).createDiff(1);
            }
            transformedTS[i] = newTS;
        }
        for (TS ts : transformedTS) {
            int accept;
            if (ts != null && (accept = TSHolder.getInstance().addTS(ts)) == 2) break;
        }
        this.setVisible(false);
    }

    public void setTSList(TSList newTimeSeriesList) {
        int maxSel = newTimeSeriesList.getSelectedIndices().length;
        String seriesNames = "";
        seriesNames = newTimeSeriesList.getSelectedTS()[0].name();
        for (int i = 1; i < maxSel; ++i) {
            seriesNames = seriesNames + ", " + newTimeSeriesList.getSelectedTS()[i].name();
        }
        this.setTitle("Transform: " + seriesNames);
        this.tSList = newTimeSeriesList;
        this.setLocationRelativeTo(TopFrameReference.getTopFrameRef());
    }

    class IvjEventHandler
    implements ActionListener {
        IvjEventHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == TSTransDialog.this.getOK()) {
                TSTransDialog.this.connEtoC1();
            }
            if (e.getSource() == TSTransDialog.this.getCancel()) {
                TSTransDialog.this.connEtoC2();
            }
        }
    }
}

