/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.ts;

import com.jstatcom.component.TopFrameReference;
import com.jstatcom.ts.TS;
import com.jstatcom.ts.TSDate;
import com.jstatcom.ts.TSTypes;
import com.jstatcom.util.PrintfFormat;
import javax.swing.JOptionPane;

public final class TSDateRange {
    private final TSDate lowerBound;
    private final TSDate upperBound;

    public TSDateRange() {
        this(new TSDate(), 100);
    }

    public TSDateRange(TSDate t1, int numberOfObs) {
        if (numberOfObs <= 0) {
            throw new IllegalArgumentException("Illegal number of observations (" + numberOfObs + " <= 0).");
        }
        this.lowerBound = t1;
        this.upperBound = this.lowerBound.addPeriods(numberOfObs - 1);
    }

    public TSDateRange(TSDate t1, TSDate t2) {
        if (t1.subPeriodicity() != t2.subPeriodicity()) {
            throw new IllegalArgumentException("Sub periodicities do not match (" + t1.subPeriodicity() + " != " + t2.subPeriodicity() + ").");
        }
        if (t1.compareTo(t2) < 0) {
            throw new IllegalArgumentException("Upper bound earlier than lower bound (" + t1 + " >= " + t2 + ").");
        }
        this.lowerBound = t1;
        this.upperBound = t2;
    }

    public TSDateRange addPeriodsToStart(int periods) {
        return new TSDateRange(this.lowerBound.addPeriods(periods), this.upperBound);
    }

    public TSDateRange commonRange(TSDateRange otherRange) {
        if (otherRange == null) {
            throw new IllegalArgumentException("Range argument was null.");
        }
        TSDate otherStart = otherRange.lowerBound();
        TSDate otherEnd = otherRange.upperBound();
        if (otherStart.subPeriodicity() != this.lowerBound.subPeriodicity()) {
            return null;
        }
        if (this.lowerBound.compareTo(otherEnd) < 0 || this.upperBound.compareTo(otherStart) > 0) {
            return null;
        }
        if (this.encloses(otherRange) == null) {
            return otherRange;
        }
        TSDate newStart = this.lowerBound;
        if (this.lowerBound.compareTo(otherStart) > 0) {
            newStart = otherStart;
        }
        TSDate newEnd = this.upperBound;
        if (this.upperBound.compareTo(otherEnd) < 0) {
            newEnd = otherEnd;
        }
        return new TSDateRange(newStart, newEnd);
    }

    public double[][] createSeasDum(boolean centered, boolean all) {
        int periodicity;
        if (centered) {
            all = false;
        }
        if ((periodicity = this.lowerBound.subPeriodicity()) == 1) {
            JOptionPane.showMessageDialog(TopFrameReference.getTopFrameRef(), "Seasonal dummies could not be created for\n" + this + ", because periodicity is 1.", "Info", 1);
            return null;
        }
        int nr = this.numOfObs();
        double[][] dumObs = all ? new double[nr][periodicity] : new double[nr][periodicity - 1];
        double period = periodicity;
        for (int i = 0; i < dumObs[0].length; ++i) {
            int j;
            if (!centered) {
                for (j = 0; j < dumObs.length; ++j) {
                    dumObs[j][i] = this.lowerBound.subPeriodFor(j) == i + 1 ? 1.0 : 0.0;
                }
                continue;
            }
            for (j = 0; j < dumObs.length; ++j) {
                dumObs[j][i] = this.lowerBound.subPeriodFor(j) == i + 1 ? (period - 1.0) / period : -1.0 / period;
            }
        }
        return dumObs;
    }

    public TS[] createSeasDumTS(boolean centered, boolean all) {
        double[][] dums = this.createSeasDum(centered, all);
        if (dums == null) {
            return null;
        }
        TS[] dummyArray = new TS[dums[0].length];
        for (int i = 0; i < dummyArray.length; ++i) {
            double[] dumObs = new double[dums.length];
            for (int j = 0; j < dumObs.length; ++j) {
                dumObs[j] = dums[j][i];
            }
            dummyArray[i] = new TS(dumObs, "S" + (i + 1), this.lowerBound);
        }
        return dummyArray;
    }

    public double[] createShiftDum(TSDateRange shiftRange) {
        String check = this.encloses(shiftRange);
        if (check != null) {
            throw new IllegalArgumentException(check);
        }
        double[] obs = new double[this.numOfObs()];
        int[] indices = this.indicesForRange(shiftRange);
        for (int i = indices[0]; i <= indices[1]; ++i) {
            obs[i] = 1.0;
        }
        return obs;
    }

    public double[] createTrendShiftDum(TSDateRange shiftRange) {
        String check = this.encloses(shiftRange);
        if (check != null) {
            throw new IllegalArgumentException(check);
        }
        double[] obs = new double[this.numOfObs()];
        int[] indices = this.indicesForRange(shiftRange);
        for (int i = indices[0]; i <= indices[1]; ++i) {
            obs[i] = i + 1;
        }
        return obs;
    }

    public TS createTrendShiftDumTS(String name, TSDateRange shiftRange) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Trend shift name cannot be empty.");
        }
        String check = this.encloses(shiftRange);
        if (check != null) {
            throw new IllegalArgumentException(check);
        }
        double[] obs = this.createTrendShiftDum(shiftRange);
        TS dummy = new TS(obs, name, this.lowerBound(), TSTypes.DETERMINISTIC);
        return dummy;
    }

    public TS createShiftDumTS(String name, TSDateRange shiftRange) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Dummy name cannot be empty.");
        }
        String check = this.encloses(shiftRange);
        if (check != null) {
            throw new IllegalArgumentException(check);
        }
        double[] obs = this.createShiftDum(shiftRange);
        TS dummy = new TS(obs, name, this.lowerBound(), TSTypes.DETERMINISTIC);
        return dummy;
    }

    public String encloses(TSDate date) {
        if (date == null) {
            return date + " is invalid date for " + this + ".";
        }
        if (date.subPeriodicity() != this.lowerBound.subPeriodicity()) {
            return date + " is invalid date for " + this + ".";
        }
        if (this.lowerBound.compareTo(date) < 0 || this.upperBound.compareTo(date) > 0) {
            return date + " is not in " + this.toString() + ".";
        }
        return null;
    }

    public String encloses(TSDateRange otherRange) {
        if (otherRange == null) {
            return otherRange + " is invalid range for " + this + ".";
        }
        TSDate otherStart = otherRange.lowerBound();
        TSDate otherEnd = otherRange.upperBound();
        if (otherStart.subPeriodicity() != this.lowerBound.subPeriodicity()) {
            return otherRange + " is invalid range for " + this + ".";
        }
        if (this.lowerBound.compareTo(otherStart) < 0 || this.upperBound.compareTo(otherEnd) > 0) {
            return otherRange + " is not in " + this.toString() + ".";
        }
        return null;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TSDateRange)) {
            return false;
        }
        TSDateRange otherRange = (TSDateRange)o;
        return this.lowerBound.equals(otherRange.lowerBound()) && this.upperBound.equals(otherRange.upperBound());
    }

    public String format(String description, int space) {
        if (space < 0) {
            space = 0;
        }
        return new PrintfFormat("%-" + space + "s%s, T = %i").sprintf(description, this, new Integer(this.numOfObs()));
    }

    public TSDate dateForIndex(int index) {
        return this.lowerBound.addPeriods(index);
    }

    public int indexForDate(TSDate date) {
        if (date == null || date.subPeriodicity() != this.lowerBound.subPeriodicity()) {
            throw new IllegalArgumentException(date + " is invalid date for " + this + ".");
        }
        return this.lowerBound.compareTo(date);
    }

    public int[] indicesForRange(TSDateRange otherRange) {
        int[] indices = new int[2];
        String check = this.encloses(otherRange);
        if (check != null) {
            throw new IllegalArgumentException(check);
        }
        indices[0] = this.indexForDate(otherRange.lowerBound());
        indices[1] = this.indexForDate(otherRange.upperBound());
        return indices;
    }

    public TSDate lowerBound() {
        return this.lowerBound;
    }

    public static TSDateRange getMergedRange(TS[] tsArray) {
        TSDateRange mergedRange = tsArray[0].range();
        for (int i = 1; i < tsArray.length; ++i) {
            mergedRange = mergedRange.mergedRange(tsArray[i].range());
        }
        return mergedRange;
    }

    public int numOfObs() {
        return this.lowerBound.compareTo(this.upperBound) + 1;
    }

    public int subPeriodicity() {
        return this.lowerBound.subPeriodicity();
    }

    public TSDate upperBound() {
        return this.upperBound;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.lowerBound.hashCode();
        result = 37 * result + this.upperBound.hashCode();
        return result;
    }

    public TSDateRange mergedRange(TSDateRange otherRange) {
        if (otherRange == null) {
            throw new IllegalArgumentException("Range argument was null.");
        }
        TSDate otherStart = otherRange.lowerBound();
        TSDate otherEnd = otherRange.upperBound();
        if (otherStart.subPeriodicity() != this.lowerBound.subPeriodicity()) {
            throw new IllegalArgumentException(otherRange + " and " + this + " cannot be merged.");
        }
        TSDate erliestStart = this.lowerBound.compareTo(otherStart) > 0 ? this.lowerBound : otherStart;
        TSDate latestEnd = this.upperBound.compareTo(otherEnd) < 0 ? this.upperBound : otherEnd;
        return new TSDateRange(erliestStart, latestEnd);
    }

    public String[] timeAxisStringArray() {
        return this.lowerBound.timeAxisStringArray(this.numOfObs());
    }

    public String toString() {
        return "[" + this.lowerBound + ", " + this.upperBound + "]";
    }

    public static TSDateRange valueOf(String exp) {
        TSDate t2;
        TSDate t1;
        int kommaIndex;
        String errorMsg = "TSDateRange construction from \"" + exp + "\" failed.";
        if (exp == null) {
            throw new IllegalArgumentException(errorMsg);
        }
        if ((exp = exp.trim()).startsWith("[") && exp.endsWith("]")) {
            exp = exp.substring(1, exp.length() - 1);
        }
        if ((kommaIndex = exp.indexOf(",")) < 1 || kommaIndex > exp.length() - 2) {
            throw new IllegalArgumentException(errorMsg);
        }
        String t1String = exp.substring(0, kommaIndex);
        String t2String = exp.substring(kommaIndex + 1, exp.length());
        try {
            t1 = TSDate.valueOf(t1String);
            t2 = TSDate.valueOf(t2String);
        }
        catch (Throwable ex) {
            throw new IllegalArgumentException(errorMsg + "\n" + ex);
        }
        if (t1.compareTo(t2) < 0) {
            throw new IllegalArgumentException(errorMsg);
        }
        return new TSDateRange(t1, t2);
    }
}

