/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.table;

import com.jstatcom.table.JSCDataTableScrollPane;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.ScrollPaneLayout;
import javax.swing.border.Border;
import javax.swing.table.TableModel;

final class JSCDataTableScrollPaneLayout
extends ScrollPaneLayout {
    private Dimension dimensionForAuxComponents(JSCDataTableScrollPane scrollPane) {
        Border viewportBorder;
        Dimension dim = new Dimension(0, 0);
        Insets insets = scrollPane.getInsets();
        dim.width += insets.left + insets.right;
        dim.height += insets.top + insets.bottom;
        if (scrollPane.getRowHeaderShowing() && scrollPane.getRowHeader() != null) {
            dim.width += scrollPane.getRowHeader().getPreferredSize().width;
        }
        if (scrollPane.getVerticalScrollBarPolicy() != 21 && scrollPane.getVerticalScrollBar() != null) {
            dim.width += scrollPane.getVerticalScrollBar().getWidth();
        }
        if (scrollPane.getColumnHeaderShowing() && scrollPane.getColumnHeader() != null) {
            dim.height += scrollPane.getColumnHeaderDataTable().getPreferredSize().height;
        }
        if (scrollPane.getHorizontalScrollBarPolicy() != 31 && scrollPane.getHorizontalScrollBar() != null) {
            dim.height += scrollPane.getHorizontalScrollBar().getPreferredSize().height;
        }
        if ((viewportBorder = scrollPane.getViewportBorder()) != null) {
            Insets vpbInsets = viewportBorder.getBorderInsets(scrollPane);
            dim.width += vpbInsets.left + vpbInsets.right;
            dim.height += vpbInsets.top + vpbInsets.bottom;
        }
        return dim;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Component c;
            Dimension viewPrefSize;
            JSCDataTableScrollPane scrollPane = (JSCDataTableScrollPane)parent;
            Insets insets = parent.getInsets();
            int colHeaderY = insets.top;
            int rowHeaderX = insets.left;
            int hsbHeight = 0;
            int viewHeight = 0;
            int colHeaderHeight = 0;
            int vsbWidth = 0;
            int viewWidth = 0;
            int rowHeaderWidth = 0;
            if (scrollPane.getVerticalScrollBarPolicy() != 21 && this.getVerticalScrollBar() != null) {
                vsbWidth = this.getVerticalScrollBar().getPreferredSize().width;
            }
            if (scrollPane.getRowHeaderShowing() && this.getRowHeader() != null) {
                rowHeaderWidth = this.getRowHeader().getView() instanceof JComponent ? ((JComponent)this.getRowHeader().getView()).getPreferredSize().width : this.getRowHeader().getViewSize().width;
            }
            if (scrollPane.getHorizontalScrollBarPolicy() != 31 && this.getHorizontalScrollBar() != null) {
                hsbHeight = this.getHorizontalScrollBar().getPreferredSize().height;
            }
            if (scrollPane.getColumnHeaderShowing() && this.getColumnHeader() != null) {
                colHeaderHeight = this.getColumnHeader().getView() instanceof JComponent ? ((JComponent)this.getColumnHeader().getView()).getPreferredSize().height : this.getColumnHeader().getViewSize().height;
            }
            Dimension dim = scrollPane.getSize();
            viewWidth = dim.width - (insets.left + insets.right + vsbWidth + rowHeaderWidth);
            viewHeight = dim.height - (insets.top + insets.bottom + hsbHeight + colHeaderHeight);
            if (scrollPane.dataTable != null) {
                TableModel tableModel = scrollPane.dataTable.getModel();
                int rows = tableModel.getRowCount();
                int cols = tableModel.getColumnCount();
                if (rows > 0 && cols > 0) {
                    rows = Math.max(scrollPane.getMinimumVisibleRows(), Math.min(rows, scrollPane.getMaximumVisibleRows()));
                    cols = Math.max(scrollPane.getMinimumVisibleColumns(), Math.min(cols, scrollPane.getMaximumVisibleColumns()));
                    Rectangle r = scrollPane.dataTable.getCellRect(0, 0, true);
                    viewWidth = Math.min(cols * r.width + 1, viewWidth);
                    viewHeight = Math.min(rows * r.height + 1, viewHeight);
                }
            }
            Component view = this.viewport != null ? this.viewport.getView() : null;
            Dimension dimension = viewPrefSize = view != null ? view.getPreferredSize() : new Dimension(0, 0);
            if (this.viewport != null) {
                this.viewport.setBounds(rowHeaderX + rowHeaderWidth, colHeaderY + colHeaderHeight, viewWidth, viewHeight);
                if (scrollPane.dataTable != null) {
                    scrollPane.dataTable.setPreferredScrollableViewportSize(new Dimension(viewWidth, viewHeight));
                }
            }
            if ((c = this.getRowHeader()) != null) {
                c.setBounds(rowHeaderX, colHeaderY + colHeaderHeight, rowHeaderWidth, viewHeight);
                c.setVisible(scrollPane.getRowHeaderShowing());
            }
            if ((c = this.getColumnHeader()) != null) {
                c.setBounds(rowHeaderX + rowHeaderWidth, colHeaderY, viewWidth, colHeaderHeight);
                c.setVisible(scrollPane.getColumnHeaderShowing());
            }
            if ((c = this.getVerticalScrollBar()) != null) {
                c.setBounds(rowHeaderX + rowHeaderWidth + viewWidth, colHeaderY + colHeaderHeight, vsbWidth, viewHeight);
                c.setVisible(this.getVerticalScrollBarPolicy() == 22 || this.getVerticalScrollBarPolicy() == 20 && viewPrefSize.height > viewHeight);
            }
            if ((c = this.getHorizontalScrollBar()) != null) {
                c.setBounds(rowHeaderX + rowHeaderWidth, colHeaderY + colHeaderHeight + viewHeight, viewWidth, hsbHeight);
                c.setVisible(this.getHorizontalScrollBarPolicy() == 32 || this.getHorizontalScrollBarPolicy() == 30 && viewPrefSize.width > viewWidth);
            }
            if ((c = scrollPane.getCorner("LOWER_LEFT_CORNER")) != null && this.getHorizontalScrollBar() != null && this.getRowHeader() != null) {
                c.setBounds(rowHeaderX, colHeaderY + colHeaderHeight + viewHeight, rowHeaderWidth, hsbHeight);
                c.setVisible(this.getHorizontalScrollBar().isVisible() && this.getRowHeader().isVisible());
            }
            if ((c = scrollPane.getCorner("LOWER_RIGHT_CORNER")) != null && this.getHorizontalScrollBar() != null && this.getVerticalScrollBar() != null) {
                c.setBounds(rowHeaderX + rowHeaderWidth + viewWidth, colHeaderY + colHeaderHeight + viewHeight, vsbWidth, hsbHeight);
                c.setVisible(this.getHorizontalScrollBar().isVisible() && this.getVerticalScrollBar().isVisible());
            }
            if ((c = scrollPane.getCorner("UPPER_LEFT_CORNER")) != null && this.getRowHeader() != null && this.getColumnHeader() != null) {
                c.setBounds(rowHeaderX, colHeaderY, rowHeaderWidth, colHeaderHeight);
                c.setVisible(this.getRowHeader().isVisible() && this.getColumnHeader().isVisible());
            }
            if ((c = scrollPane.getCorner("UPPER_RIGHT_CORNER")) != null && this.getColumnHeader() != null && this.getVerticalScrollBar() != null) {
                c.setBounds(rowHeaderX + rowHeaderWidth + viewWidth, colHeaderY, vsbWidth, colHeaderHeight);
                c.setVisible(this.getColumnHeader().isVisible() && this.getVerticalScrollBar().isVisible());
            }
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            JSCDataTableScrollPane scrollPane = (JSCDataTableScrollPane)parent;
            Dimension dim = this.dimensionForAuxComponents(scrollPane);
            if (scrollPane.dataTable != null) {
                TableModel tableModel = scrollPane.dataTable.getModel();
                int rows = tableModel.getRowCount();
                int cols = tableModel.getColumnCount();
                if (rows > 0 && cols > 0) {
                    rows = Math.max(scrollPane.getMinimumVisibleRows(), Math.min(rows, scrollPane.getMaximumVisibleRows()));
                    cols = Math.max(scrollPane.getMinimumVisibleColumns(), Math.min(cols, scrollPane.getMaximumVisibleColumns()));
                    Rectangle r = scrollPane.dataTable.getCellRect(0, 0, true);
                    dim.width += cols * r.width + 1;
                    dim.height += rows * r.height + 1;
                }
            }
            return dim;
        }
    }

    @Override
    public void syncWithScrollPane(JScrollPane sp) {
        super.syncWithScrollPane(sp);
        this.getVerticalScrollBar().firePropertyChange("JScrollBar.isFreeStanding", false, true);
        this.getHorizontalScrollBar().firePropertyChange("JScrollBar.isFreeStanding", false, true);
    }
}

