/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.table;

import com.jstatcom.model.JSCConstants;
import com.jstatcom.model.JSCSArray;
import com.jstatcom.model.Scope;
import com.jstatcom.model.SymbolTable;
import com.jstatcom.table.JSCAbstractDataTable;
import com.jstatcom.table.JSCCellRendererTypes;
import com.jstatcom.table.JSCDataTableScrollPaneLayout;
import com.jstatcom.table.JSCSArrayTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;

public class JSCDataTableScrollPane
extends JScrollPane {
    private int rowHeaderAlignment = 2;
    private int columnHeaderAlignment = 4;
    private Scope symbolScope = Scope.GLOBAL;
    private int minimumVisibleRows = 1;
    private int maximumVisibleRows = Integer.MAX_VALUE;
    private int minimumVisibleColumns = 1;
    private int maximumVisibleColumns = Integer.MAX_VALUE;
    JSCAbstractDataTable dataTable = null;
    private boolean rowHeaderShowing = false;
    private String rowHeaderSymbolName = null;
    private JSCSArrayTable rowHeaderDataTable = null;
    private TableCellRenderer rowHeaderCellRenderer = null;
    private boolean columnHeaderShowing = false;
    private String columnHeaderSymbolName = null;
    private String[] columnHeaderStringData = null;
    private JSCSArrayTable columnHeaderDataTable = null;
    private TableCellRenderer columnHeaderCellRenderer = null;
    private EventListener eventListener = new EventListener();

    public JSCDataTableScrollPane() {
        super(20, 30);
        JSCDataTableScrollPaneLayout l = new JSCDataTableScrollPaneLayout();
        this.setLayout(l);
        l.syncWithScrollPane(this);
        this.setRowHeaderAlignment(2);
        this.setColumnHeaderAlignment(4);
        JComponent c = this.createDefaultCorner();
        this.setCorner("LOWER_LEFT_CORNER", c);
        c = this.createDefaultCorner();
        this.setCorner("LOWER_RIGHT_CORNER", c);
        c = this.createDefaultCorner();
        this.setCorner("UPPER_LEFT_CORNER", c);
        c = this.createDefaultCorner();
        this.setCorner("UPPER_RIGHT_CORNER", c);
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
    }

    public JSCDataTableScrollPane(JSCAbstractDataTable dataTable) {
        this();
        this.setViewportView(dataTable);
    }

    protected TableCellRenderer createDefaultCellRenderer() {
        JSCCellRendererTypes renderer = new JSCCellRendererTypes("HEADER_RENDERER"){

            @Override
            protected void setStringValue(String value) {
                this.setText(value == null ? "" : value);
            }
        };
        return renderer;
    }

    protected JComponent createDefaultCorner() {
        JLabel comp = new JLabel();
        comp.setBorder(new LineBorder(Color.GRAY, 1));
        return comp;
    }

    public int getColumnHeaderAlignment() {
        return this.columnHeaderAlignment;
    }

    public TableCellRenderer getColumnHeaderCellRenderer() {
        if (this.columnHeaderCellRenderer == null) {
            this.columnHeaderCellRenderer = this.createDefaultCellRenderer();
        }
        return this.columnHeaderCellRenderer;
    }

    public JSCSArray getColumnHeaderData() {
        return this.getColumnHeaderDataTable().getJSCSArray();
    }

    JSCSArrayTable getColumnHeaderDataTable() {
        if (this.columnHeaderDataTable == null) {
            this.columnHeaderDataTable = new JSCSArrayTable();
            this.columnHeaderDataTable.setDisplayTransposed(true);
            this.columnHeaderDataTable.setRowSelectionAllowed(false);
            this.columnHeaderDataTable.setColumnSelectionAllowed(false);
            this.columnHeaderDataTable.setEditable(false);
            this.setColumnHeaderCellRenderer(this.getColumnHeaderCellRenderer());
            this.columnHeaderDataTable.setDynamicColumnWidth(false);
            this.columnHeaderDataTable.setSymbolScope(this.symbolScope);
            this.columnHeaderDataTable.setBackground(Color.lightGray);
            this.columnHeaderDataTable.addPropertyChangeListener(this.eventListener);
        }
        return this.columnHeaderDataTable;
    }

    public String[] getColumnHeaderStringData() {
        return this.columnHeaderStringData;
    }

    public String getColumnHeaderSymbolName() {
        return this.columnHeaderSymbolName;
    }

    public int getMaximumVisibleColumns() {
        return this.maximumVisibleColumns;
    }

    public int getMaximumVisibleRows() {
        return this.maximumVisibleRows;
    }

    public int getMinimumVisibleColumns() {
        return this.minimumVisibleColumns;
    }

    public int getMinimumVisibleRows() {
        return this.minimumVisibleRows;
    }

    public int getRowHeaderAlignment() {
        return this.rowHeaderAlignment;
    }

    public TableCellRenderer getRowHeaderCellRenderer() {
        if (this.rowHeaderCellRenderer == null) {
            this.rowHeaderCellRenderer = this.createDefaultCellRenderer();
        }
        return this.rowHeaderCellRenderer;
    }

    public JSCSArray getRowHeaderData() {
        return this.getRowHeaderDataTable().getJSCSArray();
    }

    private JSCSArrayTable getRowHeaderDataTable() {
        if (this.rowHeaderDataTable == null) {
            this.rowHeaderDataTable = new JSCSArrayTable();
            this.rowHeaderDataTable.setColumnSelectionAllowed(false);
            this.rowHeaderDataTable.setRowSelectionAllowed(false);
            this.rowHeaderDataTable.setDynamicColumnWidth(true);
            this.rowHeaderDataTable.setEditable(false);
            this.setRowHeaderCellRenderer(this.getRowHeaderCellRenderer());
            this.setUpRowHeader();
            this.rowHeaderDataTable.setBackground(Color.lightGray);
        }
        return this.rowHeaderDataTable;
    }

    public String getRowHeaderSymbolName() {
        return this.rowHeaderSymbolName;
    }

    public Scope getSymbolScope() {
        return this.symbolScope;
    }

    public void setColumnHeaderAlignment(int newColumnHeaderAlignment) {
        if (newColumnHeaderAlignment != 2 && newColumnHeaderAlignment != 4 && newColumnHeaderAlignment != 0) {
            throw new IllegalArgumentException("invalid column header policy");
        }
        this.columnHeaderAlignment = newColumnHeaderAlignment;
        if (this.getColumnHeaderCellRenderer() instanceof JSCCellRendererTypes) {
            ((JSCCellRendererTypes)this.getColumnHeaderCellRenderer()).setHorizontalAlignment(this.columnHeaderAlignment);
        }
    }

    public void setColumnHeaderCellRenderer(TableCellRenderer newColumnHeaderCellRenderer) {
        if (!(newColumnHeaderCellRenderer instanceof JComponent)) {
            throw new IllegalArgumentException("CellRenderer must be instance of JComponent");
        }
        this.columnHeaderCellRenderer = newColumnHeaderCellRenderer;
        if (this.dataTable != null && this.columnHeaderCellRenderer != null) {
            JComponent c = (JComponent)((Object)this.columnHeaderCellRenderer);
            Dimension is = this.dataTable.getIntercellSpacing();
            TableCellRenderer tcr = this.dataTable.getCellRenderer();
            int x = 2;
            if (tcr instanceof JComponent) {
                x = ((JComponent)((Object)tcr)).getInsets().right;
            }
            EmptyBorder insideBorder = new EmptyBorder(is.height, is.width - 3, is.height, is.width + x);
            Border outsideBorder = c.getBorder();
            if (outsideBorder != null && outsideBorder instanceof CompoundBorder) {
                outsideBorder = ((CompoundBorder)outsideBorder).getOutsideBorder();
            }
            if (outsideBorder != null) {
                c.setBorder(new CompoundBorder(outsideBorder, insideBorder));
            } else {
                c.setBorder(insideBorder);
            }
            int w = this.dataTable.getColumnWidth();
            this.getColumnHeaderDataTable().setColumnWidth(w);
        }
        this.getColumnHeaderDataTable().setCellRenderer(this.columnHeaderCellRenderer);
    }

    public void setColumnHeaderData(JSCSArray newColumnHeaderData) {
        this.getColumnHeaderDataTable().setJSCData(newColumnHeaderData);
        this.updateColWidthForHeader();
    }

    public void setColumnHeaderShowing(boolean isShowing) {
        this.columnHeaderShowing = isShowing;
        if (isShowing) {
            this.setColumnHeaderView(this.getColumnHeaderDataTable());
        } else {
            this.setColumnHeaderView(null);
        }
        this.revalidate();
    }

    public boolean getColumnHeaderShowing() {
        return this.columnHeaderShowing;
    }

    public void setRowHeaderShowing(boolean isShowing) {
        this.rowHeaderShowing = isShowing;
        if (isShowing) {
            this.setRowHeaderView(this.getRowHeaderDataTable());
        } else {
            this.setRowHeaderView(null);
        }
        this.revalidate();
    }

    public boolean getRowHeaderShowing() {
        return this.rowHeaderShowing;
    }

    public void setColumnHeaderStringData(String[] colHeaderStringData) {
        this.columnHeaderStringData = colHeaderStringData;
        if (this.columnHeaderStringData == null) {
            this.setColumnHeaderData(null);
        } else {
            this.setColumnHeaderData(new JSCSArray("columnHeader", colHeaderStringData));
        }
        this.updateColWidthForHeader();
    }

    public void setColumnHeaderSymbolName(String newColumnHeaderSymbolName) {
        JSCConstants.checkNameThrowEx(newColumnHeaderSymbolName);
        this.getColumnHeaderDataTable().setSymbolName(newColumnHeaderSymbolName);
        this.columnHeaderSymbolName = newColumnHeaderSymbolName;
        this.updateColWidthForHeader();
    }

    private void setDataTable(JSCAbstractDataTable newDataTable) {
        if (this.dataTable != null) {
            this.dataTable.removePropertyChangeListener(this.eventListener);
            this.dataTable.removeVetoableChangeListener(this.eventListener);
        }
        this.dataTable = newDataTable;
        if (this.dataTable != null) {
            JTableHeader header = new JTableHeader();
            header.setReorderingAllowed(false);
            header.setResizingAllowed(false);
            this.dataTable.setTableHeader(header);
            this.dataTable.addVetoableChangeListener(this.eventListener);
            this.dataTable.addPropertyChangeListener(this.eventListener);
            this.setUpRowHeader();
            this.setRowHeaderCellRenderer(this.getRowHeaderCellRenderer());
            this.setColumnHeaderView(this.getColumnHeaderDataTable());
            this.setColumnHeaderCellRenderer(this.getColumnHeaderCellRenderer());
            this.updateColWidthForHeader();
        }
    }

    public void setSymbolScope(Scope newSymbolScope) {
        if (newSymbolScope == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        this.symbolScope = newSymbolScope;
        this.getColumnHeaderDataTable().setSymbolScope(this.symbolScope);
        this.getRowHeaderDataTable().setSymbolScope(this.symbolScope);
        this.updateColWidthForHeader();
    }

    public void setMaximumVisibleColumns(int newMaximumVisibleColumns) {
        if (newMaximumVisibleColumns <= 0 || newMaximumVisibleColumns < this.minimumVisibleColumns) {
            throw new IllegalArgumentException("Bad maximumVisibleColumns argument.");
        }
        this.maximumVisibleColumns = newMaximumVisibleColumns;
    }

    public void setMaximumVisibleRows(int newMaximumVisibleRows) {
        if (newMaximumVisibleRows <= 0 || newMaximumVisibleRows < this.minimumVisibleRows) {
            throw new IllegalArgumentException("Bad maximumVisibleRows argument.");
        }
        this.maximumVisibleRows = newMaximumVisibleRows;
    }

    public void setMinimumVisibleColumns(int newMinimumVisibleColumns) {
        if (newMinimumVisibleColumns <= 0 || newMinimumVisibleColumns > this.maximumVisibleColumns) {
            throw new IllegalArgumentException("Bad minimumVisibleColumns argument.");
        }
        this.minimumVisibleColumns = newMinimumVisibleColumns;
    }

    public void setMinimumVisibleRows(int newMinimumVisibleRows) {
        if (newMinimumVisibleRows <= 0 || newMinimumVisibleRows > this.maximumVisibleRows) {
            throw new IllegalArgumentException("Bad minimumVisibleRows argument.");
        }
        this.minimumVisibleRows = newMinimumVisibleRows;
    }

    public void setRowHeaderAlignment(int newRowHeaderAlignment) {
        if (newRowHeaderAlignment != 2 && newRowHeaderAlignment != 4 && newRowHeaderAlignment != 0) {
            throw new IllegalArgumentException("invalid row header policy");
        }
        this.rowHeaderAlignment = newRowHeaderAlignment;
        if (this.getRowHeaderCellRenderer() instanceof JSCCellRendererTypes) {
            ((JSCCellRendererTypes)this.getRowHeaderCellRenderer()).setHorizontalAlignment(this.rowHeaderAlignment);
        }
    }

    public void setRowHeaderCellRenderer(TableCellRenderer newRowHeaderCellRenderer) {
        if (!(newRowHeaderCellRenderer instanceof JComponent)) {
            throw new IllegalArgumentException("CellRenderer must be instance of JComponent");
        }
        this.rowHeaderCellRenderer = newRowHeaderCellRenderer;
        if (this.dataTable != null && this.rowHeaderCellRenderer != null) {
            JComponent c = (JComponent)((Object)this.rowHeaderCellRenderer);
            Dimension is = this.dataTable.getIntercellSpacing();
            TableCellRenderer tcr = this.dataTable.getCellRenderer();
            int x = 2;
            if (tcr instanceof JComponent) {
                x = ((JComponent)((Object)tcr)).getInsets().bottom;
            }
            EmptyBorder insideBorder = new EmptyBorder(is.height, 3, is.height + x, 3);
            Border outsideBorder = c.getBorder();
            if (outsideBorder != null && outsideBorder instanceof CompoundBorder) {
                outsideBorder = ((CompoundBorder)outsideBorder).getOutsideBorder();
            }
            if (outsideBorder != null) {
                c.setBorder(new CompoundBorder(outsideBorder, insideBorder));
            } else {
                c.setBorder(insideBorder);
            }
            int h = this.dataTable.getRowHeight();
            this.getRowHeaderDataTable().setRowHeight(h);
        }
        this.getRowHeaderDataTable().setCellRenderer(this.rowHeaderCellRenderer);
    }

    private void setUpRowHeader() {
        this.getRowHeaderDataTable().setColumnModel(new DefaultTableColumnModel());
        this.getRowHeaderDataTable().setSymbolName(this.rowHeaderSymbolName);
        if (this.dataTable != null) {
            this.dataTable.setColumnModel(new DefaultTableColumnModel());
        }
    }

    public void setRowHeaderData(JSCSArray newRowHeaderData) {
        this.getRowHeaderDataTable().setJSCData(newRowHeaderData);
    }

    public void setRowHeaderSymbolName(String newRowHeaderSymbolName) {
        JSCConstants.checkNameThrowEx(newRowHeaderSymbolName);
        this.getRowHeaderDataTable().setSymbolName(newRowHeaderSymbolName);
        this.rowHeaderSymbolName = newRowHeaderSymbolName;
    }

    @Override
    public void setViewportView(Component view) {
        super.setViewportView(view);
        if (view instanceof JSCAbstractDataTable) {
            this.setDataTable((JSCAbstractDataTable)view);
        }
    }

    public SymbolTable getSymbolTable() {
        return this.getColumnHeaderDataTable().getSymbolTable();
    }

    public void setSymbolTable(SymbolTable table) {
        this.getColumnHeaderDataTable().setSymbolTable(table);
        this.getRowHeaderDataTable().setSymbolTable(table);
        this.updateColWidthForHeader();
    }

    private void updateColWidthForHeader() {
        if (this.dataTable != null && this.dataTable.isDynamicColumnWidth()) {
            int i = this.getColumnHeaderDataTable().maxCellLength();
            int j = this.dataTable.maxCellLength();
            int max = Math.max(i, j);
            this.dataTable.setColumnWidth(max);
            this.getColumnHeaderDataTable().setColumnWidth(max);
        }
    }

    private class EventListener
    implements PropertyChangeListener,
    VetoableChangeListener {
        private EventListener() {
        }

        @Override
        public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
            int vetoValue;
            int newValue;
            if (e.getSource() == JSCDataTableScrollPane.this.dataTable && e.getPropertyName().equals("columnWidth") && (newValue = ((Integer)e.getNewValue()).intValue()) < (vetoValue = JSCDataTableScrollPane.this.getColumnHeaderDataTable().maxCellLength())) {
                PropertyChangeEvent pce = new PropertyChangeEvent(JSCDataTableScrollPane.this.getColumnHeaderDataTable(), "columnWidth", new Integer(newValue), new Integer(vetoValue));
                throw new PropertyVetoException("ColumnHeader vetos new preferred column size", pce);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getSource() == JSCDataTableScrollPane.this.columnHeaderDataTable && (e.getPropertyName().equals("columnWidth") || e.getPropertyName().equals("model"))) {
                if (JSCDataTableScrollPane.this.dataTable == null || !JSCDataTableScrollPane.this.dataTable.isDynamicColumnWidth()) {
                    return;
                }
                JSCDataTableScrollPane.this.dataTable.setColumnWidth(JSCDataTableScrollPane.this.columnHeaderDataTable.maxCellLength());
                JSCDataTableScrollPane.this.setColumnHeaderCellRenderer(JSCDataTableScrollPane.this.getColumnHeaderCellRenderer());
            }
            if (e.getSource() == JSCDataTableScrollPane.this.dataTable && e.getPropertyName().equals("columnWidth")) {
                int maxCellHeader;
                int newValue = (Integer)e.getNewValue();
                if (newValue < (maxCellHeader = JSCDataTableScrollPane.this.columnHeaderDataTable.maxCellLength())) {
                    JSCDataTableScrollPane.this.dataTable.setColumnWidth(maxCellHeader);
                } else {
                    JSCDataTableScrollPane.this.getColumnHeaderDataTable().setColumnWidth(newValue);
                }
            }
            if (e.getPropertyName().equals("intercellSpacing") && JSCDataTableScrollPane.this.columnHeaderCellRenderer != null) {
                JSCDataTableScrollPane.this.setColumnHeaderCellRenderer(JSCDataTableScrollPane.this.columnHeaderCellRenderer);
            }
        }
    }
}

