/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.table;

import com.jstatcom.model.JSCConstants;
import com.jstatcom.model.JSCData;
import com.jstatcom.model.JSCNArray;
import com.jstatcom.model.JSCTypeDef;
import com.jstatcom.model.JSCTypes;
import com.jstatcom.model.Scope;
import com.jstatcom.model.SymbolTable;
import com.jstatcom.table.BorderTable;
import com.jstatcom.table.JSCAbstractTableModel;
import com.jstatcom.table.JSCCellRendererTypes;
import com.jstatcom.table.JSCDataTableScrollPane;
import java.awt.Container;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.plaf.TableUI;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public abstract class JSCAbstractDataTable
extends BorderTable {
    private final Map<Integer, Boolean> colIndexEditableMap = new HashMap<Integer, Boolean>();
    private final Map<Integer, Boolean> rowIndexEditableMap = new HashMap<Integer, Boolean>();
    private JSCDataTableScrollPane enclosingScrollPane = null;
    private TableCellRenderer cellRenderer = JSCCellRendererTypes.DEFAULT;
    private MouseListener triggerPopUp = null;
    private MouseListener mouseListener = null;
    private JPopupMenu tablePopup = null;
    private boolean isEditable = false;
    private String symbolName = null;
    private Scope symbolScope = Scope.GLOBAL;
    private SymbolTable symbolTable = null;
    private JSCTypeDef symbolTypeDef = null;

    public JSCAbstractDataTable() {
        this.setDynamicColumnWidth(true);
        this.setRowSelectionAllowed(false);
    }

    public void setColEditable(boolean editable, int colIndex, boolean clearPreviousBefore) {
        if (clearPreviousBefore) {
            this.colIndexEditableMap.clear();
        }
        this.colIndexEditableMap.put(colIndex, editable);
        if (this.getModel() instanceof JSCAbstractTableModel) {
            ((JSCAbstractTableModel)this.getModel()).setColEditableMap(this.colIndexEditableMap);
        }
    }

    public void setRowEditable(boolean editable, int rowIndex, boolean clearPreviousBefore) {
        if (clearPreviousBefore) {
            this.rowIndexEditableMap.clear();
        }
        this.rowIndexEditableMap.put(rowIndex, editable);
        if (this.getModel() instanceof JSCAbstractTableModel) {
            ((JSCAbstractTableModel)this.getModel()).setRowEditableMap(this.rowIndexEditableMap);
        }
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public void setEditable(boolean editable) {
        this.isEditable = editable;
        if (this.getModel() instanceof JSCAbstractTableModel) {
            ((JSCAbstractTableModel)this.getModel()).setEditable(this.isEditable);
        }
    }

    public String getSymbolName() {
        return this.symbolName;
    }

    public void setSymbolName(String symbolName) {
        JSCConstants.checkNameThrowEx(symbolName);
        this.symbolName = symbolName;
        if (this.symbolTable != null) {
            this.setModelForSymbolName(this.symbolTable, symbolName);
        } else {
            SymbolTable sTableFromScope = this.symbolScope.getSymbolTable(this);
            if (sTableFromScope != null) {
                this.setModelForSymbolName(sTableFromScope, symbolName);
            }
        }
    }

    public Scope getSymbolScope() {
        return this.symbolScope;
    }

    public void setSymbolScope(Scope scope) {
        if (scope == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        this.symbolScope = scope;
        this.symbolTable = null;
        SymbolTable sTableFromScope = this.symbolScope.getSymbolTable(this);
        if (sTableFromScope != null && this.symbolName != null) {
            this.setModelForSymbolName(sTableFromScope, this.symbolName);
        }
        this.updateSelectionData();
    }

    @Override
    public void updateUI() {
        if (this.cellRenderer != null) {
            ((JComponent)((Object)this.cellRenderer)).updateUI();
        }
        if (this.cellEditor != null) {
            ((JComponent)((DefaultCellEditor)this.cellEditor).getComponent()).updateUI();
        }
        this.setUI((TableUI)UIManager.getUI(this));
        if (this.isDynamicColumnWidth()) {
            this.setColumnWidth(this.maxCellLength());
        }
        if (this.enclosingScrollPane != null) {
            this.enclosingScrollPane.setColumnHeaderCellRenderer(this.enclosingScrollPane.getColumnHeaderCellRenderer());
        }
        this.resizeAndRepaint();
    }

    public MouseListener getMouseListener() {
        return this.mouseListener;
    }

    public void setMouseListener(MouseListener listener) {
        if (this.mouseListener != null) {
            this.removeMouseListener(this.mouseListener);
        }
        this.mouseListener = listener;
        if (this.mouseListener != null) {
            this.addMouseListener(this.mouseListener);
        }
    }

    public TableCellRenderer getCellRenderer() {
        return this.cellRenderer;
    }

    public void setCellRenderer(TableCellRenderer renderer) {
        this.cellRenderer = renderer;
        TableModel m = this.getModel();
        if (m != null) {
            TableColumnModel cm = this.getColumnModel();
            int n = cm.getColumnCount();
            for (int i = 0; i < n; ++i) {
                TableColumn tc = cm.getColumn(i);
                tc.setCellRenderer(this.cellRenderer);
            }
        }
        this.updateUI();
    }

    public JPopupMenu getTablePopup() {
        return this.tablePopup;
    }

    public void setTablePopup(JPopupMenu menu) {
        this.tablePopup = menu;
        if (this.tablePopup == null) {
            this.removeMouseListener(this.triggerPopUp);
        } else {
            this.triggerPopUp = new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    JSCAbstractDataTable.this.tablePopup.processMouseEvent(e, null, null);
                }
            };
            this.addMouseListener(this.triggerPopUp);
        }
    }

    public JSCData getJSCData() {
        if (this.dataModel instanceof JSCAbstractTableModel) {
            return ((JSCAbstractTableModel)this.dataModel).getJSCData();
        }
        return null;
    }

    public void setJSCData(JSCData data) {
        this.setSymbolName(null);
        this.setModelForJSCData(data);
    }

    @Override
    public void addNotify() {
        SymbolTable sTableFromScope;
        super.addNotify();
        if (this.symbolTable == null && (sTableFromScope = this.symbolScope.getSymbolTable(this)) != null && this.symbolName != null) {
            this.setModelForSymbolName(sTableFromScope, this.symbolName);
        }
        if (this.getModel() instanceof JSCAbstractTableModel) {
            JSCAbstractTableModel model = (JSCAbstractTableModel)this.getModel();
            model.setEditable(this.isEditable);
            model.setColEditableMap(this.colIndexEditableMap);
            model.setRowEditableMap(this.rowIndexEditableMap);
        }
        this.updateUI();
    }

    @Override
    public void setModel(TableModel model) {
        super.setModel(model);
        if (this.getModel() instanceof JSCAbstractTableModel) {
            JSCAbstractTableModel m = (JSCAbstractTableModel)this.getModel();
            m.setEditable(this.isEditable);
            m.setColEditableMap(this.colIndexEditableMap);
            m.setRowEditableMap(this.rowIndexEditableMap);
        }
        this.firePropertyChange("model", null, model);
    }

    public SymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    public abstract void setModelForJSCData(JSCData var1);

    public abstract void setModelForSymbolName(SymbolTable var1, String var2);

    public void setSymbolTable(SymbolTable table) {
        SymbolTable sTableFromScope;
        if (table == this.symbolTable) {
            return;
        }
        this.symbolTable = table;
        if (table == null && (sTableFromScope = this.symbolScope.getSymbolTable(this)) != null && this.symbolName != null) {
            this.setModelForSymbolName(sTableFromScope, this.symbolName);
        }
        if (table != null && this.symbolName != null) {
            this.setModelForSymbolName(table, this.symbolName);
        }
        this.updateSelectionData();
    }

    @Override
    protected void configureEnclosingScrollPane() {
        Container gp;
        Container p = this.getParent();
        if (p instanceof JViewport && (gp = p.getParent()) instanceof JScrollPane) {
            JScrollPane scrollPane = (JScrollPane)gp;
            JViewport viewport = scrollPane.getViewport();
            if (viewport == null || viewport.getView() != this) {
                return;
            }
            if (scrollPane instanceof JSCDataTableScrollPane) {
                this.enclosingScrollPane = (JSCDataTableScrollPane)scrollPane;
                this.enclosingScrollPane.setColumnHeaderView(this.enclosingScrollPane.getColumnHeaderDataTable());
            }
        }
    }

    @Override
    public void createDefaultColumnsFromModel() {
        super.createDefaultColumnsFromModel();
        TableModel m = this.getModel();
        if (m != null) {
            TableColumnModel cm = this.getColumnModel();
            TableCellRenderer renderer = this.getCellRenderer();
            TableCellRenderer columnHeaderRenderer = null;
            if (this.enclosingScrollPane != null && this.enclosingScrollPane != null) {
                columnHeaderRenderer = this.enclosingScrollPane.getColumnHeaderCellRenderer();
            }
            int n = cm.getColumnCount();
            for (int i = 0; i < n; ++i) {
                TableColumn tc = cm.getColumn(i);
                tc.setCellEditor(this.cellEditor);
                tc.setCellRenderer(renderer);
                if (columnHeaderRenderer == null) continue;
                tc.setHeaderRenderer(columnHeaderRenderer);
            }
        }
    }

    public void setRowSelectionMode(int newRowSelMode) {
        this.getSelectionModel().setSelectionMode(newRowSelMode);
    }

    public int getRowSelectionMode() {
        return this.getSelectionModel().getSelectionMode();
    }

    public String getSymbolNameSelRows() {
        return this.symbolTypeDef.name;
    }

    public void setSymbolNameSelRows(String symbolNameSelRows) {
        this.symbolTypeDef = symbolNameSelRows == null ? null : new JSCTypeDef(symbolNameSelRows, JSCTypes.NARRAY);
        this.updateSelectionData();
    }

    private void updateSelectionData() {
        if (this.symbolTypeDef == null) {
            return;
        }
        JSCNArray indexData = new JSCNArray("index", this.getIntSelectionIndex());
        if (this.symbolTable != null) {
            this.symbolTable.get(this.symbolTypeDef).setJSCData(indexData);
        } else {
            SymbolTable sTableFromScope = this.symbolScope.getSymbolTable(this);
            if (sTableFromScope != null) {
                sTableFromScope.get(this.symbolTypeDef).setJSCData(indexData);
            }
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        super.tableChanged(e);
        if (this.enclosingScrollPane != null && this.enclosingScrollPane.getParent() != null) {
            ((JComponent)this.enclosingScrollPane.getParent()).revalidate();
        }
        this.updateSelectionData();
        this.firePropertyChange("columnWidth", -1, this.getColumnWidth());
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        super.valueChanged(e);
        if (!e.getValueIsAdjusting()) {
            this.updateSelectionData();
        }
    }

    public int[] getIntSelectionIndex() {
        int length = this.getModel().getRowCount();
        int[] selRows = this.getSelectedRows();
        int[] index = new int[length];
        for (int i = 0; i < selRows.length; ++i) {
            index[selRows[i]] = 1;
        }
        return index;
    }
}

