/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.project;

import com.jstatcom.project.ModuleTreeNode;
import com.jstatcom.project.ProjectTreeNode;
import java.awt.Color;
import java.awt.Component;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

final class ProjectTreeCellRenderer
extends DefaultTreeCellRenderer {
    private Icon currentProjectIcon = null;
    private Icon defaultProjectIcon = null;

    public ProjectTreeCellRenderer() {
        URL url = ProjectTreeCellRenderer.class.getResource("/images/currentproject.gif");
        if (url != null) {
            this.currentProjectIcon = new ImageIcon(url);
        }
        if ((url = this.getClass().getResource("/images/project.gif")) != null) {
            this.defaultProjectIcon = new ImageIcon(url);
        }
    }

    @Override
    public String getToolTipText() {
        return super.getToolTipText();
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Component comp = super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        if (value instanceof ProjectTreeNode) {
            ProjectTreeNode valueNode = (ProjectTreeNode)value;
            if (valueNode.isCurrentProject()) {
                comp.setForeground(Color.BLUE);
                if (this.currentProjectIcon != null) {
                    this.setIcon(this.currentProjectIcon);
                }
            } else if (this.defaultProjectIcon != null) {
                this.setIcon(this.defaultProjectIcon);
            } else {
                this.setIcon(this.getDefaultLeafIcon());
            }
        } else if (value instanceof ModuleTreeNode) {
            ModuleTreeNode valueNode = (ModuleTreeNode)value;
            this.setIcon(valueNode.getIcon());
        }
        return comp;
    }
}

