/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.project;

import com.jstatcom.component.ResultField;
import com.jstatcom.component.StdMessages;
import com.jstatcom.component.TopFrameReference;
import com.jstatcom.io.FileSupport;
import com.jstatcom.project.OutputData;
import com.jstatcom.project.Project;
import com.jstatcom.project.ProjectData;
import com.jstatcom.project.ProjectDataManager;
import com.jstatcom.project.ProjectDataTypes;
import com.jstatcom.project.ProjectManager;
import com.jstatcom.project.ProjectState;
import com.jstatcom.project.ProjectTree;
import com.jstatcom.project.ProjectTreeNode;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public final class ProjectDialog
extends JDialog {
    private static final Logger log = Logger.getLogger(ProjectDialog.class);
    private static final ProjectDialog INSTANCE = new ProjectDialog();
    private ProjectData[] dataArray = null;
    private boolean cancelled = false;
    private boolean isSaveDialog = false;
    private Project editProject = null;
    Map<Object, String> descriptions = new HashMap<Object, String>();
    private ProjectTreeNode treeNode = null;
    private JPanel jPanel = null;
    private JPanel jPanel1 = null;
    private JPanel jPanel2 = null;
    private JButton jButton = null;
    private JButton jButton1 = null;
    private JLabel jLabel = null;
    private JLabel jLabel1 = null;
    private JLabel jLabel2 = null;
    private JComboBox dataComboBox = null;
    private JTextField projectNameField = null;
    private JTextField fileNameField = null;
    private JLabel jLabel4 = null;
    private JPanel jPanel3 = null;
    private JLabel jLabel3 = null;
    private ResultField dataDesField = null;
    private ResultField projectDesArea = null;
    private JButton browseButton = null;

    public ProjectDialog() {
        super((Frame)TopFrameReference.getTopFrameRef(), true);
        this.initialize();
    }

    public static ProjectDialog getInstance() {
        return INSTANCE;
    }

    public void setProjectNode(ProjectTreeNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        this.treeNode = node;
        this.getProjectNameField().setText(node.getName());
        File pFile = node.getProjectFile();
        this.getFileNameField().setText(pFile.getAbsolutePath());
        this.getProjectDesArea().setText(node.getDescription());
        this.getDataComboBox().removeAllItems();
        this.getDataDesField().setText("");
        this.editProject = ProjectManager.getInstance().getProjectFromFile(pFile);
        Iterator iter = this.editProject.getProjectDataIterator();
        while (iter.hasNext()) {
            ProjectData element = (ProjectData)iter.next();
            this.getDataComboBox().addItem(element.getProjectDataType());
            this.descriptions.put(element.getProjectDataType(), element.getDescription());
        }
        int datNumber = this.getDataComboBox().getItemCount();
        this.dataArray = new ProjectData[datNumber];
        int i = 0;
        Iterator iter2 = this.editProject.getProjectDataIterator();
        while (iter2.hasNext()) {
            ProjectData element = (ProjectData)iter2.next();
            this.dataArray[i++] = element;
        }
        if (datNumber > 0) {
            this.getDataComboBox().setSelectedIndex(0);
            ProjectDataTypes type = (ProjectDataTypes)this.getDataComboBox().getSelectedItem();
            this.getDataDesField().setText(this.descriptions.get(type) + "");
        }
    }

    public ProjectTreeNode getProjectNode() {
        return this.treeNode;
    }

    private void initialize() {
        this.setDefaultCloseOperation(0);
        this.setContentPane(this.getJPanel());
        this.setTitle("Edit Project Settings");
        this.setSize(716, 563);
        this.setLocationRelativeTo(TopFrameReference.getTopFrameRef());
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new BorderLayout());
            this.jPanel.add((Component)this.getJPanel1(), "South");
            this.jPanel.add((Component)this.getJPanel2(), "Center");
        }
        return this.jPanel;
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            FlowLayout flowLayout1 = new FlowLayout();
            this.jPanel1 = new JPanel();
            this.jPanel1.setLayout(flowLayout1);
            this.jPanel1.setPreferredSize(new Dimension(10, 50));
            flowLayout1.setHgap(100);
            flowLayout1.setVgap(10);
            this.jPanel1.add((Component)this.getJButton(), null);
            this.jPanel1.add((Component)this.getJButton1(), null);
        }
        return this.jPanel1;
    }

    private JPanel getJPanel2() {
        if (this.jPanel2 == null) {
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            this.jLabel4 = new JLabel();
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints16 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints17 = new GridBagConstraints();
            this.jLabel2 = new JLabel();
            this.jLabel1 = new JLabel();
            this.jLabel = new JLabel();
            this.jPanel2 = new JPanel();
            this.jPanel2.setLayout(new GridBagLayout());
            this.jPanel2.setBorder(BorderFactory.createBevelBorder(1));
            this.jLabel.setText("File name (.jsc)");
            this.jLabel.setPreferredSize(new Dimension(54, 20));
            this.jLabel1.setText("Project name");
            this.jLabel1.setPreferredSize(new Dimension(76, 20));
            this.jLabel2.setText("Project description");
            this.jLabel2.setPreferredSize(new Dimension(108, 20));
            this.jLabel4.setText("Select data type");
            this.jLabel4.setPreferredSize(new Dimension(91, 20));
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = 1;
            gridBagConstraints1.ipadx = 0;
            gridBagConstraints1.ipady = 0;
            gridBagConstraints1.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints1.fill = 2;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.ipadx = 0;
            gridBagConstraints2.ipady = 0;
            gridBagConstraints2.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints2.fill = 2;
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridy = 2;
            gridBagConstraints3.ipadx = 0;
            gridBagConstraints3.ipady = 0;
            gridBagConstraints3.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.anchor = 11;
            gridBagConstraints4.gridx = 1;
            gridBagConstraints4.gridy = 0;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.fill = 2;
            gridBagConstraints4.ipadx = 0;
            gridBagConstraints4.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints4.gridwidth = 2;
            gridBagConstraints6.gridx = 1;
            gridBagConstraints6.gridy = 1;
            gridBagConstraints6.weightx = 1.0;
            gridBagConstraints6.fill = 2;
            gridBagConstraints6.ipadx = 0;
            gridBagConstraints6.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints16.gridx = 0;
            gridBagConstraints16.gridy = 3;
            gridBagConstraints16.gridwidth = 3;
            gridBagConstraints16.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints16.weighty = 1.0;
            gridBagConstraints16.fill = 1;
            gridBagConstraints17.gridx = 1;
            gridBagConstraints17.gridy = 2;
            gridBagConstraints17.weightx = 1.0;
            gridBagConstraints17.weighty = 1.0;
            gridBagConstraints17.fill = 1;
            gridBagConstraints17.insets = new Insets(5, 5, 0, 5);
            gridBagConstraints17.gridwidth = 2;
            gridBagConstraints11.gridx = 2;
            gridBagConstraints11.gridy = 1;
            gridBagConstraints11.insets = new Insets(0, 0, 0, 5);
            this.jPanel2.add((Component)this.jLabel, gridBagConstraints1);
            this.jPanel2.add((Component)this.jLabel1, gridBagConstraints2);
            this.jPanel2.add((Component)this.jLabel2, gridBagConstraints3);
            this.jPanel2.add((Component)this.getProjectNameField(), gridBagConstraints4);
            this.jPanel2.add((Component)this.getFileNameField(), gridBagConstraints6);
            this.jPanel2.add((Component)this.getJPanel3(), gridBagConstraints16);
            this.jPanel2.add((Component)this.getProjectDesArea(), gridBagConstraints17);
            this.jPanel2.add((Component)this.getBrowseButton(), gridBagConstraints11);
        }
        return this.jPanel2;
    }

    private JButton getJButton() {
        if (this.jButton == null) {
            this.jButton = new JButton();
            this.jButton.setText("OK");
            this.jButton.setPreferredSize(new Dimension(100, 26));
            this.jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean wasCurrent;
                    int status;
                    File pFile;
                    String pName = ProjectDialog.this.getProjectNameField().getText();
                    if (pName.length() == 0) {
                        StdMessages.error("The project name is empty, please choose a name.", "Project Name Error", ProjectDialog.this);
                        return;
                    }
                    String fName = ProjectDialog.this.getFileNameField().getText();
                    if (fName.length() == 0) {
                        StdMessages.error("The project filename is empty or invalid, please change.", "Project File Error", ProjectDialog.this);
                        return;
                    }
                    if (!fName.endsWith(".jsc")) {
                        fName = fName + ".jsc";
                    }
                    if ((pFile = new File(fName).getAbsoluteFile()).getParentFile() != null && !pFile.getParentFile().canWrite()) {
                        StdMessages.error("Cannot write to project file\n\"" + pFile.getAbsolutePath() + "\".\nPlease change the directory or check your write permissions.", "Project File Error", ProjectDialog.this);
                        return;
                    }
                    File origFile = null;
                    if (!ProjectDialog.this.isSaveDialog) {
                        origFile = ProjectDialog.this.treeNode.getProjectFile();
                    }
                    if ((pFile.exists() && ProjectDialog.this.isSaveDialog || pFile.exists() && !pFile.equals(origFile)) && (status = JOptionPane.showConfirmDialog(TopFrameReference.getTopFrameRef(), "The file  \"" + pFile.getAbsolutePath() + "\" already exists.\nDo you want to overwrite it?", "Overwrite?", 0, 3)) == 1) {
                        return;
                    }
                    String pDes = ProjectDialog.this.getProjectDesArea().getText();
                    boolean bl = wasCurrent = ProjectDialog.this.isSaveDialog ? true : ProjectDialog.this.treeNode.isCurrentProject();
                    if (!ProjectDialog.this.isSaveDialog) {
                        ProjectTree.getInstance().removeTreeNode(ProjectDialog.this.treeNode);
                    }
                    ProjectDialog.this.treeNode = new ProjectTreeNode(new Project(pName, pDes), pFile, wasCurrent);
                    if (ProjectDialog.this.getDataComboBox().getSelectedIndex() > -1) {
                        ProjectDialog.this.descriptions.put(ProjectDialog.this.getDataComboBox().getSelectedItem(), ProjectDialog.this.getDataDesField().getText());
                    }
                    try {
                        if (ProjectDialog.this.isSaveDialog) {
                            for (int i = 0; i < ProjectDialog.this.dataArray.length; ++i) {
                                ProjectDialog.this.dataArray[i].setDescription(ProjectDialog.this.descriptions.get(ProjectDialog.this.dataArray[i].getProjectDataType()) + "");
                                ProjectDataManager.getInstance().setProjectData(ProjectDialog.this.dataArray[i]);
                            }
                            ProjectManager.getInstance().serializeProject(pFile, pName, pDes);
                        } else {
                            Object element;
                            for (int i = 0; i < ProjectDialog.this.dataArray.length; ++i) {
                                ProjectDialog.this.dataArray[i].setDescription(ProjectDialog.this.descriptions.get(ProjectDialog.this.dataArray[i].getProjectDataType()) + "");
                            }
                            Project newProject = new Project(pName, pDes);
                            Iterator iter = ProjectDialog.this.editProject.getOutputDataIterator();
                            while (iter.hasNext()) {
                                element = (OutputData)iter.next();
                                newProject.addOutputData((OutputData)element);
                            }
                            iter = ProjectDialog.this.editProject.getProjectStatesIterator();
                            while (iter.hasNext()) {
                                element = (ProjectState)iter.next();
                                newProject.addProjectState((ProjectState)element);
                            }
                            for (int i = 0; i < ProjectDialog.this.dataArray.length; ++i) {
                                newProject.addProjectData(ProjectDialog.this.dataArray[i]);
                            }
                            ProjectManager.getInstance().setProjectToFile(pFile, newProject);
                            ProjectTree.getInstance().addProjectNode(ProjectDialog.this.treeNode);
                            ProjectTree.getInstance().loadProjectForNode(ProjectDialog.this.treeNode);
                        }
                    }
                    catch (Throwable ex) {
                        String msg = "There was an error saving a project to file:\n\"" + pFile.getAbsolutePath() + "\".";
                        log.error((Object)msg, ex);
                        StdMessages.error(msg + "\nThe error message was:\n\"" + ex.getMessage() + "\"\nPlease see the log for more details.", "Project Save Error");
                        return;
                    }
                    ProjectDialog.this.cancelled = false;
                    ProjectDialog.this.setVisible(false);
                }
            });
        }
        return this.jButton;
    }

    private JButton getJButton1() {
        if (this.jButton1 == null) {
            this.jButton1 = new JButton();
            this.jButton1.setText("Cancel");
            this.jButton1.setPreferredSize(new Dimension(100, 26));
            this.jButton1.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ProjectDialog.this.cancelled = true;
                    ProjectDialog.this.treeNode = null;
                    ProjectDialog.this.setVisible(false);
                }
            });
        }
        return this.jButton1;
    }

    private JComboBox getDataComboBox() {
        if (this.dataComboBox == null) {
            this.dataComboBox = new JComboBox();
            this.dataComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 2) {
                        ProjectDialog.this.descriptions.put(e.getItem(), ProjectDialog.this.getDataDesField().getText());
                    }
                    if (e.getStateChange() == 1) {
                        String o = ProjectDialog.this.descriptions.get(e.getItem());
                        String des = o == null ? "" : o.toString();
                        ProjectDialog.this.getDataDesField().setText(des);
                    }
                }
            });
        }
        return this.dataComboBox;
    }

    private JTextField getProjectNameField() {
        if (this.projectNameField == null) {
            this.projectNameField = new JTextField();
        }
        return this.projectNameField;
    }

    private JTextField getFileNameField() {
        if (this.fileNameField == null) {
            this.fileNameField = new JTextField();
        }
        return this.fileNameField;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    private JPanel getJPanel3() {
        if (this.jPanel3 == null) {
            this.jPanel3 = new JPanel();
            this.jLabel3 = new JLabel();
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
            this.jPanel3.setLayout(new GridBagLayout());
            this.jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(0), "Data Description", 0, 0, new Font("Dialog", 1, 12), Color.black));
            this.jLabel3.setText("Set Description");
            this.jLabel3.setPreferredSize(new Dimension(87, 20));
            gridBagConstraints12.gridx = 0;
            gridBagConstraints12.gridy = 0;
            gridBagConstraints12.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints12.fill = 2;
            gridBagConstraints13.gridx = 1;
            gridBagConstraints13.gridy = 0;
            gridBagConstraints13.weightx = 1.0;
            gridBagConstraints13.fill = 2;
            gridBagConstraints13.ipadx = 0;
            gridBagConstraints13.ipady = 0;
            gridBagConstraints13.insets = new Insets(5, 5, 5, 100);
            gridBagConstraints14.gridx = 1;
            gridBagConstraints14.gridy = 1;
            gridBagConstraints14.weightx = 1.0;
            gridBagConstraints14.weighty = 1.0;
            gridBagConstraints14.fill = 1;
            gridBagConstraints14.ipadx = 0;
            gridBagConstraints14.ipady = 0;
            gridBagConstraints14.insets = new Insets(5, 5, 0, 0);
            gridBagConstraints15.gridx = 0;
            gridBagConstraints15.gridy = 1;
            gridBagConstraints15.ipadx = 0;
            gridBagConstraints15.ipady = 0;
            gridBagConstraints15.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints15.fill = 2;
            gridBagConstraints15.anchor = 11;
            this.jPanel3.add((Component)this.jLabel4, gridBagConstraints12);
            this.jPanel3.add((Component)this.getDataComboBox(), gridBagConstraints13);
            this.jPanel3.add((Component)this.getDataDesField(), gridBagConstraints14);
            this.jPanel3.add((Component)this.jLabel3, gridBagConstraints15);
        }
        return this.jPanel3;
    }

    private ResultField getDataDesField() {
        if (this.dataDesField == null) {
            this.dataDesField = new ResultField();
        }
        return this.dataDesField;
    }

    private ResultField getProjectDesArea() {
        if (this.projectDesArea == null) {
            this.projectDesArea = new ResultField();
            this.projectDesArea.setPreferredSize(new Dimension(150, 100));
        }
        return this.projectDesArea;
    }

    private JButton getBrowseButton() {
        if (this.browseButton == null) {
            this.browseButton = new JButton();
            this.browseButton.setText("Browse...");
            this.browseButton.setPreferredSize(new Dimension(100, 26));
            this.browseButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    File file = FileSupport.getInstance().saveProjectFile(ProjectDialog.this);
                    if (file != null) {
                        ProjectDialog.this.getFileNameField().setText(file.getAbsolutePath());
                    }
                }
            });
        }
        return this.browseButton;
    }

    public void setSaveDialog(boolean isSaveDialog) {
        if (isSaveDialog) {
            this.setTitle("Save Project...");
            this.getProjectNameField().setText("");
            this.getFileNameField().setText("");
            this.getProjectDesArea().setText("");
            this.dataArray = ProjectDataManager.getInstance().getProjectData();
            this.getDataComboBox().removeAllItems();
            for (int i = 0; i < this.dataArray.length; ++i) {
                this.getDataComboBox().addItem(this.dataArray[i].getProjectDataType());
                this.descriptions.put(this.dataArray[i].getProjectDataType(), this.dataArray[i].getDescription());
            }
            if (this.getDataComboBox().getItemCount() > 0) {
                this.getDataComboBox().setSelectedIndex(0);
                ProjectDataTypes type = (ProjectDataTypes)this.getDataComboBox().getSelectedItem();
                this.getDataDesField().setText(this.descriptions.get(type) + "");
            }
        } else {
            this.setTitle("Edit Project Settings");
        }
        this.isSaveDialog = isSaveDialog;
    }
}

