/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.model;

import com.jstatcom.model.JSCData;
import com.jstatcom.model.JSCTypeDef;
import com.jstatcom.model.JSCTypes;
import com.jstatcom.model.Symbol;
import com.jstatcom.model.control.SymbolTableTreeNode;
import com.jstatcom.model.control.SymbolTree;
import com.jstatcom.model.control.SymbolTreeNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javolution37.javolution.xml.XmlElement;
import javolution37.javolution.xml.XmlFormat;

public class SymbolTable {
    private SymbolTableTreeNode symbolTableNode = null;
    private final String name;
    private final SymbolTable parentTable;
    public final String NAME;
    private final List<Symbol> symbolList = new ArrayList<Symbol>();
    public static final XmlFormat<SymbolTable> SymbolTable_XML = new XmlFormat<SymbolTable>(SymbolTable.class){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void format(SymbolTable data, XmlElement xml) {
            xml.setAttribute("name", data.name);
            SymbolTable symbolTable = data;
            synchronized (symbolTable) {
                for (Object o : data.symbolList) {
                    xml.add(o);
                }
            }
        }

        @Override
        public SymbolTable parse(XmlElement xml) {
            String name = xml.getAttribute("name") + "";
            SymbolTable sTable = new SymbolTable(name, false);
            while (xml.hasNext()) {
                sTable.setSymbol((Symbol)xml.getNext());
            }
            return sTable;
        }
    };

    public SymbolTable(String name) {
        this(name, null, true);
    }

    public SymbolTable(String name, boolean addToTree) {
        this(name, null, addToTree);
    }

    public SymbolTable(String name, SymbolTable parentTable) {
        this(name, parentTable, true);
    }

    public SymbolTable(String name, SymbolTable parentTable, boolean addToTree) {
        if (name == null) {
            name = "null";
        }
        this.parentTable = parentTable;
        this.name = name;
        this.NAME = name.toUpperCase();
        if (addToTree) {
            SymbolTree.getInstance().addSymbolTable(this);
        }
    }

    public final void set(JSCData[] data) {
        if (data == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        if (data.length == 0) {
            return;
        }
        for (int i = 0; i < data.length; ++i) {
            this.set(data[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void set(JSCData data) {
        if (data == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        Symbol toPut = new Symbol(data);
        Symbol symbol = null;
        boolean contains = false;
        SymbolTable symbolTable = this;
        synchronized (symbolTable) {
            contains = this.symbolList.contains(toPut);
            if (contains) {
                symbol = this.symbolList.get(this.symbolList.indexOf(toPut));
            }
        }
        if (contains) {
            symbol.setJSCData(data);
        } else {
            this.setSymbol(toPut);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void set(String symbolName, JSCData data) {
        if (data == null || symbolName == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        Symbol toPut = new Symbol(symbolName, data);
        SymbolTable symbolTable = this;
        synchronized (symbolTable) {
            if (this.symbolList.contains(toPut)) {
                Symbol symbol = this.symbolList.get(this.symbolList.indexOf(toPut));
                symbol.setJSCData(data);
            } else {
                this.setSymbol(toPut);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setSymbol(Symbol symbol) {
        if (symbol == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        SymbolTable symbolTable = this;
        synchronized (symbolTable) {
            if (this.symbolList.contains(symbol)) {
                Symbol.copySymbol(symbol, this.getSymbol(symbol.NAME));
                return;
            }
            boolean inserted = false;
            for (int i = 0; i < this.symbolList.size(); ++i) {
                if (this.symbolList.get(i).compareTo(symbol) <= 0) continue;
                this.symbolList.add(i, symbol);
                inserted = true;
                break;
            }
            if (!inserted) {
                this.symbolList.add(symbol);
            }
            if (this.symbolTableNode != null) {
                this.symbolTableNode.addSymbol(symbol);
            }
        }
    }

    public final synchronized void clear() {
        this.symbolList.clear();
        if (this.symbolTableNode != null) {
            this.symbolTableNode.clear();
        }
    }

    public final synchronized boolean contains(String symbolName) {
        return this.symbolList.contains(new Symbol(new JSCTypeDef(symbolName, JSCTypes.NUMBER)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Symbol getSymbol(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        Symbol symbol = new Symbol(new JSCTypeDef(name, JSCTypes.NUMBER));
        SymbolTable symbolTable = this;
        synchronized (symbolTable) {
            if (this.symbolList.contains(symbol)) {
                return this.symbolList.get(this.symbolList.indexOf(symbol));
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Symbol get(JSCTypeDef def) {
        if (def == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        Symbol symbol = new Symbol(def);
        SymbolTable symbolTable = this;
        synchronized (symbolTable) {
            if (this.symbolList.contains(symbol)) {
                symbol = this.symbolList.get(this.symbolList.indexOf(symbol));
                if (symbol.type != def.type) {
                    throw new RuntimeException("The symbol \"" + def.name + "\" to be retrieved is of type " + symbol.type + " instead of " + def.type + ".");
                }
                if (symbol.getDescription().length() == 0 && def.description.length() > 0) {
                    symbol.setDescription(def.description);
                }
                return symbol;
            }
            this.setSymbol(symbol);
            return symbol;
        }
    }

    public final synchronized JSCData getJSCData(JSCTypeDef def) {
        if (def == null) {
            throw new IllegalArgumentException("Typedef was null.");
        }
        return this.get(def).getJSCData();
    }

    public final String getName() {
        return this.name;
    }

    public final synchronized boolean isEmpty() {
        return this.symbolList.size() == 0;
    }

    public final Iterator iterator() {
        return this.symbolList.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean remove(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        SymbolTable symbolTable = this;
        synchronized (symbolTable) {
            boolean ret = this.symbolList.remove(new Symbol(new JSCTypeDef(name, JSCTypes.DATE)));
            if (ret && this.symbolTableNode != null) {
                this.symbolTableNode.removeSymbol(name);
            }
            return ret;
        }
    }

    public final synchronized int size() {
        return this.symbolList.size();
    }

    public final synchronized String toString() {
        return super.toString() + ",name=" + this.name + ",values=" + this.symbolList;
    }

    public final SymbolTable getParentTable() {
        return this.parentTable;
    }

    public void setSymbolTableNode(SymbolTableTreeNode node) {
        this.symbolTableNode = node;
        this.symbolTableNode.clear();
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            Symbol element = (Symbol)iter.next();
            this.symbolTableNode.add(new SymbolTreeNode(element));
        }
    }

    public SymbolTableTreeNode getSymbolTableNode() {
        return this.symbolTableNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSymbolTable(SymbolTable table) {
        if (table == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        SymbolTable symbolTable = this;
        synchronized (symbolTable) {
            SymbolTable symbolTable2 = table;
            synchronized (symbolTable2) {
                Iterator iter = table.iterator();
                while (iter.hasNext()) {
                    Symbol element = (Symbol)iter.next();
                    this.get(new JSCTypeDef(element.NAME, element.type)).setJSCData(element.getJSCData());
                }
            }
        }
    }
}

