/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.model;

import com.jstatcom.model.JSCConstants;
import com.jstatcom.model.JSCDRange;
import com.jstatcom.model.JSCData;
import com.jstatcom.model.JSCDataEvent;
import com.jstatcom.model.JSCDataEventTypes;
import com.jstatcom.model.JSCDataListener;
import com.jstatcom.model.JSCDate;
import com.jstatcom.model.JSCInt;
import com.jstatcom.model.JSCNArray;
import com.jstatcom.model.JSCNumber;
import com.jstatcom.model.JSCSArray;
import com.jstatcom.model.JSCString;
import com.jstatcom.model.JSCTypeDef;
import com.jstatcom.model.JSCTypes;
import com.jstatcom.model.JSCVoid;
import com.jstatcom.model.SymbolEvent;
import com.jstatcom.model.SymbolEventSupport;
import com.jstatcom.model.SymbolEventTypes;
import com.jstatcom.model.SymbolListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javolution37.javolution.xml.XmlElement;
import javolution37.javolution.xml.XmlFormat;

public class Symbol
implements JSCDataListener,
Comparable {
    private SymbolEventSupport eventSupport = null;
    public final String name;
    public final String NAME;
    public final JSCTypes type;
    private final int hashCode;
    private JSCData data = null;
    private String description = "";
    public static final XmlFormat<Symbol> Symbol_XML = new XmlFormat<Symbol>(Symbol.class){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void format(Symbol data, XmlElement xml) {
            xml.setAttribute("name", data.name);
            1 var3_3 = this;
            synchronized (var3_3) {
                xml.add(data.data);
            }
        }

        @Override
        public Symbol parse(XmlElement xml) {
            String nam = xml.getAttribute("name") + "";
            JSCData data = (JSCData)xml.getNext();
            return new Symbol(nam, data);
        }
    };

    public Symbol(JSCData data) {
        this(data.name(), data);
    }

    public Symbol(String name, JSCData data) {
        if (name == null || data == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        JSCConstants.checkNameThrowEx(name);
        this.name = name;
        this.NAME = name.toUpperCase();
        this.type = data.type();
        this.hashCode = this.NAME.hashCode();
        this.setJSCData(data);
    }

    public Symbol(JSCTypeDef def) {
        this(def.name, def.type.valueOfEmpty(def.name));
        this.description = def.description;
    }

    public final synchronized void addSymbolListener(SymbolListener evtListener) {
        this.getEventSupport().addListener(evtListener, SymbolEventTypes.VALUE_CHANGED);
    }

    public final synchronized void addSymbolListener(SymbolListener evtListener, SymbolEventTypes evtType) {
        this.getEventSupport().addListener(evtListener, evtType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear() {
        JSCData ref;
        Symbol symbol = this;
        synchronized (symbol) {
            ref = this.data;
        }
        if (ref != null) {
            ref.clear();
        }
    }

    public final synchronized String display() {
        return this.data.display();
    }

    public final int compareTo(Object obj) {
        if (!(obj instanceof Symbol)) {
            throw new IllegalArgumentException("Argument " + obj + " not a Symbol.");
        }
        if (this.equals(obj)) {
            return 0;
        }
        return this.NAME.compareTo(((Symbol)obj).NAME);
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Symbol)) {
            return false;
        }
        return this.NAME.equals(((Symbol)obj).NAME);
    }

    public final String getDescription() {
        return this.description;
    }

    private SymbolEventSupport getEventSupport() {
        if (this.eventSupport == null) {
            this.eventSupport = new SymbolEventSupport();
        }
        return this.eventSupport;
    }

    public final synchronized JSCData getJSCData() {
        return this.data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final JSCDate getJSCDate() {
        JSCTypes toGet = JSCTypes.DATE;
        if (this.type != toGet) {
            throw new RuntimeException("Symbol type is " + this.type + " instead of " + toGet + " in " + this.toString() + ".");
        }
        Symbol symbol = this;
        synchronized (symbol) {
            return (JSCDate)this.data;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final JSCDRange getJSCDRange() {
        JSCTypes toGet = JSCTypes.DRANGE;
        if (this.type != toGet) {
            throw new RuntimeException("Symbol type is " + this.type + " instead of " + toGet + " in " + this.toString() + ".");
        }
        Symbol symbol = this;
        synchronized (symbol) {
            return (JSCDRange)this.data;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final JSCNArray getJSCNArray() {
        if (this.type != JSCTypes.NARRAY && this.type != JSCTypes.INT && this.type != JSCTypes.NUMBER) {
            throw new RuntimeException("Symbol type is " + this.type + " instead of " + JSCTypes.NARRAY + " or " + JSCTypes.NUMBER + " or " + JSCTypes.INT + " in " + this.toString() + ".");
        }
        Symbol symbol = this;
        synchronized (symbol) {
            if (this.type == JSCTypes.NARRAY) {
                return (JSCNArray)this.data;
            }
            if (this.data.isEmpty()) {
                return new JSCNArray(this.data.name());
            }
            if (this.type == JSCTypes.NUMBER) {
                return new JSCNArray(this.data.name(), ((JSCNumber)this.data).doubleVal());
            }
            return new JSCNArray(this.data.name(), ((JSCInt)this.data).intVal());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final JSCNumber getJSCNumber() {
        if (this.type != JSCTypes.NUMBER && this.type != JSCTypes.INT) {
            throw new RuntimeException("Symbol type is " + this.type + " instead of " + JSCTypes.NUMBER + " or " + JSCTypes.INT + " in " + this.toString() + ".");
        }
        Symbol symbol = this;
        synchronized (symbol) {
            if (this.type == JSCTypes.NUMBER) {
                return (JSCNumber)this.data;
            }
            if (this.data.isEmpty()) {
                return new JSCNumber(this.data.name());
            }
            return new JSCNumber(this.data.name(), ((JSCInt)this.data).intVal());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final JSCInt getJSCInt() {
        JSCTypes toGet = JSCTypes.INT;
        if (this.type != toGet) {
            throw new RuntimeException("Symbol type is " + this.type + " instead of " + toGet + " in " + this.toString() + ".");
        }
        Symbol symbol = this;
        synchronized (symbol) {
            return (JSCInt)this.data;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final JSCSArray getJSCSArray() {
        if (this.type != JSCTypes.SARRAY && this.type != JSCTypes.STRING) {
            throw new RuntimeException("Symbol type is " + this.type + " instead of " + JSCTypes.SARRAY + " or " + JSCTypes.STRING + " in " + this.toString() + ".");
        }
        Symbol symbol = this;
        synchronized (symbol) {
            if (this.type == JSCTypes.SARRAY) {
                return (JSCSArray)this.data;
            }
            if (this.data.isEmpty()) {
                return new JSCSArray(this.data.name());
            }
            return new JSCSArray(this.data.name(), ((JSCString)this.data).string());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final JSCString getJSCString() {
        if (this.type != JSCTypes.STRING && this.type != JSCTypes.SARRAY) {
            throw new RuntimeException("Symbol type is " + this.type + " instead of " + JSCTypes.STRING + " or " + JSCTypes.SARRAY + " in " + this.toString() + ".");
        }
        Symbol symbol = this;
        synchronized (symbol) {
            if (this.type == JSCTypes.STRING) {
                return (JSCString)this.data;
            }
            if (this.data.isEmpty()) {
                return new JSCString(this.data.name());
            }
            return new JSCString(this.data.name(), ((JSCSArray)this.data).stringAt(0, 0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final JSCVoid getJSCVoid() {
        JSCTypes toGet = JSCTypes.VOID;
        if (this.type != toGet) {
            throw new RuntimeException("Symbol type is " + this.type + " instead of " + toGet + " in " + this.toString() + ".");
        }
        Symbol symbol = this;
        synchronized (symbol) {
            return (JSCVoid)this.data;
        }
    }

    public final int hashCode() {
        return this.hashCode;
    }

    public final synchronized boolean isEmpty() {
        return this.data.isEmpty();
    }

    public synchronized void removeAllSymbolListeners() {
        this.eventSupport = null;
    }

    public final synchronized void removeSymbolListener(SymbolListener evtListener) {
        if (this.eventSupport == null) {
            return;
        }
        this.eventSupport.removeListener(evtListener);
    }

    public List getListenersForType(SymbolEventTypes evtType) {
        if (this.eventSupport == null) {
            return new ArrayList();
        }
        return this.eventSupport.getListenersForType(evtType);
    }

    public final void setDescription(String newDescription) {
        if (newDescription == null) {
            newDescription = "";
        }
        if (newDescription.indexOf("/*") > -1 || newDescription.indexOf("*/") > -1) {
            throw new IllegalArgumentException("Description \"" + newDescription + "\" contains /* or */.");
        }
        this.description = newDescription.trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setJSCData(JSCData newData) {
        if (newData == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        if (newData.type() != this.type) {
            throw new IllegalArgumentException("Argument type (" + newData.type() + ") different from symbol type (" + this.type + ") for symbol \"" + this.name + "\".");
        }
        JSCData oldData = null;
        boolean wasEmpty = false;
        Symbol symbol = this;
        synchronized (symbol) {
            if (this.data == newData) {
                return;
            }
            wasEmpty = this.data == null || this.data.isEmpty();
            oldData = this.data;
            this.data = newData;
            if (oldData != null) {
                oldData.removeJSCDataListener(this);
            }
            JSCDataEventTypes[] types = JSCDataEventTypes.getTypes();
            for (int i = 0; i < types.length; ++i) {
                JSCDataListener lst = new JSCDataListener(){

                    @Override
                    public void valueChanged(JSCDataEvent evt) {
                        Symbol.this.valueChanged(evt);
                    }
                };
                this.data.addJSCDataListener(lst, types[i]);
            }
        }
        if (this.eventSupport == null) {
            return;
        }
        if (wasEmpty && !this.isEmpty()) {
            this.eventSupport.dispatchEvent(SymbolEvent.valueOfEmptyState(this, false));
        }
        if (!wasEmpty && this.isEmpty()) {
            this.eventSupport.dispatchEvent(SymbolEvent.valueOfEmptyState(this, true));
        }
        if (this.eventSupport.getListenersForType(SymbolEventTypes.VALUE_CHANGED).size() == 0) {
            return;
        }
        if (!oldData.isEqual(newData)) {
            this.eventSupport.dispatchEvent(SymbolEvent.valueOfValChanged(this, oldData, newData));
        }
    }

    public final String toString() {
        return super.toString() + " [name=" + this.name + ",type=" + this.type + "]";
    }

    @Override
    public final void valueChanged(JSCDataEvent evt) {
        if (this.eventSupport == null) {
            return;
        }
        this.eventSupport.dispatchEvent(SymbolEvent.valueOfJSCDataEvent(this, evt));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copySymbol(Symbol source, Symbol target) {
        if (source == null || target == null) {
            throw new IllegalArgumentException("Argument was null");
        }
        if (source == target) {
            return;
        }
        Symbol symbol = source;
        synchronized (symbol) {
            if (!source.isEmpty()) {
                target.setJSCData(source.getJSCData());
            }
            Symbol symbol2 = target;
            synchronized (symbol2) {
                Iterator it = SymbolEventTypes.iterator();
                while (it.hasNext()) {
                    SymbolEventTypes evtType = (SymbolEventTypes)it.next();
                    List list = source.getListenersForType(evtType);
                    for (int i = 0; i < list.size(); ++i) {
                        target.addSymbolListener((SymbolListener)list.get(i), evtType);
                    }
                }
                if (target.getDescription().length() == 0) {
                    target.setDescription(source.getDescription());
                }
            }
            source.removeAllSymbolListeners();
        }
    }
}

