/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.model;

import com.jstatcom.model.AbstractJSCData;
import com.jstatcom.model.JSCConstants;
import com.jstatcom.model.JSCData;
import com.jstatcom.model.JSCDataEvent;
import com.jstatcom.model.JSCTypes;
import com.jstatcom.util.UString;
import javolution37.javolution.xml.XmlElement;
import javolution37.javolution.xml.XmlFormat;

public final class JSCInt
extends AbstractJSCData {
    private final String name;
    private Integer value = null;
    private JSCDataEvent clearEvent = null;
    private JSCDataEvent notEmptyEvent = null;
    public static final XmlFormat<JSCInt> JSCInt_XML = new XmlFormat<JSCInt>(JSCInt.class){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void format(JSCInt data, XmlElement xml) {
            xml.setAttribute("name", data.name);
            JSCInt jSCInt = data;
            synchronized (jSCInt) {
                xml.setAttribute("value", data.value + "");
            }
        }

        @Override
        public JSCInt parse(XmlElement xml) {
            String nam = xml.getAttribute("name") + "";
            String numberString = xml.getAttribute("value") + "";
            Double newNumber = null;
            if (!numberString.equalsIgnoreCase("null")) {
                newNumber = UString.parseToNumber(numberString);
            }
            Integer newInt = null;
            if (newNumber != null) {
                newInt = new Integer(newNumber.intValue());
            }
            return new JSCInt(nam, newInt);
        }
    };

    public JSCInt(String name) {
        this(name, null);
    }

    public JSCInt(String name, int value) {
        this(name, new Integer(value));
    }

    public JSCInt(String name, boolean value) {
        this(name, new Integer(value ? 1 : 0));
    }

    public JSCInt(String name, Integer value) {
        if (name == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        this.name = name = JSCConstants.checkNameThrowEx(name);
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Integer oldValue;
        JSCInt jSCInt = this;
        synchronized (jSCInt) {
            if (this.value == null) {
                return;
            }
            oldValue = this.value;
            this.value = null;
        }
        if (this.clearEvent == null) {
            this.clearEvent = JSCDataEvent.valueOfEmptyState(this, true);
        }
        if (this.eventSupport == null) {
            return;
        }
        this.getEventSupport().dispatchEvent(this.clearEvent);
        this.getEventSupport().dispatchEvent(JSCDataEvent.valueOfChanged(this, oldValue, null));
    }

    @Override
    public synchronized JSCInt copy() {
        return new JSCInt(this.name, this.value);
    }

    public synchronized double doubleVal() {
        if (this.value == null) {
            throw new IllegalStateException("JSCData is empty: " + this.toString() + ".");
        }
        return this.value.doubleValue();
    }

    public synchronized Integer getInt() {
        return this.value;
    }

    public synchronized int intVal() {
        if (this.value == null) {
            throw new IllegalStateException("JSCData is empty: " + this.toString() + ".");
        }
        return this.value;
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.value == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean isEqual(JSCData o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JSCInt)) {
            return false;
        }
        JSCInt otherNumber = (JSCInt)o;
        boolean ret = true;
        JSCInt jSCInt = this;
        synchronized (jSCInt) {
            JSCData jSCData = o;
            synchronized (jSCData) {
                ret = this.value != null ? this.value.equals(otherNumber.getInt()) : otherNumber.getInt() == null;
            }
        }
        return ret;
    }

    @Override
    public String name() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInt(Integer newValue) {
        if (newValue == null) {
            this.clear();
            return;
        }
        boolean wasEmpty = false;
        Integer oldValue = null;
        JSCInt jSCInt = this;
        synchronized (jSCInt) {
            if (newValue.equals(this.value)) {
                return;
            }
            wasEmpty = this.isEmpty();
            oldValue = this.value;
            this.value = newValue;
        }
        if (this.eventSupport == null) {
            return;
        }
        this.getEventSupport().dispatchEvent(JSCDataEvent.valueOfChanged(this, oldValue, newValue));
        if (wasEmpty) {
            if (this.notEmptyEvent == null) {
                this.notEmptyEvent = JSCDataEvent.valueOfEmptyState(this, false);
            }
            this.getEventSupport().dispatchEvent(this.notEmptyEvent);
        }
    }

    public void setVal(int newInt) {
        this.setInt(new Integer(newInt));
    }

    @Override
    public JSCTypes type() {
        return JSCTypes.INT;
    }

    @Override
    public synchronized Object value() {
        return this.value;
    }

    public synchronized boolean isNonZero() {
        if (this.value == null) {
            throw new IllegalStateException("JSCData is empty: " + this.toString() + ".");
        }
        return this.value != 0;
    }
}

