/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.model;

import com.jstatcom.model.AbstractJSCData;
import com.jstatcom.model.JSCConstants;
import com.jstatcom.model.JSCData;
import com.jstatcom.model.JSCDataEvent;
import com.jstatcom.model.JSCTypes;
import com.jstatcom.ts.TSDate;
import javolution37.javolution.xml.XmlElement;
import javolution37.javolution.xml.XmlFormat;

public final class JSCDate
extends AbstractJSCData {
    private TSDate tsDate = null;
    private final String name;
    private JSCDataEvent clearEvent = null;
    private JSCDataEvent notEmptyEvent = null;
    public static final XmlFormat<JSCDate> JSCDate_XML = new XmlFormat<JSCDate>(JSCDate.class){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void format(JSCDate data, XmlElement xml) {
            xml.setAttribute("name", data.name);
            JSCDate jSCDate = data;
            synchronized (jSCDate) {
                xml.setAttribute("value", data.tsDate + "");
            }
        }

        @Override
        public JSCDate parse(XmlElement xml) {
            String nam = xml.getAttribute("name") + "";
            String dateString = xml.getAttribute("value") + "";
            TSDate newDate = null;
            if (!dateString.equalsIgnoreCase("null")) {
                newDate = TSDate.valueOf(dateString);
            }
            return new JSCDate(nam, newDate);
        }
    };

    public JSCDate(String name) {
        this(name, null);
    }

    public JSCDate(String name, TSDate tsDate) {
        if (name == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        this.name = name = JSCConstants.checkNameThrowEx(name);
        this.tsDate = tsDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPeriods(int i) {
        TSDate oldValue = null;
        TSDate newValue = null;
        JSCDate jSCDate = this;
        synchronized (jSCDate) {
            if (this.tsDate == null) {
                throw new IllegalStateException("JSCDate is empty.");
            }
            if (i == 0) {
                return;
            }
            oldValue = this.tsDate;
            newValue = this.tsDate = this.tsDate.addPeriods(i);
        }
        if (this.eventSupport == null) {
            return;
        }
        this.getEventSupport().dispatchEvent(JSCDataEvent.valueOfChanged(this, oldValue, newValue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        TSDate oldValue;
        JSCDate jSCDate = this;
        synchronized (jSCDate) {
            if (this.tsDate == null) {
                return;
            }
            oldValue = this.tsDate;
            this.tsDate = null;
        }
        if (this.eventSupport == null) {
            return;
        }
        if (this.clearEvent == null) {
            this.clearEvent = JSCDataEvent.valueOfEmptyState(this, true);
        }
        if (this.eventSupport == null) {
            return;
        }
        this.getEventSupport().dispatchEvent(this.clearEvent);
        this.getEventSupport().dispatchEvent(JSCDataEvent.valueOfChanged(this, oldValue, null));
    }

    @Override
    public synchronized JSCDate copy() {
        return new JSCDate(this.name, this.tsDate);
    }

    public synchronized TSDate getTSDate() {
        return this.tsDate;
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.tsDate == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEqual(JSCData o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JSCDate)) {
            return false;
        }
        JSCDate otherDate = (JSCDate)o;
        boolean ret = true;
        JSCDate jSCDate = this;
        synchronized (jSCDate) {
            JSCData jSCData = o;
            synchronized (jSCData) {
                ret = this.tsDate != null ? this.tsDate.equals(otherDate.getTSDate()) : otherDate.getTSDate() == null;
            }
        }
        return ret;
    }

    @Override
    public String name() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVal(TSDate newDate) {
        if (newDate == null) {
            this.clear();
            return;
        }
        boolean wasEmpty = false;
        TSDate oldValue = null;
        JSCDate jSCDate = this;
        synchronized (jSCDate) {
            if (newDate.equals(this.tsDate)) {
                return;
            }
            wasEmpty = this.isEmpty();
            oldValue = this.tsDate;
            this.tsDate = newDate;
        }
        if (this.eventSupport == null) {
            return;
        }
        this.getEventSupport().dispatchEvent(JSCDataEvent.valueOfChanged(this, oldValue, newDate));
        if (wasEmpty) {
            if (this.notEmptyEvent == null) {
                this.notEmptyEvent = JSCDataEvent.valueOfEmptyState(this, false);
            }
            this.getEventSupport().dispatchEvent(this.notEmptyEvent);
        }
    }

    @Override
    public JSCTypes type() {
        return JSCTypes.DATE;
    }

    @Override
    public synchronized Object value() {
        return this.tsDate;
    }
}

