/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.engine.matlab;

import com.jstatcom.engine.ConfigHolder;
import com.jstatcom.engine.Engine;
import com.jstatcom.engine.EngineTypes;
import com.jstatcom.engine.LoadTypes;
import com.jstatcom.engine.matlab.LogHandler;
import com.jstatcom.engine.matlab.MatlabConfigKeys;
import com.jstatcom.engine.matlab.MatlabLoadTypes;
import com.jstatcom.engine.matlab.OutErrHandler;
import com.jstatcom.model.JSCData;
import com.jstatcom.model.JSCInt;
import com.jstatcom.model.JSCNArray;
import com.jstatcom.model.JSCNumber;
import com.jstatcom.model.JSCSArray;
import com.jstatcom.model.JSCString;
import com.jstatcom.model.JSCTypes;
import java.io.File;
import org.apache.log4j.Logger;

public final class MatlabEngine
implements Engine {
    private static final Logger log = Logger.getLogger(MatlabEngine.class);
    private OutErrHandler outErrHandler = new LogHandler();
    private ConfigHolder cf = ConfigHolder.valueOf(EngineTypes.MATLAB);
    private static MatlabEngine mlabMaster = null;
    private String modName = null;
    private String systemLib = null;

    private MatlabEngine() {
        String compiler_version = this.cf.getConfig(MatlabConfigKeys.MATLAB_COMPILER_VERSION);
        int sharedMemSize = Integer.parseInt(this.cf.getConfig(MatlabConfigKeys.SHARED_MEM_SIZE));
        if (!compiler_version.startsWith("4")) {
            throw new RuntimeException("Only Compiler Version 4 is supperted.");
        }
        String mlabLib = EngineTypes.MATLAB.DIR_NAME + File.separator + System.mapLibraryName("jmlabmaster");
        File f = new File(mlabLib);
        if (!f.isFile()) {
            throw new RuntimeException("The system library " + f.getAbsolutePath() + " does not exist.");
        }
        try {
            Runtime.getRuntime().load(f.getAbsolutePath());
        }
        catch (Throwable ex) {
            throw new RuntimeException("Could not load system library: " + f.getAbsolutePath(), ex);
        }
        String dllName = this.cf.getConfig(MatlabConfigKeys.DLL_NAME);
        String runtimeSubDir = this.cf.getConfig(MatlabConfigKeys.RUNTIME_SUBDIR);
        String rtn = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("init Matlab with shared memory size " + sharedMemSize));
            }
            rtn = this.initMLabMasterEx(sharedMemSize, dllName, runtimeSubDir);
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
        if (rtn != null) {
            throw new RuntimeException("Error initializing \"" + f.getAbsolutePath() + "\":\n" + rtn);
        }
    }

    public static MatlabEngine getInstance() {
        if (mlabMaster == null) {
            mlabMaster = new MatlabEngine();
        }
        return mlabMaster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void call(String procName, JSCData[] args, JSCData[] retData) {
        if (procName == null || procName.length() == 0) {
            throw new IllegalArgumentException("Procedure name was empty.");
        }
        if (args == null) {
            args = new JSCData[]{};
        }
        if (retData == null) {
            retData = new JSCData[]{};
        }
        procName = "mlx" + procName.substring(0, 1).toUpperCase() + procName.substring(1);
        MatlabEngine matlabEngine = this;
        synchronized (matlabEngine) {
            this.write(args);
            this.executeMLabProc(procName, retData.length);
            this.read(retData);
        }
    }

    private void executeMLabProc(String procName, int rtnArgs) {
        if (procName == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        if (rtnArgs < 0) {
            throw new IllegalArgumentException("Negative number of returns.");
        }
        String error = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("call: " + procName));
        }
        if ((error = this.setRtnArgsLengthEx(rtnArgs)) != null) {
            throw new RuntimeException("Error setting return arg length:\n" + error);
        }
        error = this.callMLabProcEx(procName);
        if (error != null) {
            throw new RuntimeException("Error executing \"" + procName + "\":\n" + error);
        }
    }

    @Override
    public boolean isValid(JSCTypes type) {
        return type == JSCTypes.NARRAY || type == JSCTypes.NUMBER || type == JSCTypes.INT || type == JSCTypes.STRING || type == JSCTypes.SARRAY;
    }

    @Override
    public void load(String module, LoadTypes loadType, JSCData ... args) {
        if (module == null || loadType == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        if (module.length() == 0) {
            throw new IllegalArgumentException("Library name was empty.");
        }
        this.modName = module.toLowerCase();
        if (loadType == MatlabLoadTypes.USERLIB) {
            File f = new File(EngineTypes.MATLAB.DIR_NAME + File.separator + System.mapLibraryName(this.modName));
            if (!f.isFile()) {
                throw new RuntimeException("The system library " + f.getAbsolutePath() + " does not exist.");
            }
            this.systemLib = f.getAbsolutePath();
            String error = this.loadMLabLibraryEx(this.systemLib);
            if (error != null) {
                throw new RuntimeException("Error loading Matlab module \"" + this.systemLib + "\":\n" + error);
            }
        }
    }

    public String getCurrentSysLib() {
        return this.systemLib;
    }

    @Override
    public void stop() {
        String error = null;
        error = this.stopEx();
        if (error != null) {
            throw new RuntimeException(error);
        }
    }

    @Override
    public void shutdown() {
    }

    private void write(JSCData[] engineData) {
        if (engineData == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        String error = null;
        error = this.setInArgsLengthEx(engineData.length);
        if (error != null) {
            throw new RuntimeException("Error setting input args length:\n" + error);
        }
        for (int i = 0; i < engineData.length; ++i) {
            JSCTypes type;
            JSCData data = engineData[i];
            if (data == null) {
                throw new IllegalArgumentException("Argument at array position [" + i + "] (zero based) was null.");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("write: " + data));
            }
            if (!this.isValid(type = data.type())) {
                throw new IllegalArgumentException("Argument type " + type + " at array position [" + i + "] (zero based) cannot be handled by MatlabEngine.");
            }
            if (data.isEmpty()) {
                error = this.writeEmptyDataEx();
                if (error == null) continue;
                throw new RuntimeException("Error writing empty \"" + data.name() + "\":\n" + error);
            }
            if (!(type == JSCTypes.NARRAY ? (error = this.writeDoubleArrayEx((double[][])data.value())) != null : (type == JSCTypes.NUMBER ? (error = this.writeDoubleEx((Double)data.value())) != null : (type == JSCTypes.INT ? (error = this.writeIntEx((Integer)data.value())) != null : (type == JSCTypes.SARRAY ? (error = this.writeStringArrayEx((String[][])data.value())) != null : type == JSCTypes.STRING && (error = this.writeStringEx((String)data.value())) != null))))) continue;
            throw new RuntimeException("Error writing \"" + data.name() + "\":\n" + error);
        }
    }

    private void read(JSCData[] rtArray) {
        if (rtArray == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        for (int i = 0; i < rtArray.length; ++i) {
            if (rtArray[i] == null) {
                throw new IllegalArgumentException("Return at array position [" + i + "] (zero based) was null.");
            }
            JSCTypes type = rtArray[i].type();
            String name = rtArray[i].name();
            if (!this.isValid(type)) {
                throw new IllegalArgumentException("Return type " + type + " at array position [" + i + "] (zero based) cannot be handled by Matlab.");
            }
            try {
                Object rtn;
                if (type == JSCTypes.NARRAY) {
                    rtn = null;
                    rtn = this.readDoubleArrayEx();
                    if (rtn == null) {
                        rtArray[i].clear();
                    } else {
                        ((JSCNArray)rtArray[i]).setVal((double[][])rtn);
                    }
                } else if (type == JSCTypes.SARRAY) {
                    rtn = null;
                    String[][] stringArray = this.readStringArrayEx();
                    rtn = stringArray;
                    if (stringArray == null) {
                        rtArray[i].clear();
                    } else {
                        ((JSCSArray)rtArray[i]).setVal((String[][])rtn);
                    }
                } else if (type == JSCTypes.NUMBER || type == JSCTypes.INT) {
                    rtn = null;
                    Double d = this.readDoubleEx();
                    rtn = d;
                    if (d == null) {
                        rtArray[i].clear();
                    } else if (type == JSCTypes.NUMBER) {
                        ((JSCNumber)rtArray[i]).setVal(rtn.doubleValue());
                    } else {
                        if ((double)rtn.intValue() != rtn.doubleValue()) {
                            log.warn((Object)("Matlab return \"" + name + "\": Converting double " + rtn + " to integer."));
                        }
                        ((JSCInt)rtArray[i]).setVal(rtn.intValue());
                    }
                } else if (type == JSCTypes.STRING) {
                    rtn = null;
                    String string = this.readStringEx();
                    rtn = string;
                    if (string == null) {
                        rtArray[i].clear();
                    } else {
                        ((JSCString)rtArray[i]).setVal((String)rtn);
                    }
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("read " + rtArray[i]));
                continue;
            }
            catch (Throwable ex) {
                throw new RuntimeException("Reading variable \"" + name + "\" failed with error message:\n" + ex.getMessage());
            }
        }
    }

    private native String writeDoubleArrayEx(double[][] var1);

    private native String writeStringArrayEx(String[][] var1);

    private native String writeStringEx(String var1);

    private native String writeDoubleEx(double var1);

    private native String writeIntEx(int var1);

    private native String setInArgsLengthEx(int var1);

    private native String setRtnArgsLengthEx(int var1);

    private native String stopEx();

    private native String callMLabProcEx(String var1);

    private native String loadMLabLibraryEx(String var1);

    private native String initMLabMasterEx(int var1, String var2, String var3);

    private native String writeEmptyDataEx();

    private native Double readDoubleEx();

    private native double[][] readDoubleArrayEx();

    private native String readStringEx();

    private native String[][] readStringArrayEx();

    void printOutCallBack(String s) {
        this.outErrHandler.handleOutput(s);
    }

    void printErrCallBack(String s) {
        this.outErrHandler.handleError(s);
    }

    public void setOutErrHandler(OutErrHandler outErrHandler) {
        if (outErrHandler == null) {
            throw new IllegalArgumentException("Argument was null.");
        }
        this.outErrHandler = outErrHandler;
    }
}

