/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.engine.gauss;

import com.jstatcom.engine.ConfigKeys;
import com.jstatcom.model.JSCConstants;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public abstract class GaussConfigKeys
extends ConfigKeys {
    private static String[] validKeys = new String[]{"3.2", "3.5", "3.6", "4.0", "5.0", "6.0", "7.0", "8.0"};
    public static final GaussConfigKeys EXE_LOCATION = new GaussConfigKeys("EXE_LOCATION"){

        @Override
        public String isValid(String value) {
            if (value == null) {
                return this.toString() + " cannot be null.";
            }
            if (new File(value).exists()) {
                return null;
            }
            return "\"" + value + "\" does not seem to be a valid GAUSS directory.";
        }

        @Override
        public String defaultVal() {
            return "";
        }
    };
    public static final GaussConfigKeys GAUSS_VERSION = new GaussConfigKeys("GAUSS_VERSION"){

        @Override
        public String isValid(String value) {
            if (value == null) {
                return this.toString() + " cannot be null.";
            }
            for (int i = 0; i < validKeys.length; ++i) {
                if (!value.equals(validKeys[i])) continue;
                return null;
            }
            return "\"" + value + "\" is not in the list of valid GAUSS versions " + Arrays.asList(validKeys).toString() + ".";
        }

        @Override
        public String defaultVal() {
            return "6.0";
        }
    };
    public static final GaussConfigKeys SHARED_MEM_SIZE = new GaussConfigKeys("SHARED_MEM_SIZE"){

        @Override
        public String isValid(String value) {
            if (value == null) {
                return this.toString() + " cannot be null.";
            }
            int number = 0;
            int lowerBound = 1000;
            int upperBound = 1000000000;
            try {
                number = Integer.parseInt(value);
            }
            catch (NumberFormatException nEx) {
                return "\"" + value + "\" is not a valid integer number.";
            }
            if (number < lowerBound || number > upperBound) {
                return "\"" + value + "\" is not in the valid range of [" + lowerBound + ";" + upperBound + "].\nA reasonable default value is 800000.";
            }
            return null;
        }

        @Override
        public String defaultVal() {
            return "800000";
        }
    };
    public static final GaussConfigKeys TEMP_DIR = new GaussConfigKeys("TEMP_DIR"){

        @Override
        public String isValid(String value) {
            if (value == null) {
                return this.toString() + " cannot be null.";
            }
            if (value.length() == 0) {
                value = JSCConstants.getSystemTemp();
                return null;
            }
            if (!new File(value).isDirectory()) {
                return "Temporary directory \"" + value + "\" is not a directory.";
            }
            File file = new File(value + "/tmp.tmp");
            if (file.canWrite()) {
                return null;
            }
            try {
                if (file.createNewFile()) {
                    file.delete();
                    return null;
                }
                return "No write permission to \"" + value + "\".";
            }
            catch (IOException ioEx) {
                return "No write permission to \"" + value + "\".";
            }
        }

        @Override
        public String defaultVal() {
            return "";
        }
    };
    public static final GaussConfigKeys LIB_CFG = new GaussConfigKeys("LIB_CFG"){

        @Override
        public String isValid(String value) {
            if (value == null) {
                return this.toString() + " cannot be null.";
            }
            return null;
        }

        @Override
        public String defaultVal() {
            return "lib.xml";
        }
    };
    public static final GaussConfigKeys COMPILE_CFG = new GaussConfigKeys("COMPILE_CFG"){

        @Override
        public String isValid(String value) {
            if (value == null) {
                return this.toString() + " cannot be null.";
            }
            return null;
        }

        @Override
        public String defaultVal() {
            return "compile.xml";
        }
    };
    public static final GaussConfigKeys GCG_FILENAME = new GaussConfigKeys("GCG_FILENAME"){

        @Override
        public String isValid(String value) {
            if (value == null) {
                return this.toString() + " cannot be empty.";
            }
            return null;
        }

        @Override
        public String defaultVal() {
            return "jgauss.gcg";
        }
    };

    GaussConfigKeys(String name) {
        super(name);
    }

    public static Iterator versionIterator() {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < validKeys.length; ++i) {
            list.add(validKeys[i]);
        }
        return list.iterator();
    }
}

