/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.engine.gauss;

import com.jstatcom.component.StdMessages;
import com.jstatcom.engine.ConfigHolder;
import com.jstatcom.engine.EngineTypes;
import com.jstatcom.engine.gauss.GaussConfigKeys;
import com.jstatcom.engine.gauss.GaussEngine;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javolution37.javolution.xml.XmlElement;
import javolution37.javolution.xml.XmlFormat;
import org.apache.log4j.Logger;

public final class GCGSet {
    private static final Logger log = Logger.getLogger(GCGSet.class);
    public final String GCG_NAME;
    public final String LIBS;
    private final List<String> fileList = new ArrayList<String>();
    public static final XmlFormat<GCGSet> GCGSet_XML = new XmlFormat<GCGSet>(GCGSet.class){

        @Override
        public void format(GCGSet data, XmlElement xml) {
            xml.setAttribute("gcgfile", data.GCG_NAME);
            xml.setAttribute("libs", data.LIBS);
            Iterator it = data.fileList.iterator();
            while (it.hasNext()) {
                xml.add(new SRCFile(it.next() + ""));
            }
        }

        @Override
        public GCGSet parse(XmlElement xml) {
            String gcgNam = xml.getAttribute("gcgfile") + "";
            String libraries = xml.getAttribute("libs") + "";
            GCGSet newSet = new GCGSet(gcgNam, libraries);
            while (xml.hasNext()) {
                SRCFile file = (SRCFile)xml.getNext();
                newSet.addSRCFile(file.srcFile);
            }
            return newSet;
        }
    };

    public GCGSet(String gcgName, String libraries) {
        if (gcgName == null) {
            throw new RuntimeException("\nGCG name was null.");
        }
        this.GCG_NAME = gcgName;
        this.LIBS = libraries;
    }

    public void addSRCFile(String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("\nFilename was null.");
        }
        String fName = fileName.toString().trim();
        File srcFile = new File(EngineTypes.GAUSS.DIR_NAME + "/" + fName);
        String toAdd = srcFile.getAbsolutePath();
        if (!srcFile.isFile()) {
            throw new RuntimeException("\nFile \"" + toAdd + "\" does not exist.");
        }
        if (toAdd.indexOf(" ") > 0 && ConfigHolder.valueOf(EngineTypes.GAUSS).getConfig(GaussConfigKeys.GAUSS_VERSION).equals("3.2")) {
            throw new RuntimeException("\nFilename \"" + toAdd + "\" contains whitespace characters.");
        }
        if (!this.fileList.contains(fName)) {
            this.fileList.add(fName);
        }
    }

    public Iterator iterator() {
        return this.fileList.iterator();
    }

    public static void main(String[] args) {
        GaussEngine gauss = GaussEngine.getInstance();
        gauss.start(false);
        String error = null;
        if (gauss != null) {
            error = gauss.compileGCG();
            if (error != null) {
                StdMessages.error(error, "GAUSS Compile Error");
                System.exit(0);
            } else {
                StdMessages.infoGeneral("GAUSS gcg file compilation finished ok.");
                System.exit(0);
            }
        } else {
            log.error((Object)"GAUSS could not be initialized, compilation failed.");
        }
    }

    public static class SRCFile {
        final String srcFile;
        public static final XmlFormat<SRCFile> SRCFile_XML = new XmlFormat<SRCFile>(SRCFile.class){

            @Override
            public void format(SRCFile data, XmlElement xml) {
                xml.setAttribute("filename", data.srcFile);
            }

            @Override
            public SRCFile parse(XmlElement xml) {
                String srcFile = xml.getAttribute("filename") + "";
                return new SRCFile(srcFile);
            }
        };

        public SRCFile(String srcFile) {
            this.srcFile = srcFile;
        }
    }
}

