/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.engine;

import com.jstatcom.component.ResultField;
import com.jstatcom.component.StdMessages;
import com.jstatcom.engine.AbstractConfigPanel;
import com.jstatcom.engine.ConfigHolder;
import java.awt.Component;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import javax.swing.BoxLayout;
import javolution37.javolution.xml.ObjectReader;
import javolution37.javolution.xml.ObjectWriter;
import org.apache.log4j.Logger;

public final class DefaultConfigPanel
extends AbstractConfigPanel {
    private static final Logger log = Logger.getLogger(DefaultConfigPanel.class);
    private ResultField ivjXMLField = null;

    public DefaultConfigPanel() {
        this.initialize();
    }

    private ResultField getXMLField() {
        if (this.ivjXMLField == null) {
            try {
                this.ivjXMLField = new ResultField();
                this.ivjXMLField.setName("XMLField");
            }
            catch (Throwable ivjExc) {
                log.error((Object)"Error setting text field", ivjExc);
            }
        }
        return this.ivjXMLField;
    }

    private void initialize() {
        try {
            this.setName("DefaultConfigPanel");
            this.setLayout(new BoxLayout(this, 0));
            this.setSize(687, 479);
            this.add((Component)this.getXMLField(), this.getXMLField().getName());
        }
        catch (Throwable ivjExc) {
            log.error((Object)"Error initializing", ivjExc);
        }
    }

    @Override
    public void setConfig(ConfigHolder configHolder) {
        ObjectWriter<ConfigHolder> objectWriter = new ObjectWriter<ConfigHolder>();
        objectWriter.setPackagePrefix("", "com.jstatcom.engine");
        objectWriter.setPackagePrefix("jstatcom", "com.jstatcom");
        StringWriter sWriter = new StringWriter();
        try {
            objectWriter.write(configHolder, sWriter);
        }
        catch (IOException ex) {
            String msg = "Configuration settings for engine of type " + configHolder.getEngineType() + " could not be displayed.";
            log.error((Object)msg, (Throwable)ex);
            StdMessages.error(msg + "\nPlease check log for further details.", "Error");
        }
        this.getXMLField().setText(((Object)sWriter).toString());
    }

    @Override
    public String storeConfig(ConfigHolder configHolder) {
        ObjectReader constructor = new ObjectReader();
        try {
            configHolder = (ConfigHolder)constructor.read(new StringReader(this.getXMLField().getText()));
        }
        catch (Throwable ex) {
            return "Configuration settings could not be read.\nThe following error occured:\n\n" + ex.getMessage() + "\n\n";
        }
        return null;
    }
}

