/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.component;

import com.jstatcom.component.MultiLineLabel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.apache.log4j.Logger;

public class TopFrameAboutBox
extends JDialog {
    private static final Logger log = Logger.getLogger(TopFrameAboutBox.class);
    private final String display;
    private final String version;
    private final String image;
    private final String licenseFile;
    private JLabel label = null;
    private JTabbedPane tabPane = null;
    private MultiLineLabel infoArea = null;

    public TopFrameAboutBox(Frame owner, String title, String version, String display, String image, String licenseFile) {
        super(owner, title, true);
        this.version = version;
        this.display = display;
        this.image = image;
        this.licenseFile = licenseFile;
        this.initialize();
    }

    private JLabel getLabel() {
        if (this.label == null) {
            this.label = new JLabel("");
            this.label.setBackground(Color.white);
            this.label.setHorizontalAlignment(0);
            this.label.setVerticalAlignment(1);
            URL url = this.getClass().getResource(this.image);
            if (url != null) {
                this.label.setIcon(new ImageIcon(url));
            }
        }
        return this.label;
    }

    protected MultiLineLabel getInfoArea() {
        if (this.infoArea == null) {
            this.infoArea = new MultiLineLabel();
            this.infoArea.setText("version: " + this.version);
            this.infoArea.setHorizontalAlignment(0);
            this.infoArea.setVerticalAlignment(1);
            this.infoArea.setMinimumSize(new Dimension(45, 30));
            this.infoArea.setBackground(Color.white);
        }
        return this.infoArea;
    }

    private void addAuthorInfoArea() {
        JTextArea textArea = new JTextArea();
        textArea.setEditable(false);
        JScrollPane scroller = new JScrollPane(textArea);
        textArea.setMargin(new Insets(5, 5, 5, 5));
        textArea.setText(this.display);
        scroller.setName("Info");
        this.tabPane.add(scroller);
    }

    private void addLicenseArea() {
        final JTextPane textPane = new JTextPane();
        textPane.setEditable(false);
        JScrollPane scroller = new JScrollPane(textPane);
        textPane.setMargin(new Insets(5, 5, 5, 5));
        try {
            textPane.setPage(new File(this.licenseFile).toURI().toURL());
        }
        catch (IOException e) {
            log.error((Object)"Setting license failed", (Throwable)e);
        }
        textPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                try {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        textPane.setPage(e.getURL());
                    }
                }
                catch (Throwable ex) {
                    log.error((Object)"text pane updated failed", ex);
                }
            }
        });
        scroller.setName("License");
        this.tabPane.add(scroller);
    }

    private void initialize() {
        this.setSize(385, 360);
        this.setLocationRelativeTo(this.getParent());
        JPanel contentPane = new JPanel(new BorderLayout());
        this.tabPane = new JTabbedPane();
        JPanel displayPane = new JPanel();
        displayPane.setLayout(new GridBagLayout());
        displayPane.setBackground(Color.white);
        GridBagConstraints constraintsJLabel1 = new GridBagConstraints();
        constraintsJLabel1.gridx = 0;
        constraintsJLabel1.gridy = 0;
        constraintsJLabel1.gridwidth = 1;
        constraintsJLabel1.fill = 1;
        displayPane.add((Component)this.getLabel(), constraintsJLabel1);
        GridBagConstraints constraintsInfoArea = new GridBagConstraints();
        constraintsInfoArea.gridx = 0;
        constraintsInfoArea.gridy = 1;
        constraintsInfoArea.weightx = 1.0;
        constraintsInfoArea.weighty = 1.0;
        constraintsInfoArea.fill = 1;
        constraintsInfoArea.insets = new Insets(10, 20, 5, 5);
        displayPane.add((Component)this.getInfoArea(), constraintsInfoArea);
        displayPane.setName("Version");
        this.tabPane.add(displayPane);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                TopFrameAboutBox.this.tabPane.setSelectedIndex(0);
            }
        });
        this.addAuthorInfoArea();
        this.addLicenseArea();
        contentPane.add((Component)this.tabPane, "Center");
        contentPane.setBackground(Color.white);
        this.setContentPane(contentPane);
    }
}

