/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.component;

import java.awt.Component;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.help.CSH;
import javolution37.javolution.xml.ObjectReader;
import javolution37.javolution.xml.XmlElement;
import javolution37.javolution.xml.XmlFormat;

public final class JHelpContextMgr {
    public static final String helpIDFile = "help_context.xml";
    private final Map<String, String> map = new HashMap<String, String>();
    private static JHelpContextMgr instance = null;
    public static final XmlFormat<JHelpContextMgr> JHelpContextMgr_XML = new XmlFormat<JHelpContextMgr>(JHelpContextMgr.class){

        @Override
        public void format(JHelpContextMgr data, XmlElement xml) {
            for (String key : data.map.keySet()) {
                xml.add(new ContextID(key, (String)data.map.get(key) + ""));
            }
        }

        @Override
        public JHelpContextMgr parse(XmlElement xml) {
            JHelpContextMgr mgr = new JHelpContextMgr();
            while (xml.hasNext()) {
                ContextID id = (ContextID)xml.getNext();
                mgr.map.put(id.compname, id.helpid);
            }
            return mgr;
        }
    };

    private JHelpContextMgr() {
    }

    public static void register(Component comp) {
        String helpID;
        if (comp == null) {
            throw new IllegalArgumentException("Component was null.");
        }
        if (instance == null) {
            URL url = comp.getClass().getResource("/help_context.xml");
            try {
                if (url != null) {
                    ObjectReader constructor = new ObjectReader();
                    instance = (JHelpContextMgr)constructor.read(url.openStream());
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (instance == null) {
                instance = new JHelpContextMgr();
                return;
            }
        }
        if ((helpID = JHelpContextMgr.instance.map.get(comp.getClass().getName())) != null) {
            CSH.setHelpIDString((Component)comp, (String)helpID.toString());
        }
    }

    public Iterator<String> compNames() {
        return this.map.keySet().iterator();
    }

    public String getID(Object key) {
        String k = key + "";
        String rt = this.map.get(k);
        if (rt == null) {
            return null;
        }
        return rt.toString();
    }

    public static class ContextID {
        final String helpid;
        final String compname;
        public static final XmlFormat<ContextID> ContextID_XML = new XmlFormat<ContextID>(ContextID.class){

            @Override
            public void format(ContextID data, XmlElement xml) {
                xml.setAttribute("class", data.compname);
                xml.setAttribute("helpid", data.helpid);
            }

            @Override
            public ContextID parse(XmlElement xml) {
                String comp = xml.getAttribute("class") + "";
                String id = xml.getAttribute("helpid") + "";
                return new ContextID(comp, id);
            }
        };

        public ContextID(String key, String helpid) {
            this.helpid = helpid;
            this.compname = key;
        }
    }
}

