/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ActionMap;
import javax.swing.JMenu;
import javax.swing.JToolBar;
import javax.swing.filechooser.FileFilter;
import org.jhotdraw.app.Application;
import org.jhotdraw.app.DefaultApplicationModel;
import org.jhotdraw.app.DefaultMenuBuilder;
import org.jhotdraw.app.MenuBuilder;
import org.jhotdraw.app.View;
import org.jhotdraw.app.action.edit.ClearSelectionAction;
import org.jhotdraw.app.action.file.ExportFileAction;
import org.jhotdraw.draw.DefaultDrawingEditor;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.GridConstrainer;
import org.jhotdraw.draw.action.BringToFrontAction;
import org.jhotdraw.draw.action.GroupAction;
import org.jhotdraw.draw.action.SelectSameAction;
import org.jhotdraw.draw.action.SendToBackAction;
import org.jhotdraw.draw.action.UngroupAction;
import org.jhotdraw.draw.io.InputFormat;
import org.jhotdraw.draw.io.OutputFormat;
import org.jhotdraw.gui.JFileURIChooser;
import org.jhotdraw.gui.URIChooser;
import org.jhotdraw.samples.svg.SVGView;
import org.jhotdraw.samples.svg.action.CombineAction;
import org.jhotdraw.samples.svg.action.SplitAction;
import org.jhotdraw.samples.svg.action.ViewSourceAction;
import org.jhotdraw.samples.svg.figures.SVGGroupFigure;

public class SVGApplicationModel
extends DefaultApplicationModel {
    public static final String INPUT_FORMAT_MAP_CLIENT_PROPERTY = "InputFormatMap";
    public static final String OUTPUT_FORMAT_MAP_CLIENT_PROPERTY = "OutputFormatMap";
    private static final double[] scaleFactors = new double[]{5.0, 4.0, 3.0, 2.0, 1.5, 1.25, 1.0, 0.75, 0.5, 0.25, 0.1};
    private GridConstrainer gridConstrainer = new GridConstrainer(12.0, 12.0);
    private DefaultDrawingEditor sharedEditor;

    public DefaultDrawingEditor getSharedEditor() {
        if (this.sharedEditor == null) {
            this.sharedEditor = new DefaultDrawingEditor();
        }
        return this.sharedEditor;
    }

    @Override
    public void initView(Application a, View view) {
        DefaultDrawingEditor editor;
        SVGView v = (SVGView)view;
        if (a.isSharingToolsAmongViews()) {
            editor = this.getSharedEditor();
            v.setEditor(editor);
        } else {
            editor = new DefaultDrawingEditor();
            v.setEditor(editor);
        }
        ActionMap m = view.getActionMap();
        m.put("edit.selectSame", new SelectSameAction(editor));
        m.put("edit.groupSelection", new GroupAction(editor, new SVGGroupFigure()));
        m.put("edit.ungroupSelection", new UngroupAction(editor, new SVGGroupFigure()));
        m.put("edit.combinePaths", new CombineAction(editor));
        m.put("edit.splitPath", new SplitAction(editor));
        m.put("edit.bringToFront", new BringToFrontAction(editor));
        m.put("edit.sendToBack", new SendToBackAction(editor));
    }

    @Override
    public ActionMap createActionMap(Application a, @Nullable View view) {
        SVGView v = (SVGView)view;
        ActionMap m = super.createActionMap(a, v);
        m.put("edit.clearSelection", new ClearSelectionAction());
        m.put("view.viewSource", new ViewSourceAction(a, v));
        m.put("file.export", new ExportFileAction(a, v));
        if (v instanceof SVGView) {
            SVGView svgView = v;
            m.put("edit.undo", svgView.getUndoManager().getUndoAction());
            m.put("edit.redo", svgView.getUndoManager().getRedoAction());
        }
        DrawingEditor editor = a.isSharingToolsAmongViews() ? this.getSharedEditor() : (v == null ? null : v.getEditor());
        m.put("edit.selectSame", new SelectSameAction(editor));
        m.put("edit.groupSelection", new GroupAction(editor, new SVGGroupFigure()));
        m.put("edit.ungroupSelection", new UngroupAction(editor, new SVGGroupFigure()));
        m.put("edit.combinePaths", new CombineAction(editor));
        m.put("edit.splitPath", new SplitAction(editor));
        m.put("edit.bringToFront", new BringToFrontAction(editor));
        m.put("edit.sendToBack", new SendToBackAction(editor));
        return m;
    }

    @Override
    protected MenuBuilder createMenuBuilder() {
        return new DefaultMenuBuilder(){

            @Override
            public void addSelectionItems(JMenu m, Application app, @Nullable View v) {
                ActionMap am = app.getActionMap(v);
                super.addSelectionItems(m, app, v);
                m.add(am.get("edit.selectSame"));
            }

            @Override
            public void addOtherEditItems(JMenu m, Application app, @Nullable View v) {
                ActionMap am = app.getActionMap(v);
                m.add(am.get("edit.groupSelection"));
                m.add(am.get("edit.ungroupSelection"));
                m.add(am.get("edit.combinePaths"));
                m.add(am.get("edit.splitPath"));
                m.addSeparator();
                m.add(am.get("edit.bringToFront"));
                m.add(am.get("edit.sendToBack"));
            }

            @Override
            public void addOtherViewItems(JMenu m, Application app, @Nullable View v) {
                ActionMap am = app.getActionMap(v);
                m.add(am.get("view.viewSource"));
            }
        };
    }

    @Override
    public List<JToolBar> createToolBars(Application app, @Nullable View p) {
        LinkedList<JToolBar> list = new LinkedList<JToolBar>();
        return list;
    }

    @Override
    public URIChooser createOpenChooser(Application a, @Nullable View v) {
        Drawing d;
        final JFileURIChooser c = new JFileURIChooser();
        final HashMap<FileFilter, InputFormat> fileFilterInputFormatMap = new HashMap<FileFilter, InputFormat>();
        c.putClientProperty(INPUT_FORMAT_MAP_CLIENT_PROPERTY, fileFilterInputFormatMap);
        FileFilter firstFF = null;
        if (v == null) {
            v = new SVGView();
        }
        if ((d = ((SVGView)v).getDrawing()) == null) {
            d = ((SVGView)v).createDrawing();
        }
        for (InputFormat format : d.getInputFormats()) {
            FileFilter ff = format.getFileFilter();
            if (firstFF == null) {
                firstFF = ff;
            }
            fileFilterInputFormatMap.put(ff, format);
            c.addChoosableFileFilter(ff);
        }
        c.setFileFilter(firstFF);
        c.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("fileFilterChanged")) {
                    InputFormat inputFormat = (InputFormat)fileFilterInputFormatMap.get(evt.getNewValue());
                    c.setAccessory(inputFormat == null ? null : inputFormat.getInputFormatAccessory());
                }
            }
        });
        return c;
    }

    @Override
    public URIChooser createSaveChooser(Application a, @Nullable View v) {
        JFileURIChooser c;
        block1: {
            Drawing d;
            Iterator<OutputFormat> iterator;
            c = new JFileURIChooser();
            HashMap<FileFilter, OutputFormat> fileFilterOutputFormatMap = new HashMap<FileFilter, OutputFormat>();
            c.putClientProperty(OUTPUT_FORMAT_MAP_CLIENT_PROPERTY, fileFilterOutputFormatMap);
            if (v == null) {
                v = new SVGView();
            }
            if (!(iterator = (d = ((SVGView)v).getDrawing()).getOutputFormats().iterator()).hasNext()) break block1;
            OutputFormat format = iterator.next();
            FileFilter ff = format.getFileFilter();
            fileFilterOutputFormatMap.put(ff, format);
            c.addChoosableFileFilter(ff);
        }
        return c;
    }

    @Override
    public URIChooser createExportChooser(Application a, @Nullable View v) {
        JFileURIChooser c = new JFileURIChooser();
        HashMap<FileFilter, OutputFormat> fileFilterOutputFormatMap = new HashMap<FileFilter, OutputFormat>();
        c.putClientProperty("ffOutputFormatMap", fileFilterOutputFormatMap);
        if (v == null) {
            v = new SVGView();
        }
        Drawing d = ((SVGView)v).getDrawing();
        FileFilter currentFilter = null;
        for (OutputFormat format : d.getOutputFormats()) {
            FileFilter ff = format.getFileFilter();
            fileFilterOutputFormatMap.put(ff, format);
            c.addChoosableFileFilter(ff);
        }
        if (currentFilter != null) {
            c.setFileFilter(currentFilter);
        }
        return c;
    }
}

