/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.draw;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.geom.Point2D;
import java.awt.print.Pageable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import javax.swing.AbstractButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.jhotdraw.app.AbstractView;
import org.jhotdraw.draw.DefaultDrawingEditor;
import org.jhotdraw.draw.DefaultDrawingView;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.ImageFigure;
import org.jhotdraw.draw.QuadTreeDrawing;
import org.jhotdraw.draw.TextAreaFigure;
import org.jhotdraw.draw.TextFigure;
import org.jhotdraw.draw.action.ButtonFactory;
import org.jhotdraw.draw.io.DOMStorableInputOutputFormat;
import org.jhotdraw.draw.io.ImageInputFormat;
import org.jhotdraw.draw.io.ImageOutputFormat;
import org.jhotdraw.draw.io.InputFormat;
import org.jhotdraw.draw.io.OutputFormat;
import org.jhotdraw.draw.io.TextInputFormat;
import org.jhotdraw.draw.print.DrawingPageable;
import org.jhotdraw.gui.PlacardScrollPaneLayout;
import org.jhotdraw.gui.URIChooser;
import org.jhotdraw.net.URIUtil;
import org.jhotdraw.samples.draw.DrawFigureFactory;
import org.jhotdraw.undo.UndoRedoManager;
import org.jhotdraw.util.ResourceBundleUtil;

public class DrawView
extends AbstractView {
    private UndoRedoManager undo;
    private DrawingEditor editor;
    private JScrollPane scrollPane;
    private DefaultDrawingView view;

    public DrawView() {
        this.initComponents();
        this.scrollPane.setLayout(new PlacardScrollPaneLayout());
        this.scrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.setEditor(new DefaultDrawingEditor());
        this.undo = new UndoRedoManager();
        this.view.setDrawing(this.createDrawing());
        this.view.getDrawing().addUndoableEditListener(this.undo);
        this.initActions();
        this.undo.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DrawView.this.setHasUnsavedChanges(DrawView.this.undo.hasSignificantEdits());
            }
        });
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
        JPanel placardPanel = new JPanel(new BorderLayout());
        AbstractButton pButton = ButtonFactory.createZoomButton(this.view);
        pButton.putClientProperty("Quaqua.Button.style", "placard");
        pButton.putClientProperty("Quaqua.Component.visualMargin", new Insets(0, 0, 0, 0));
        pButton.setFont(UIManager.getFont("SmallSystemFont"));
        placardPanel.add((Component)pButton, "West");
        pButton = ButtonFactory.createToggleGridButton(this.view);
        pButton.putClientProperty("Quaqua.Button.style", "placard");
        pButton.putClientProperty("Quaqua.Component.visualMargin", new Insets(0, 0, 0, 0));
        pButton.setFont(UIManager.getFont("SmallSystemFont"));
        labels.configureToolBarButton(pButton, "view.toggleGrid.placard");
        placardPanel.add((Component)pButton, "East");
        this.scrollPane.add((Component)placardPanel, "LOWER_LEFT_CORNER");
    }

    protected Drawing createDrawing() {
        QuadTreeDrawing drawing = new QuadTreeDrawing();
        DOMStorableInputOutputFormat ioFormat = new DOMStorableInputOutputFormat(new DrawFigureFactory());
        drawing.addInputFormat(ioFormat);
        ImageFigure prototype = new ImageFigure();
        drawing.addInputFormat(new ImageInputFormat(prototype));
        drawing.addInputFormat(new TextInputFormat(new TextFigure()));
        TextAreaFigure taf = new TextAreaFigure();
        taf.setBounds(new Point2D.Double(10.0, 10.0), new Point2D.Double(60.0, 40.0));
        drawing.addInputFormat(new TextInputFormat(taf));
        drawing.addOutputFormat(ioFormat);
        drawing.addOutputFormat(new ImageOutputFormat());
        return drawing;
    }

    public Pageable createPageable() {
        return new DrawingPageable(this.view.getDrawing());
    }

    private void initActions() {
        this.getActionMap().put("edit.undo", this.undo.getUndoAction());
        this.getActionMap().put("edit.redo", this.undo.getRedoAction());
    }

    @Override
    protected void setHasUnsavedChanges(boolean newValue) {
        super.setHasUnsavedChanges(newValue);
        this.undo.setHasSignificantEdits(newValue);
    }

    @Override
    public void write(URI f, URIChooser fc) throws IOException {
        Drawing drawing = this.view.getDrawing();
        OutputFormat outputFormat = drawing.getOutputFormats().get(0);
        outputFormat.write(f, drawing);
    }

    @Override
    public void read(URI f, URIChooser fc) throws IOException {
        try {
            final Drawing drawing = this.createDrawing();
            boolean success = false;
            for (InputFormat sfi : drawing.getInputFormats()) {
                try {
                    sfi.read(f, drawing, true);
                    success = true;
                    break;
                }
                catch (Exception exception) {
                }
            }
            if (!success) {
                ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.app.Labels");
                throw new IOException(labels.getFormatted("file.open.unsupportedFileFormat.message", URIUtil.getName(f)));
            }
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    DrawView.this.view.getDrawing().removeUndoableEditListener(DrawView.this.undo);
                    DrawView.this.view.setDrawing(drawing);
                    DrawView.this.view.getDrawing().addUndoableEditListener(DrawView.this.undo);
                    DrawView.this.undo.discardAllEdits();
                }
            });
        }
        catch (InterruptedException e) {
            InternalError error = new InternalError();
            e.initCause(e);
            throw error;
        }
        catch (InvocationTargetException e) {
            InternalError error = new InternalError();
            error.initCause(e);
            throw error;
        }
    }

    public void setEditor(DrawingEditor newValue) {
        if (this.editor != null) {
            this.editor.remove(this.view);
        }
        this.editor = newValue;
        if (this.editor != null) {
            this.editor.add(this.view);
        }
    }

    public DrawingEditor getEditor() {
        return this.editor;
    }

    @Override
    public void clear() {
        final Drawing newDrawing = this.createDrawing();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    DrawView.this.view.getDrawing().removeUndoableEditListener(DrawView.this.undo);
                    DrawView.this.view.setDrawing(newDrawing);
                    DrawView.this.view.getDrawing().addUndoableEditListener(DrawView.this.undo);
                    DrawView.this.undo.discardAllEdits();
                }
            });
        }
        catch (InvocationTargetException ex) {
            ex.printStackTrace();
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean canSaveTo(URI file) {
        return new File(file).getName().endsWith(".xml");
    }

    private void initComponents() {
        this.scrollPane = new JScrollPane();
        this.view = new DefaultDrawingView();
        this.setLayout(new BorderLayout());
        this.scrollPane.setHorizontalScrollBarPolicy(32);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.scrollPane.setViewportView(this.view);
        this.add((Component)this.scrollPane, "Center");
    }
}

