/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.app.action.app;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jhotdraw.app.Application;
import org.jhotdraw.app.View;
import org.jhotdraw.app.action.AbstractApplicationAction;
import org.jhotdraw.gui.JSheet;
import org.jhotdraw.gui.Worker;
import org.jhotdraw.gui.event.SheetEvent;
import org.jhotdraw.gui.event.SheetListener;
import org.jhotdraw.net.URIUtil;
import org.jhotdraw.util.ResourceBundleUtil;

public class OpenApplicationFileAction
extends AbstractApplicationAction {
    public static final String ID = "application.openFile";
    private JFileChooser fileChooser;
    private int entries;

    public OpenApplicationFileAction(Application app) {
        super(app);
        this.putValue("Name", "OSX Open File");
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Application app = this.getApplication();
        String filename = evt.getActionCommand();
        if (app.isEnabled()) {
            View p;
            app.setEnabled(false);
            View emptyView = app.getActiveView();
            if (emptyView == null || emptyView.getURI() != null || emptyView.hasUnsavedChanges()) {
                emptyView = null;
            }
            if (emptyView == null) {
                p = app.createView();
                app.add(p);
                app.show(p);
            } else {
                p = emptyView;
            }
            this.openView(p, new File(filename).toURI());
        }
    }

    protected void openView(final View view, final URI uri) {
        Application app = this.getApplication();
        app.setEnabled(true);
        int multipleOpenId = 1;
        for (View aView : app.views()) {
            if (aView == view || aView.getURI() == null || !aView.getURI().equals(uri)) continue;
            multipleOpenId = Math.max(multipleOpenId, aView.getMultipleOpenId() + 1);
        }
        view.setMultipleOpenId(multipleOpenId);
        view.setEnabled(false);
        view.execute(new Worker(){

            protected Object construct() throws IOException {
                boolean exists = true;
                try {
                    File f = new File(uri);
                    exists = f.exists();
                }
                catch (IllegalArgumentException f) {
                    // empty catch block
                }
                if (exists) {
                    view.read(uri, null);
                    return null;
                }
                ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.app.Labels");
                throw new IOException(labels.getFormatted("file.open.fileDoesNotExist.message", URIUtil.getName(uri)));
            }

            protected void done(Object value) {
                view.setURI(uri);
                Frame w = (Frame)SwingUtilities.getWindowAncestor(view.getComponent());
                if (w != null) {
                    w.setExtendedState(w.getExtendedState() & 0xFFFFFFFE);
                    w.toFront();
                }
                view.setEnabled(true);
                view.getComponent().requestFocus();
            }

            @Override
            protected void failed(Throwable value) {
                value.printStackTrace();
                String message = value.getMessage() != null ? value.getMessage() : value.toString();
                ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.app.Labels");
                JSheet.showMessageSheet(view.getComponent(), "<html>" + UIManager.getString("OptionPane.css") + "<b>" + labels.getFormatted("file.open.couldntOpen.message", URIUtil.getName(uri)) + "</b><p>" + (message == null ? "" : message), 0, new SheetListener(){

                    @Override
                    public void optionSelected(SheetEvent evt) {
                        view.setEnabled(true);
                    }
                });
            }
        });
    }
}

