/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.svg;

import java.awt.Dimension;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.IOUtils;
import org.apache.fop.events.EventBroadcaster;
import org.apache.fop.render.bitmap.BitmapRendererEventProducer;
import org.apache.fop.render.bitmap.MultiFileRenderingUtil;
import org.apache.fop.render.intermediate.DelegatingFragmentContentHandler;
import org.apache.fop.render.intermediate.IFException;
import org.apache.fop.render.intermediate.IFPainter;
import org.apache.fop.render.svg.AbstractSVGDocumentHandler;
import org.apache.fop.render.svg.SVGPainter;
import org.apache.fop.render.svg.SVGUtil;
import org.apache.fop.util.GenerationHelperContentHandler;
import org.apache.fop.util.XMLUtil;
import org.w3c.dom.Document;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SVGDocumentHandler
extends AbstractSVGDocumentHandler {
    private MultiFileRenderingUtil multiFileUtil;
    private StreamResult firstStream;
    private StreamResult currentStream;
    private Result simpleResult;
    private Document reusedParts;

    public boolean supportsPagesOutOfOrder() {
        return true;
    }

    public String getMimeType() {
        return "image/svg+xml";
    }

    public void setResult(Result result) throws IFException {
        if (result instanceof StreamResult) {
            this.multiFileUtil = new MultiFileRenderingUtil("svg", this.getUserAgent().getOutputFile());
            this.firstStream = (StreamResult)result;
        } else {
            this.simpleResult = result;
        }
    }

    public void startDocument() throws IFException {
        super.startDocument();
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        builderFactory.setNamespaceAware(true);
        builderFactory.setValidating(false);
        try {
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            this.reusedParts = builder.newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new IFException("Error while setting up a DOM for SVG generation", (Exception)e);
        }
        try {
            TransformerHandler toDOMHandler = this.tFactory.newTransformerHandler();
            toDOMHandler.setResult(new DOMResult(this.reusedParts));
            this.handler = this.decorate(toDOMHandler);
            this.handler.startDocument();
        }
        catch (SAXException se) {
            throw new IFException("SAX error in startDocument()", (Exception)se);
        }
        catch (TransformerConfigurationException e) {
            throw new IFException("Error while setting up a TransformerHandler for SVG generation", (Exception)e);
        }
    }

    public void endDocument() throws IFException {
    }

    public void endDocumentHeader() throws IFException {
        super.endDocumentHeader();
        try {
            this.handler.endDocument();
            this.handler = null;
        }
        catch (SAXException e) {
            throw new IFException("SAX error in endDocumentHeader()", (Exception)e);
        }
    }

    public void startPageSequence(String id) throws IFException {
    }

    public void endPageSequence() throws IFException {
    }

    public void startPage(int index, String name, String pageMasterName, Dimension size) throws IFException {
        if (this.multiFileUtil != null) {
            this.prepareHandlerWithOutputStream(index);
        } else {
            if (this.simpleResult == null) {
                throw new IFException("Only one page is supported for output with the given Result instance!", null);
            }
            super.setResult(this.simpleResult);
            this.simpleResult = null;
        }
        try {
            this.handler.startDocument();
            this.handler.startPrefixMapping("", "http://www.w3.org/2000/svg");
            this.handler.startPrefixMapping("xlink", "http://www.w3.org/1999/xlink");
            AttributesImpl atts = new AttributesImpl();
            XMLUtil.addAttribute((AttributesImpl)atts, (String)"version", (String)"1.1");
            XMLUtil.addAttribute((AttributesImpl)atts, (String)"width", (String)(SVGUtil.formatMptToPt(size.width) + "pt"));
            XMLUtil.addAttribute((AttributesImpl)atts, (String)"height", (String)(SVGUtil.formatMptToPt(size.height) + "pt"));
            XMLUtil.addAttribute((AttributesImpl)atts, (String)"viewBox", (String)("0 0 " + SVGUtil.formatMptToPt(size.width) + " " + SVGUtil.formatMptToPt(size.height)));
            this.handler.startElement("svg", (Attributes)atts);
            try {
                Transformer transformer = this.tFactory.newTransformer();
                DOMSource src = new DOMSource(this.reusedParts.getDocumentElement());
                SAXResult res = new SAXResult((ContentHandler)new DelegatingFragmentContentHandler((ContentHandler)this.handler));
                transformer.transform(src, res);
            }
            catch (TransformerConfigurationException tce) {
                throw new IFException("Error setting up a Transformer", (Exception)tce);
            }
            catch (TransformerException te) {
                if (te.getCause() instanceof SAXException) {
                    throw (SAXException)te.getCause();
                }
                throw new IFException("Error while serializing reused parts", (Exception)te);
            }
        }
        catch (SAXException e) {
            throw new IFException("SAX error in startPage()", (Exception)e);
        }
    }

    private void prepareHandlerWithOutputStream(int index) throws IFException {
        OutputStream out;
        try {
            if (index == 0) {
                out = null;
            } else {
                out = this.multiFileUtil.createOutputStream(index);
                if (out == null) {
                    BitmapRendererEventProducer eventProducer = BitmapRendererEventProducer.Provider.get((EventBroadcaster)this.getUserAgent().getEventBroadcaster());
                    eventProducer.stoppingAfterFirstPageNoFilename((Object)this);
                }
            }
        }
        catch (IOException ioe) {
            throw new IFException("I/O exception while setting up output file", (Exception)ioe);
        }
        if (out == null) {
            this.handler = this.decorate(this.createContentHandler(this.firstStream));
        } else {
            this.currentStream = new StreamResult(out);
            this.handler = this.decorate(this.createContentHandler(this.currentStream));
        }
    }

    private GenerationHelperContentHandler decorate(ContentHandler contentHandler) {
        return new GenerationHelperContentHandler(contentHandler, this.getMainNamespace());
    }

    private void closeCurrentStream() {
        if (this.currentStream != null) {
            IOUtils.closeQuietly((OutputStream)this.currentStream.getOutputStream());
            this.currentStream.setOutputStream(null);
            IOUtils.closeQuietly((Writer)this.currentStream.getWriter());
            this.currentStream.setWriter(null);
            this.currentStream = null;
        }
    }

    public IFPainter startPageContent() throws IFException {
        try {
            this.handler.startElement("g");
        }
        catch (SAXException e) {
            throw new IFException("SAX error in startPageContent()", (Exception)e);
        }
        return new SVGPainter(this, this.handler);
    }

    public void endPageContent() throws IFException {
        try {
            this.handler.endElement("g");
        }
        catch (SAXException e) {
            throw new IFException("SAX error in endPageContent()", (Exception)e);
        }
    }

    public void endPage() throws IFException {
        try {
            this.handler.endElement("svg");
            this.handler.endDocument();
        }
        catch (SAXException e) {
            throw new IFException("SAX error in endPage()", (Exception)e);
        }
        this.closeCurrentStream();
    }
}

