/*
 * Decompiled with CFR 0.152.
 */
package rootio;

import hep.io.root.RootClassNotFound;
import hep.io.root.RootFileReader;
import hep.io.root.RootObject;
import hep.io.root.interfaces.TDirectory;
import hep.io.root.interfaces.TGraph;
import hep.io.root.interfaces.TH1;
import hep.io.root.interfaces.TH2;
import hep.io.root.interfaces.TKey;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import jhplot.H1D;
import jhplot.H2D;
import jhplot.P1D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileRoot {
    private RootFileReader rfr = null;
    private TDirectory current = null;

    public FileRoot(String file) {
        try {
            this.rfr = new RootFileReader(file);
            this.current = null;
        }
        catch (IOException e) {
            System.err.println("Error in openning file");
        }
    }

    public FileRoot(URL url) {
        try {
            this.rfr = new RootFileReader(url);
            this.current = null;
        }
        catch (IOException e) {
            System.err.println("Error in openning file");
        }
    }

    public TDirectory cd(String dir) {
        this.current = null;
        String[] dirs = dir.split("/");
        if (dirs.length == 0) {
            return null;
        }
        TKey key = this.rfr.getKey(dirs[0]);
        for (int j = 1; j < dirs.length; ++j) {
            String d = dirs[j];
            try {
                this.current = (TDirectory)key.getObject();
            }
            catch (RootClassNotFound e) {
                System.err.println("No such name");
            }
            catch (IOException e) {
                System.err.println("No such directory");
            }
            key = this.current.getKey(d);
        }
        try {
            this.current = (TDirectory)key.getObject();
        }
        catch (RootClassNotFound e) {
            System.err.println("No such name");
        }
        catch (IOException e) {
            System.err.println("No such name");
        }
        return this.current;
    }

    public String toString() {
        String tmp;
        block3: {
            block2: {
                tmp = this.getTitle() + "\n";
                tmp = tmp + this.getVersion() + "\n";
                if (this.current != null || this.rfr == null) break block2;
                for (int i = 0; i < this.rfr.nKeys(); ++i) {
                    TKey k = this.rfr.getKey(i);
                    String s = k.getName();
                    String ss = Integer.toString(i) + "  " + s + "\n";
                    tmp = tmp + ss;
                }
                break block3;
            }
            if (this.current == null) break block3;
            for (int i = 0; i < this.current.nKeys(); ++i) {
                TKey k = this.current.getKey(i);
                String s = k.getName();
                String ss = Integer.toString(i) + "  " + s + "\n";
                tmp = tmp + ss;
            }
        }
        return tmp;
    }

    public ArrayList<String> getKeys() {
        ArrayList<String> tmp = null;
        if (this.current == null) {
            tmp = new ArrayList<String>(this.rfr.nKeys());
            for (int i = 0; i < this.rfr.nKeys(); ++i) {
                TKey k = this.rfr.getKey(i);
                tmp.add(k.getName());
            }
        } else {
            tmp = new ArrayList(this.current.nKeys());
            for (int i = 0; i < this.current.nKeys(); ++i) {
                TKey k = this.current.getKey(i);
                tmp.add(k.getName());
            }
        }
        return tmp;
    }

    public int getVersion() {
        if (this.rfr != null) {
            return this.rfr.getVersion();
        }
        return 1;
    }

    public int getNKeys() {
        if (this.current == null) {
            return this.rfr.nKeys();
        }
        return this.current.nKeys();
    }

    public String getTitle() {
        if (this.rfr != null && this.rfr.getTitle() != null) {
            return this.rfr.getTitle();
        }
        return "no title";
    }

    public TKey getKey(int i) {
        if (this.current == null) {
            return this.rfr.getKey(i);
        }
        return this.current.getKey(i);
    }

    public List getInfo() {
        try {
            return this.rfr.streamerInfo();
        }
        catch (IOException e) {
            System.err.println("No streamer info");
            return null;
        }
    }

    public TKey getKey(String skey) {
        return this.rfr.getKey(skey);
    }

    public RootFileReader getReader() {
        return this.rfr;
    }

    public H1D getH1D(String skey) {
        TKey k = null;
        k = this.current == null ? this.rfr.getKey(skey) : this.current.getKey(skey);
        RootObject obj = null;
        try {
            obj = k.getObject();
            String name = obj.getClass().getName();
            if (name == "hep.io.root.proxy.TH1F" || name == "hep.io.root.proxy.TH1D") {
                return new H1D((TH1)obj);
            }
        }
        catch (RootClassNotFound e) {
            System.err.println("No such name");
        }
        catch (IOException e) {
            System.err.println("No such object");
        }
        return null;
    }

    public H2D getH2D(String skey) {
        TKey k = null;
        k = this.current == null ? this.rfr.getKey(skey) : this.current.getKey(skey);
        RootObject obj = null;
        try {
            obj = k.getObject();
            String name = obj.getClass().getName();
            if (name == "hep.io.root.proxy.TH2F" || name == "hep.io.root.proxy.TH2D") {
                return new H2D((TH2)obj);
            }
        }
        catch (RootClassNotFound e) {
            System.err.println("No such name");
        }
        catch (IOException e) {
            System.err.println("No such object");
        }
        return null;
    }

    public P1D getP1D(String skey) {
        TKey k = null;
        k = this.current == null ? this.rfr.getKey(skey) : this.current.getKey(skey);
        RootObject obj = null;
        try {
            obj = k.getObject();
            String name = obj.getClass().getName();
            if (name == "hep.io.root.proxy.TGraph") {
                TGraph tt = (TGraph)obj;
                String tname = tt.getTitle();
                double[] x = tt.getX();
                double[] y = tt.getY();
                return new P1D(tname, x, y);
            }
        }
        catch (RootClassNotFound e) {
            System.err.println("No such name");
        }
        catch (IOException e) {
            System.err.println("No such object");
        }
        return null;
    }

    public Object get(String skey) {
        TKey k = null;
        k = this.current == null ? this.rfr.getKey(skey) : this.current.getKey(skey);
        RootObject obj = null;
        try {
            obj = k.getObject();
            String name = obj.getClass().getName();
            if (name == "hep.io.root.proxy.TGraph") {
                TGraph tt = (TGraph)obj;
                String title = tt.getTitle();
                double[] x = tt.getX();
                double[] y = tt.getY();
                return new P1D(title, x, y);
            }
            if (name != "hep.io.root.proxy.TGraphErrors" && name != "hep.io.root.proxy.TGraphAsymmErrors") {
                if (name == "hep.io.root.proxy.TH1F" || name == "hep.io.root.proxy.TH1D") {
                    return new H1D((TH1)obj);
                }
                if (name == "hep.io.root.proxy.TH2F" || name == "hep.io.root.proxy.TH2D") {
                    return new H2D((TH2)obj);
                }
                return obj;
            }
        }
        catch (RootClassNotFound e) {
            System.err.println("No such name");
        }
        catch (IOException e) {
            System.err.println("No such object");
        }
        return obj;
    }

    public Object getObject(String skey) {
        TKey k = null;
        k = this.current == null ? this.rfr.getKey(skey) : this.current.getKey(skey);
        try {
            return k.getObject();
        }
        catch (RootClassNotFound e) {
            System.err.println("No such name");
        }
        catch (IOException e) {
            System.err.println("No such object");
        }
        return null;
    }

    public Object getObject(int i) {
        TKey k = null;
        k = this.current == null ? this.rfr.getKey(i) : this.current.getKey(i);
        try {
            return k.getObject();
        }
        catch (RootClassNotFound e) {
            System.err.println("No such class");
        }
        catch (IOException e) {
            System.err.println("No such object");
        }
        return null;
    }
}

